#!/bin/sh
# rc.S:  System initialization script that runs at the
#        very beginning of booting.
#
# Originally from Slackware 10.0
# Mostly written by:  Patrick J. Volkerding, <volkerdi@ftp.cdrom.com>
#
# Adapted for Vector Linux by 
# Eko M. Budi, Robert S. Lange, Tony Brijeski, Uel Archuletta
#

. /etc/rc.d/functions-display

PATH=/sbin:/usr/sbin:/bin:/usr/bin

dmesg -n 1

# Mount /proc right away:
echo "Mounting /proc file system" 
/sbin/mount -v proc /proc -n -t proc

#Set YES if you want a "rainbow-technicolor" initialization
export  RCINITCOLORS="YES" 

echoc "==> rc.S  Setting up the base system configuration" yellow
echoc "Initializing kernel file systems" cyan

# Mount sysfs next, if the kernel supports it:
if [ -d /sys ]; then
  if cat /proc/filesystems | grep -w sysfs 1> /dev/null 2> /dev/null ; then
    if ! cat /proc/mounts | grep -w sysfs 1> /dev/null 2> /dev/null ; then
      echo "Starting sysfs"
      /sbin/mount -v sysfs /sys -n -t sysfs
    fi
  fi
fi

# If /run exists, mount a tmpfs on it (unless the
# initrd has already done so):
if [ -d /run ]; then
  if ! grep -wq "tmpfs /run tmpfs" /proc/mounts ; then
    /sbin/mount -v -n -t tmpfs tmpfs /run -o mode=0755
  fi
fi
  
if grep -wq sysfs /proc/mounts && grep -q tmpfs /proc/filesystems ; then
  if ! grep -wq nohotplug /proc/cmdline ; then
    if [ -x /etc/rc.d/rc.udev ]; then
      /bin/sh /etc/rc.d/rc.udev start
    fi
  fi
fi

# Mount Control Groups filesystem interface:
if grep -wq cgroup /proc/filesystems ; then
  if [ -d /sys/fs/cgroup ]; then
    mount -t cgroup cgroup /sys/fs/cgroup
  else
    mkdir -p /dev/cgroup
    mount -t cgroup cgroup /dev/cgroup
  fi
fi

# Start file systems
echoc "Mounting local file systems" cyan

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no

if touch /fsrwtestfile 2>/dev/null; then
  rm -f /fsrwtestfile
  READWRITE=yes
else
  echo "Testing root filesystem status:  read-only filesystem"
fi

# See if a forced filesystem check was requested at shutdown:
if [ -r /etc/forcefsck ]; then
  FORCEFSCK="-f"
fi

echo "e2fsck time fix"
if grep "^UTC" /etc/hardwareclock 1> /dev/null 2> /dev/null ; then
    /sbin/hwclock --utc --hctosys 
else
    /sbin/hwclock --localtime --hctosys 
fi

# Check the root filesystem:
if [ ! $READWRITE = yes ]; then
  if [ ! -r /etc/fastboot ]; then
    echo "Checking root filesystem"
    /sbin/fsck $FORCEFSCK -C -a /
    RETVAL=$?
  fi

# An error code of 2 or higher will require a reboot.
  if [ $RETVAL -ge 2 ]; then
    # An error code equal to or greater than 4 means that some errors
    # could not be corrected.  This requires manual attention, so we
    # offer a chance to try to fix the problem in single-user mode:
    if [ $RETVAL -ge 4 ]; then
      echo
      echo
      echo "***********************************************************"
      echo "*** An error occurred during the root filesystem check. ***"
      echo "*** You will now be given a chance to log into the      ***"
      echo "*** system in single-user mode to fix the problem.      ***"
      echo "***                                                     ***"
      echo "*** If you are using the ext2 filesystem, running       ***"
      echo "*** 'e2fsck -v -y <partition>' might help.              ***"
      echo "***********************************************************"
      echo
      echo "Once you exit the single-user shell, the system will reboot."
      echo
      PS1="(Repair filesystem) \#"; export PS1
      sulogin
    else # With an error code of 2 or 3, reboot the machine automatically:
      echo
      echo
      echo "***********************************"
      echo "*** The filesystem was changed. ***"
      echo "*** The system will now reboot. ***"
      echo "***********************************"
      echo
    fi

    echo "Unmounting file systems."
    umount -a -r
    mount -n -o remount,ro /
    echo "Rebooting system."
    sleep 2
    reboot -f
  fi

# Remount the root filesystem in read-write mode
  echo "Remounting root device with read-write enabled."
  /sbin/mount -w -v -n -o remount /
  if [ $? -gt 0 ] ; then
    echo
    echo "Attempt to remount root device as read-write failed!  This is going to"
    echo "cause serious problems."
    echo 
    echo "If you're using the UMSDOS filesystem, you **MUST** mount the root partition"
    echo "read-write!  You can make sure the root filesystem is getting mounted "
    echo "read-write with the 'rw' flag to Loadlin:"
    echo
    echo "loadlin vmlinuz root=/dev/hda1 rw   (replace /dev/hda1 with your root device)"
M    echo
    echo "Normal bootdisks can be made to mount a system read-write with the rdev command:"
    echo
    echo "rdev -R /dev/fd0 0"
    echo
    echo "You can also get into your system by using a boot disk with a command like this"
    echo "on the LILO prompt line:  (change the root partition name as needed)"
    echo 
    echo "LILO: mount root=/dev/hda1 rw"
    echo
    echo "Please press ENTER to continue, then reboot and use one of the above methods to"
    echo -n "get into your machine and start looking for the problem. " 
    read junk; 
  fi

else
  echo "Testing filesystem status: read-write filesystem"
  if cat /etc/fstab | grep ' / ' | grep umsdos 1> /dev/null 2> /dev/null ; then
    ROOTTYPE="umsdos"
  fi

  if [ ! "$ROOTTYPE" = "umsdos" ]; then # no warn for UMSDOS
    echo
    echo "*** ERROR: Root partition has already been mounted read-write. Cannot check!"
    echo
    echo "For filesystem checking to work properly, your system must initially mount"
    echo "the root partition as read only. Please modify your kernel with 'rdev' so that"
    echo "it does this. If you're booting with LILO, add a line:"
    echo
    echo "   read-only"
    echo
    echo "to the Linux section in your /etc/lilo.conf and type 'lilo' to reinstall it."
    echo
    echo "If you boot from a kernel on a floppy disk, put it in the drive and type:"
    echo "   rdev -R /dev/fd0 1"
    echo
    echo "If you boot from a bootdisk, or with Loadlin, you can add the 'ro' flag."
    echo
    echo "This will fix the problem *AND* eliminate this annoying message. :^)"
    echo
    echo -n "Press ENTER to continue. "
    read junk;
  fi
fi # Done checking root filesystem

# Any /etc/mtab that exists here is old, so we delete it to start over:
/bin/rm -f /etc/mtab{,~,.tmp} && /bin/touch /etc/mtab

# Add entry for / to /etc/mtab:
/sbin/mount -f -w /

# Add /proc and /sys mounts to /etc/mtab:
if [ -d /proc/sys ]; then
  /sbin/mount -f proc /proc -t proc
fi
if [ -d /sys/bus ]; then
  /sbin/mount -f sysfs /sys -t sysfs
fi

##-------------------------------------------------------
## SWAP and LOCAL FILE SYSTEM

## Start swap and update
echoc "Activating swap file" cyan
swapon -a 
#/sbin/update &
swapon -s

##-------------------------------------------------------


#--------------------------------------------------------------------------------
# Additional file system now
#echo 1 > /sys/power/tuxonice/do_resume 2>/dev/null

# Initialize the Logical Volume Manager.
# This won't start unless we find /etc/lvmtab (LVM1) or 
# /etc/lvm/backup/ (LVM2).  This is created by /sbin/vgscan, so to
# use LVM you must run /sbin/vgscan yourself the first time (and
# create some VGs and LVs).
if [ -r /etc/lvmtab -o -d /etc/lvm/backup ]; then
  echo "Initializing LVM (Logical Volume Manager)"
  # Check for device-mapper support.
  if ! cat /proc/devices | grep -w device-mapper 1> /dev/null 2> /dev/null ; then
    # If device-mapper exists as a module, try to load it.
    if [ -r /lib/modules/$(cat /proc/sys/kernel/osrelease)/kernel/drivers/md/dm-mod.ko ]; then
      insmod /lib/modules/$(cat /proc/sys/kernel/osrelease)/kernel/drivers/md/dm-mod.ko
    fi
  fi

  # Scan for new volume groups:
  /sbin/vgscan 2> /dev/null
  if [ $? = 0 ]; then
    # This needs a moment to register.
    sleep 10
    # Make volume groups available to the kernel.
    # This should also make logical volumes available.
    /sbin/vgchange -ay
    # Enable swapping again in case any LVs are used for swap.  Ignore previous error.  :-)
    /sbin/swapon -a
  fi
fi

# Check all the non-root filesystems:
if [ ! -r /etc/fastboot ]; then
  echo "Checking non-root filesystems"
  /sbin/fsck $FORCEFSCK -C -R -A -a 
fi

## mount file systems in fstab (and create an entry for /)
## but not NFS,SAMBA because TCP/IP is not yet configured
echo "Mounting local file systems"
/sbin/mount -a -v -t nonfs,nosmbfs,noncpfs,noproc 
/sbin/mount -a

## Start ldconfig in the background
echo "Updating local libraries"
ldconfig &

      

## Attempt to umount and remove any leftover /initrd:
if [ -d /initrd ]; then
  echo "Umounting initrd"
  umount /initrd 2> /dev/null
  rmdir /initrd 2> /dev/null
  blockdev --flushbufs /dev/ram0 2> /dev/null
fi

## Mount tmpfs if requested
if [ -x /etc/rc.d/rc.tmpfs ]; then
  echo "Mounting tmpfs"
  /etc/rc.d/rc.tmpfs
fi

## Syncronizing if we run from MSDOS
if [ "$ROOTTYPE" = "umsdos" ]; then # we need to update any files added in DOS:
  echo "Synchronizing UMSDOS directory structure:"
  echo "  /sbin/umssync -r99 -v- /"
  /sbin/umssync -r99 -v- /
fi

## Filesystem is done

plymouth update-root-fs --read-write
##--------------------------------------------------------------------------
echoc "Resetting the system so the game can start " cyan

# Remove undesired things
echo "Removing stale lock, temporary and junk files"


rm -f /etc/nologin /etc/shutdownpid /etc/dhcpc/*.pid /etc/forcefsck /etc/fastboot &> /dev/null

# Remove stale locks and junk files 
rm -f /var/lock/* /var/lock/subsys/* /var/spool/uucp/LCK..* \
   /var/run/utmp /var/run/*pid /var/run/lpd* /var/run/ppp* /var/run/usb/* &> /dev/null
( cd /var/log/setup/tmp && rm -rf * )

rm -rf /tmp/* /tmp/.X* /install /core /tmp/.I* &> /dev/null

# Remove stale hunt sockets.
[ -r /tmp/hunt -o -r /tmp/hunt.stats ] && rm -f /tmp/hunt* &> /dev/null

## Ensure basic filesystem permissions sanity.
echo "Ensuring basic filesystem permissions sanity" 
chmod 755 /
mkdir -p /tmp/.ICE-unix /tmp/.X11-unix
chmod 1777 /tmp /var/tmp /tmp/.ICE-unix /tmp/.X11-unix

## Looks like we have to create this.
#mkdir -p /var/log/lastlog

## Create a fresh utmp file:
touch /var/run/utmp
chown root.utmp /var/run/utmp
chmod 664 /var/run/utmp

# Launch any script in /var/log/setup/init
# Kinda like Windows  style of "reboot to continue setup" :)
# Hmmm is it a security hole ?
for fsetup in /var/log/setup/init/*; do
    if [ -x $fsetup ]; then
	$fsetup 2>&1 | tee -a /var/log/installation.log
	rm -f $fsetup
        sleep 1
	echoc "Continuing system initialization" cyan
    fi
done

#----------------------------------------------------------------------------
# BASIC HARDWARE
## Very basic hardware, just enough to setup the local filesystem
echocl "Initializing basic system" cyan

# If there's no /etc/HOSTNAME, fall back on this default:
if [ ! -r /etc/HOSTNAME ]; then
  echo "vector.linux.vnet" > /etc/HOSTNAME
fi

# Set the hostname.
HOSTNAME=`cat /etc/HOSTNAME`
echol "Setting hostname: $HOSTNAME"
/bin/hostname ${HOSTNAME}  >> $INITLOG 2>&1

# Initialize udev to manage /dev entries for 2.6.x kernels:
##if [ -x /etc/rc.d/rc.udev ]; then
##  if ! grep -w nohotplug /proc/cmdline 1> /dev/null 2> /dev/null ; then
##     echo "Starting udev"
##    /etc/rc.d/rc.udev restart  &
##  fi
##fi

# Set the system time from the hardware clock using hwclock --hctosys.
if ! grep -qw nohwclock /proc/cmdline && [ -x /sbin/hwclock ]; then
  if ! grep -q -w rtc /proc/ioports ; then
    CLOCK_OPT="--directisa"
  fi
  if grep "^UTC" /etc/hardwareclock 1> /dev/null 2> /dev/null ; then
    echo "Setting system time from the hardware clock (UTC)."
    /sbin/hwclock $CLOCK_OPT --utc --hctosys >> $INITLOG 2>&1
  else
    echo "Setting system time from the hardware clock (localtime)."
    /sbin/hwclock $CLOCK_OPT --localtime --hctosys >> $INITLOG 2>&1
  fi
fi

      
# Carry an entropy pool between reboots to improve randomness.
if [ -f /etc/random-seed ]; then
  echol "Using /etc/random-seed to initialize /dev/urandom."
  cat /etc/random-seed >/dev/urandom
fi

# Use the pool size from /proc, or 512 bytes:
if [ -r /proc/sys/kernel/random/poolsize ]; then
  dd if=/dev/urandom of=/etc/random-seed count=1 \
     bs=$(cat /proc/sys/kernel/random/poolsize) >> $INITLOG 2>&1
else
  dd if=/dev/urandom of=/etc/random-seed count=1 bs=512 >> $INITLOG 2>&1
fi
chmod 600 /etc/random-seed

## Load a custom keymap
if [ -x /etc/rc.d/rc.keymap ] ; then
  echol "Setting up keymap"
  /etc/rc.d/rc.keymap  >> $INITLOG 2>&1
fi

## Screen blanks after 15 minutes idle time.
/bin/setterm -blank 0   >> $INITLOG 2>&1

## Hardware is done, for now
## Will do advanced harware initialization on rc.M


# Configure runtime kernel parameters:
if [ -x /sbin/sysctl -a -r /etc/sysctl.conf ]; then
  echol "Setting up kernel run time parameters"
  /sbin/sysctl -e -p /etc/sysctl.conf >> $INITLOG 2>&1
fi

#echoc "Startup initialization is done" green

