#!/bin/sh

# -<colour codes>--------------------------------
PS_BLACK="\[\033[0;30m\]" # Black
PS_DARK="\[\033[1;30m\]"  # Black (Light) / Dark Gray

PS_DRED="\[\033[0;31m\]" # Red (Dark)
PS_RED="\[\033[1;31m\]"  # Red

PS_DGREEN="\[\033[0;32m\]" # Green (Dark)
PS_GREEN="\[\033[1;32m\]"  # Green

PS_BROWN="\[\033[0;33m\]" # Yellow (Dark) / Orange
PS_YELLOW="\[\033[1;33m\]"  # Yellow

PS_DBLUE="\[\033[0;34m\]" # Blue (Dark)
PS_BLUE="\[\033[1;34m\]"  # Blue

PS_DPURPLE="\[\033[0;35m\]" # Purple (Dark)
PS_PURPLE="\[\033[1;35m\]"  # Purple

PS_DCYAN="\[\033[0;36m\]" # Cyan (Dark)
PS_CYAN="\[\033[1;36m\]"  # Cyan

PS_DGRAY="\[\033[0;37m\]" # White (dark) / Light Gray
PS_GRAY="\[\033[1;37m\]"  # White

PS_WHITE="\[\033[0;38m\]" # White 
PS_BWHITE="\[\033[1;38m\]"  # White Bold

PS_NORMAL="\[\033[0;39m\]" # White 
PS_BOLD="\[\033[1;39m\]"  # White Bold
# -</colour codes>-------------------------------

if [ "$UID" = 0 ]; then
   echoc "You are working as root" red
   export PATH="$PATH:/usr/local/sbin:/usr/sbin:/sbin"
   if [ -z "$USER" ] || [ "$USER" != "root" ]; then
      UHOME=$(egrep "^$USER:" /etc/passwd | cut -f6 -d:)
      if [ -f $UHOME/.Xauthority ]; then
	 # echo "Enabling X-Window $UHOME/.Xauthority"
	 cp $UHOME/.Xauthority /root
      fi
   fi
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"
   echo "Package manager: slapt-get, pkg"
   echo "Network tools  : ifconfig, host, ping, nmap, iptables"
else
   echoc "You are working as $USER" green
   echoc "Frequently used programs:" cyan
   echo "Configuration  : vasm"

   ## If the user has has a unique group (Redhat system)
   ## set the umask 002 to allows owner and group writable.
   if grep -qe "^$USER:" /etc/group &>/dev/null; then
      umask=002
   fi
fi

echo "File manager   : mc (press F2 for useful menu)"
echo "Editor         : mcedit, nano, vi"
echo "Multimedia     : alsamixer, play"

if [ -z "$(skill -n X)" ]; then
which startx &>/dev/null        && echo "Default X      : startx"
which starticewm &>/dev/null    && echo "IceWM          : starticewm, starticewm-desk, starticewm-sound"
which startfluxbox &>/dev/null  && echo "Fluxbox        : startfluxbox, startfluxbox-desk"
which startxfce4 &>/dev/null    && echo "XFCE4          : startxfce4"
#which startkde &>/dev/null      && echo "KDE            : startkde"
fi

## Set a default shell prompt:
PS1="${PS_CYAN}\h:/\w${PS_NORMAL}\n\u:\\$ "
PS2="> "

## for development ...
export PKG_CONFIG_PATH="/usr/X11R6/lib/pkgconfig:$PKG_CONFIG_PATH"
if [[ "$ARCH" = i?86 ]]; then
  SLKCFLAGS="-O2 -march=i586 -mtune=i686"
  CONFIGURE_TRIPLET="i486-slackware-linux"
elif [ "$ARCH" = "x86_64" ]; then
  SLKCFLAGS="-O2 -fpic"
  CONFIGURE_TRIPLET="x86_64-pc-linux"
fi
export CFLAGS=$SLKCFLAGS
export CXXFLAGS=$CFLAGS
#export LDFLAGS="-Wl,--hash-style=gnu"
#export XLIB_SKIP_ARGB_VISUALS=1

#this causes problems with regexpr used in vuseradd and maybe more
#export LC_ALL=$LANG.UTF8
