#!/bin/sh
# doinstall generated by vectelopment
PREFIX=/usr
( cd /etc/rc.d ; rm -rf rc7.d )
( cd /etc/rc.d ; ln -sf rc4.d rc7.d )
( cd /etc/rc.d ; rm -rf rc8.d )
( cd /etc/rc.d ; ln -sf rc5.d rc8.d )
( cd /etc ; rm -rf modules.conf )
( cd /etc ; ln -sf modprobe.conf modules.conf )
( cd sbin ; rm -rf vlsetup )
( cd sbin ; ln -sf VLsetup vlsetup )
# additional doinstall script

replace_new() {
if [ ! -f $1 ]; then
    if [ -x $1 ]; then
       chmod +x $1.new
    fi
    mv $1.new $1
else
    echo "WARNING: $1 is not upgraded"
fi
}

replace_new etc/rc.d/rc.keymap
replace_new etc/rc.d/rc.route
replace_new etc/rc.d/rc.paranoid
replace_new etc/rc.d/rc.firewall

for NEW in etc/sysconfig/*.new ; do
  replace_new ${NEW%.new}
done

replace_new etc/samba/smb.conf
replace_new etc/asound.state
replace_new etc/backupsync.conf
replace_new etc/backupsys.conf
replace_new etc/inetd.conf
replace_new etc/inittab
replace_new etc/modprobe.conf
replace_new etc/sudoers

( cd sbin && rm -f echoc; ln -sf /bin/echoc echoc )
( cd sbin && rm -f service; ln -sf /etc/rc.d/service /sbin/service )

( cd etc && chmod 440 sudoers )

# users accessible
#(cd /usr/bin
#rm -f vxwmset; ln -sf /sbin/vxwmset .
#rm -f vpasswd; ln -sf /sbin/vpasswd .
#rm -f vasm; ln -sf /sbin/vasm .
#)

#echo "Cleaning the service"
#service -b
#echo "you may reconfigure the services using vsrvmenu"

cat <<EOF
This new VASM supercedes many OLD SLACKWARE configurators.
If you want to delete them, call /sbin/rm_old_config

Make sure you have installed:
- tcl and expect (used by vuser abd vsuper)
- knocker or nmap (used by vsambaweb and vcupsweb)
- vlsetup, hwdata (used by vhwconf and vxconf)
- Xorg or XFree installed (used by vxconf).

EOF


