// File:	TDataStd_Geometry.cxx
// Created:	Wed Nov 19 14:16:45 1997
// Author:	Denis PASCAL
//		<dp@dingox.paris1.matra-dtv.fr>


#include <TDataStd_Geometry.ixx>

#include <TDataStd.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>

#include <TopoDS.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>
#include <TopAbs.hxx>
#include <BRep_Tool.hxx>

#include <Geom_CartesianPoint.hxx>

#include <Geom_TrimmedCurve.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Line.hxx>
#include <Geom_Ellipse.hxx>
#include <Geom_Circle.hxx>
#include <Geom_Curve.hxx>

#include <Geom_RectangularTrimmedSurface.hxx>
#include <Geom_Plane.hxx>
#include <Geom_CylindricalSurface.hxx>
#include <Standard_Failure.hxx>


//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Geometry::GetID () 
{
  static Standard_GUID TDataStd_GeometryID ("2a96b604-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_GeometryID;
}



//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Geometry) TDataStd_Geometry::Set (const TDF_Label& L)
{ 
  Handle(TDataStd_Geometry) A;  
  if (!L.FindAttribute(TDataStd_Geometry::GetID(),A)) {
    A = new TDataStd_Geometry (); 
//    A->SetType(TDataStd_ANY_GEOM);
    L.AddAttribute(A);
  }  
  return A;
}


//=======================================================================
//function : Point
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Point(const TDF_Label& L,gp_Pnt& G) 
{
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Point(NS,G);
  }
  return Standard_False;
}

//=======================================================================
//function : Point
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Point(const Handle(TNaming_NamedShape)& NS, gp_Pnt& G) 
{
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_VERTEX) {
    const TopoDS_Vertex& vertex = TopoDS::Vertex(shape);
    G = BRep_Tool::Pnt (TopoDS::Vertex (vertex));
    return Standard_True;
  }
  return Standard_False;
}

//=======================================================================
//function : Axis
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Axis(const TDF_Label& L,gp_Ax1& G) 
{    
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Axis(NS,G);
  }
  return Standard_False;
}

//=======================================================================
//function : Axis
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Axis(const Handle(TNaming_NamedShape)& NS, gp_Ax1& G) 
{
  gp_Lin lin;
  if (Line(NS, lin)) {
    G = lin.Position();
    return Standard_True;
  }
  return Standard_False;
}


//=======================================================================
//function : Line
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Line(const TDF_Label& L,gp_Lin& G) 
{
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Line(NS,G);
  }
  return Standard_False;
}

//=======================================================================
//function : Line
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Line(const Handle(TNaming_NamedShape)& NS,gp_Lin& G) 
{
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_EDGE) {
    const TopoDS_Edge& edge = TopoDS::Edge(shape);
    Standard_Real first,last;
    // TopLoc_Location loc;
    Handle(Geom_Curve) curve = BRep_Tool::Curve (edge,first,last);
    if (!curve.IsNull()) {
      if (curve->IsInstance (STANDARD_TYPE (Geom_TrimmedCurve)))
	curve =  (Handle(Geom_TrimmedCurve)::DownCast (curve))->BasisCurve ();
      Handle(Geom_Line) C  = Handle(Geom_Line)::DownCast(curve);
      if (!C.IsNull()) {
	G = C->Lin();
	return Standard_True;
      }
    }
  }
  return Standard_False;
}

//=======================================================================
//function : Circle
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Circle(const TDF_Label& L,gp_Circ& G) 
{  
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Circle(NS,G);
  }
  return Standard_False; 
}

//=======================================================================
//function : Circle
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Circle(const Handle(TNaming_NamedShape)& NS,gp_Circ& G) 
{  
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_EDGE) {
    const TopoDS_Edge& edge = TopoDS::Edge(shape);
    Standard_Real first,last;
    // TopLoc_Location loc;
    Handle(Geom_Curve) curve = BRep_Tool::Curve (edge,first,last);
    if (!curve.IsNull()) {
      if (curve->IsInstance (STANDARD_TYPE (Geom_TrimmedCurve)))
	curve =  (Handle(Geom_TrimmedCurve)::DownCast (curve))->BasisCurve ();
      Handle(Geom_Circle) C = Handle(Geom_Circle)::DownCast(curve);
      if (!C.IsNull()) {
	G = C->Circ();
	return Standard_True;
      }
    }
  }
  return Standard_False;
}


//=======================================================================
//function : Ellipse
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Ellipse(const TDF_Label& L,gp_Elips& G) 
{
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Ellipse(NS,G);
  }
  return Standard_False;
}


//=======================================================================
//function : Ellipse
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Ellipse(const Handle(TNaming_NamedShape)& NS, gp_Elips& G) 
{  
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_EDGE) {
    const TopoDS_Edge& edge = TopoDS::Edge(shape);
    Standard_Real first,last;
    Handle(Geom_Curve) curve = BRep_Tool::Curve (edge,first,last);
    if (!curve.IsNull()) {
      if (curve->IsInstance (STANDARD_TYPE (Geom_TrimmedCurve)))
	curve =  (Handle(Geom_TrimmedCurve)::DownCast (curve))->BasisCurve ();
      Handle(Geom_Ellipse) C = Handle(Geom_Ellipse)::DownCast(curve);
      if (!C.IsNull()) {
	G = C->Elips();
	return Standard_True;
      }
    }
  }
  return Standard_False;
}


//=======================================================================
//function : Plane
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Plane(const TDF_Label& L, gp_Pln& G) 
{  
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Plane(NS,G);
  }
  return Standard_False;
}


//=======================================================================
//function : Plane
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Plane(const Handle(TNaming_NamedShape)& NS, gp_Pln& G) 
{
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_FACE) {
    const TopoDS_Face& face = TopoDS::Face(shape);
    Handle(Geom_Surface) surface = BRep_Tool::Surface (face);
    if (!surface.IsNull())  {
       if (surface->IsInstance(STANDARD_TYPE(Geom_RectangularTrimmedSurface))) 
	 surface = ((Handle(Geom_RectangularTrimmedSurface)&) surface)->BasisSurface();
       Handle(Geom_Plane) S = Handle(Geom_Plane)::DownCast(surface);  
       if (!S.IsNull()) {
	 G = S->Pln();
	 return Standard_True;
       }
     } 
  }
  return Standard_False;
}


//=======================================================================
//function : Cylinder
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Cylinder(const TDF_Label& L, gp_Cylinder& G) 
{ 
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Cylinder (NS,G);
  }
  return Standard_False;
}


//=======================================================================
//function : Cylinder
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Geometry::Cylinder(const Handle(TNaming_NamedShape)& NS, gp_Cylinder& G) 
{  
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  if (shape.IsNull()) return Standard_False;
  if (shape.ShapeType() == TopAbs_FACE) {
    const TopoDS_Face& face = TopoDS::Face(shape);
    Handle(Geom_Surface) surface = BRep_Tool::Surface (face);
    if (!surface.IsNull())  {
      if (surface->IsInstance(STANDARD_TYPE(Geom_RectangularTrimmedSurface))) 
	surface = ((Handle(Geom_RectangularTrimmedSurface)&) surface)->BasisSurface();
      Handle(Geom_CylindricalSurface) S = Handle(Geom_CylindricalSurface)::DownCast(surface);
      if (!S.IsNull()) {
	G = S->Cylinder();
	return Standard_True;
      }
      
    } 
  }
  return Standard_False;
}


//=======================================================================
//function : Type
//purpose  : 
//=======================================================================

TDataStd_GeometryEnum  TDataStd_Geometry::Type (const TDF_Label& L)
{  
  Handle(TNaming_NamedShape) NS;
  if (L.FindAttribute(TNaming_NamedShape::GetID(),NS)) { 
    return Type (NS);
  }
  return TDataStd_ANY_GEOM;
}

//=======================================================================
//function : Type
//purpose  : 
//=======================================================================

TDataStd_GeometryEnum  TDataStd_Geometry::Type (const Handle(TNaming_NamedShape)& NS)
{
  TDataStd_GeometryEnum type (TDataStd_ANY_GEOM);
  const TopoDS_Shape& shape = TNaming_Tool::GetShape(NS);
  switch (shape.ShapeType()) {
  case TopAbs_VERTEX : 
    { 
      type = TDataStd_POINT;
      break;
    }
  case TopAbs_EDGE : 
    {    
      const TopoDS_Edge& edge = TopoDS::Edge(shape);    
      Standard_Real first,last;
      // TopLoc_Location loc;
      Handle(Geom_Curve) curve = BRep_Tool::Curve (edge,first,last);
      if (!curve.IsNull()) {
	if (curve->IsInstance (STANDARD_TYPE (Geom_TrimmedCurve))) {
	  curve =  (Handle(Geom_TrimmedCurve)::DownCast (curve))->BasisCurve ();
	}
	if (curve->IsInstance(STANDARD_TYPE(Geom_Line))) {
	  type = TDataStd_LINE;
	}
	else if (curve->IsInstance(STANDARD_TYPE(Geom_Circle))) {
	  type = TDataStd_CIRCLE;
	}
	else if (curve->IsInstance(STANDARD_TYPE(Geom_Ellipse))) {
	  type = TDataStd_ELLIPSE;
	}
	break;
      }
#ifdef DEB      
      else {
	Standard_Failure::Raise("curve Null dans TDataStd_Geometry");
      }
#endif
    }
  case TopAbs_FACE : 
    {
      const TopoDS_Face& face = TopoDS::Face(shape);
      Handle(Geom_Surface) surface = BRep_Tool::Surface (face);
      if (!surface.IsNull()) {
	if (surface->IsInstance(STANDARD_TYPE(Geom_RectangularTrimmedSurface))) { 
	  surface = ((Handle(Geom_RectangularTrimmedSurface)&) surface)->BasisSurface();
	}
	if (surface->IsInstance(STANDARD_TYPE(Geom_CylindricalSurface))) {
	  type = TDataStd_CYLINDER;
	}
	else if (surface->IsInstance(STANDARD_TYPE(Geom_Plane))) {
	  type = TDataStd_PLANE;
	}
      } 
#ifdef DEB      
      else {
	Standard_Failure::Raise("surface Null dans TDataStd_Geometry");
      }
#endif
      break;
    }
    default :
      {
	break;
      }
  }
  return type;
}

//=======================================================================
//function : TDataStd_Geometry
//purpose  : 
//=======================================================================

TDataStd_Geometry::TDataStd_Geometry ()
     : myType (TDataStd_ANY_GEOM)
 { }


//=======================================================================
//function : GetType
//purpose  : 
//=======================================================================

TDataStd_GeometryEnum  TDataStd_Geometry::GetType () const
{
  return myType;
}


//=======================================================================
//function : SetType
//purpose  : 
//=======================================================================

void TDataStd_Geometry::SetType (const TDataStd_GeometryEnum G)
{
  // OCC2932 correction
  if(myType == G) return;

  Backup();
  myType = G;
}


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Geometry::ID() const {  return GetID(); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_Geometry::NewEmpty () const
{  
  return new TDataStd_Geometry(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_Geometry::Restore (const Handle(TDF_Attribute)& With) 
{
  myType =  Handle(TDataStd_Geometry)::DownCast(With)->GetType();
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_Geometry::Paste (const Handle(TDF_Attribute)& Into, const Handle(TDF_RelocationTable)& RT) const { 
  Handle(TDataStd_Geometry)::DownCast(Into)->SetType(myType);
}


//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_Geometry::Dump (Standard_OStream& anOS) const
{  
  anOS << "Geometry ";  
  TDataStd::Print(GetType(),anOS);
  return anOS;
}
