/*
 * Copyright 1991, 1992, 1993, Silicon Graphics, Inc.
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
 * the contents of this file may not be disclosed to third parties, copied or
 * duplicated in any form, in whole or in part, without the prior written
 * permission of Silicon Graphics, Inc.
 *
 * RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
 * and Computer Software clause at DFARS 252.227-7013, and/or in similar or
 * successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
 * rights reserved under the Copyright Laws of the United States.
 */
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1989, Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright law.  They  may  not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *									  *
 **************************************************************************/

#ifndef OPENGL_TRIANGULATE_H
#define OPENGL_TRIANGULATE_H

/* triangulate.h */

enum updown {none, up, down};

typedef struct TriangulatorObj {
    short	minit;
    short	in_poly;
    short	in_loop;
    int		nswaps;
    struct Pool	*vpool;

    enum updown	*dirs;
    void	**ptrlist;
    jmp_buf	in_env;
    short	looptype;
    short	init;
    long	nloops;
    long	flag;
    long	size;
    long 	*limits;
    long 	limitcount;
    long	newlimitcount;
    long 	phead;
    long	ptail;
    long	psize;
    long	vcount;
    long	lastedge;
    long	vdatalast;
    long	vdatatop;
    struct Vert	*head;
    struct Vert	**parray;
    struct Ray	*raylist;
    struct Pool	*raypool;
    struct Vert	**vdata;
    struct Vert	*vtop;
    struct Vert	*vbottom;
    struct Vert	*vlast;
    struct Vert	*last[2];
    void	(*bgnpoly)( void );
    void	(*endpoly)( void );
    void	(*bgntmesh)( void );
    void	(*swaptmesh)( void );
    void	(*vertex)( void * );
    void	(*endtmesh)( void );
    void	(*error)( char * );
} TriangulatorObj;

extern TriangulatorObj *newTriangulator( 
    void (*bgnpoly)( void ), void (*endpoly)( void ),
    void (*bgntmesh)( void ), void (*swaptmesh)( void ),
    void (*vertex)( int * ), void (*endtmesh)( void ),
    void (*error)( char * ) );
extern void		freeTriangulator( TriangulatorObj * );
extern void		in_bgnpoly( TriangulatorObj *, long count );
extern void		in_endpoly( TriangulatorObj * );
extern void		in_bgnloop( TriangulatorObj *, short type );
extern void		in_vertex( TriangulatorObj *, float s, float t, void *data );
extern void		in_endloop( TriangulatorObj * );
extern void		in_error ( TriangulatorObj *, char *error );

#define TRI_INTERIOR	0
#define TRI_EXTERIOR	1
#define TRI_LEFT	2
#define TRI_RIGHT	3
#define TRI_UNKNOWN	4
#endif
