// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Voxel_FastConverter_HeaderFile
#define _Voxel_FastConverter_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Byte_HeaderFile
#include <Standard_Byte.hxx>
#endif
class TopoDS_Shape;
class Voxel_BoolDS;
class Voxel_ColorDS;
class gp_Pnt;
class gp_Pln;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Converts a shape to voxel representation. <br>
//!          It does it fast, but with less precision. <br>
//!          Also, it doesn't fill-in volumic part of the shape. <br>
class Voxel_FastConverter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! A constructor for conversion of a shape into a cube of boolean voxels. <br>
//!          It allocates the voxels in memory. <br>
//!          "nbthreads" defines the number of threads used to convert the shape. <br>
Standard_EXPORT Voxel_FastConverter(const TopoDS_Shape& shape,Voxel_BoolDS& voxels,const Standard_Real delfection = 0.1,const Standard_Integer nbx = 10,const Standard_Integer nby = 10,const Standard_Integer nbz = 10,const Standard_Integer nbthreads = 1);

//! A constructor for conversion of a shape into a cube of colored voxels. <br>
//!          It allocates the voxels in memory. <br>
//!          "nbthreads" defines the number of threads used to convert the shape. <br>
Standard_EXPORT Voxel_FastConverter(const TopoDS_Shape& shape,Voxel_ColorDS& voxels,const Standard_Real delfection = 0.1,const Standard_Integer nbx = 10,const Standard_Integer nby = 10,const Standard_Integer nbz = 10,const Standard_Integer nbthreads = 1);

//! Converts a shape into a voxel representation. <br>
//!          It sets to 0 the outside volume of the shape and <br>
//!          1 for surfacic part of the shape. <br>
//!          "ithread" is the index of the thread for current call of ::Convert(). <br>
//!          Start numeration of "ithread" with 1, please. <br>
Standard_EXPORT   Standard_Boolean Convert(Standard_Integer& progress,const Standard_Integer ithread = 1) ;

//! Fills-in volume of the shape by a value. <br>
Standard_EXPORT   Standard_Boolean FillInVolume(const Standard_Byte inner,const Standard_Integer ithread = 1) ;

//! A destructor. <br>
Standard_EXPORT   void Destroy() ;
~Voxel_FastConverter()
{
  Destroy();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Init() ;


Standard_EXPORT   void GetBndBox(const gp_Pnt& p1,const gp_Pnt& p2,const gp_Pnt& p3,Standard_Real& xmin,Standard_Real& ymin,Standard_Real& zmin,Standard_Real& xmax,Standard_Real& ymax,Standard_Real& zmax) const;


Standard_EXPORT   void ComputeVoxelsNearTriangle(const gp_Pln& plane,const gp_Pnt& p1,const gp_Pnt& p2,const gp_Pnt& p3,const Standard_Real hdiag,const Standard_Integer ixmin,const Standard_Integer iymin,const Standard_Integer izmin,const Standard_Integer ixmax,const Standard_Integer iymax,const Standard_Integer izmax) const;


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
Standard_Address myVoxels;
Standard_Real myDeflection;
Standard_Boolean myIsBool;
Standard_Integer myNbX;
Standard_Integer myNbY;
Standard_Integer myNbZ;
Standard_Integer myNbThreads;
Standard_Integer myNbTriangles;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
