// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StlAPI_Writer_HeaderFile
#define _StlAPI_Writer_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_StlMesh_Mesh_HeaderFile
#include <Handle_StlMesh_Mesh.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class StlMesh_Mesh;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class creates and writes <br>
//! STL files from Open CASCADE shapes. An STL file can be <br>
//! written to an existing STL file or to a new one.. <br>
class StlAPI_Writer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a writer object with <br>
//! default parameters: ASCIIMode, RelativeMode, SetCoefficent, <br>
//! SetDeflection. These parameters may be modified. <br>
Standard_EXPORT StlAPI_Writer();

//! Sets the deflection of the meshing algorithm. <br>
//!    Deflection is used, only if relative mode is false <br>
Standard_EXPORT   void SetDeflection(const Standard_Real aDeflection) ;

//! Sets the coeffiecient for computation of deflection through <br>
//!          relative size of shape. Default value = 0.001 <br>
Standard_EXPORT   void SetCoefficient(const Standard_Real aCoefficient) ;

//! Returns the address to the <br>
//! flag defining the relative mode for writing the file. <br>
//! This address may be used to either read or change the flag. <br>
//! If the mode returns True (default value), the <br>
//! deflection is calculated from the relative size of the <br>
//! shape. If the mode returns False, the user defined deflection is used. <br>
//! Example <br>
//! Read: <br>
//! Standard_Boolean val = Writer.RelativeMode( ); <br>
//! Modify: <br>
//! Writer.RelativeMode( ) = Standard_True; <br>
Standard_EXPORT   Standard_Boolean& RelativeMode() ;

//! Returns the address to the <br>
//! flag defining the mode for writing the file. This address <br>
//! may be used to either read or change the flag. <br>
//! If the mode returns True (default value) the generated <br>
//! file is an ASCII file. If the mode returns False, the <br>
//! generated file is a binary file. <br>
Standard_EXPORT   Standard_Boolean& ASCIIMode() ;

//! Converts a given shape to STL format and writes it to file with a given filename. <br>
Standard_EXPORT   void Write(const TopoDS_Shape& aShape,const Standard_CString aFileName) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean theRelativeMode;
Standard_Boolean theASCIIMode;
Standard_Real theDeflection;
Standard_Real theCoefficient;
Handle_StlMesh_Mesh theStlMesh;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
