// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_SLPropsATool_HeaderFile
#define _HLRBRep_SLPropsATool_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_Pnt;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class HLRBRep_SLPropsATool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Computes the point  <P> of 	parameter <U> and <V> <br>
//!          on the Surface <A>. <br>
static  void Value(const Standard_Address A,const Standard_Real U,const Standard_Real V,gp_Pnt& P) ;
//! Computes the point <P>  and first derivative <D1*> <br>
//!          of parameter <U> and <V> on the Surface <A>. <br>
//! <br>
static  void D1(const Standard_Address A,const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) ;
//! Computes the point <P>, the first derivative <D1*> <br>
//!          and second  derivative <D2*> of parameter  <U> and <br>
//!          <V> on the Surface <A>. <br>
//! <br>
static  void D2(const Standard_Address A,const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& DUV) ;


Standard_EXPORT static  gp_Vec DN(const Standard_Address A,const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) ;
//! returns the order of   continuity of the   Surface <br>
//!          <A>.  returns  1   :  first  derivative    only is <br>
//!          computable returns 2 : first and second derivative <br>
//!          only are computable. <br>
//! <br>
static  Standard_Integer Continuity(const Standard_Address A) ;
//! returns the bounds of the Surface. <br>
//! <br>
static  void Bounds(const Standard_Address A,Standard_Real& U1,Standard_Real& V1,Standard_Real& U2,Standard_Real& V2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <HLRBRep_SLPropsATool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
