// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepMesh_FastDiscret_HeaderFile
#define _BRepMesh_FastDiscret_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_BRepMesh_FastDiscret_HeaderFile
#include <Handle_BRepMesh_FastDiscret.hxx>
#endif

#ifndef _MeshShape_DataMapOfIntegerXY_HeaderFile
#include <MeshShape_DataMapOfIntegerXY.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BRepMesh_DataMapOfVertexInteger_HeaderFile
#include <BRepMesh_DataMapOfVertexInteger.hxx>
#endif
#ifndef _MeshShape_DataMapOfShapeListOfTransient_HeaderFile
#include <MeshShape_DataMapOfShapeListOfTransient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BRepMesh_DataMapOfIntegerFace_HeaderFile
#include <BRepMesh_DataMapOfIntegerFace.hxx>
#endif
#ifndef _MeshShape_DataMapOfIntegerPnt_HeaderFile
#include <MeshShape_DataMapOfIntegerPnt.hxx>
#endif
#ifndef _Handle_BRepMesh_DataStructureOfDelaun_HeaderFile
#include <Handle_BRepMesh_DataStructureOfDelaun.hxx>
#endif
#ifndef _BRepMesh_ListOfVertex_HeaderFile
#include <BRepMesh_ListOfVertex.hxx>
#endif
#ifndef _TColStd_IndexedMapOfInteger_HeaderFile
#include <TColStd_IndexedMapOfInteger.hxx>
#endif
#ifndef _BRepMesh_DataMapOfIntegerListOfXY_HeaderFile
#include <BRepMesh_DataMapOfIntegerListOfXY.hxx>
#endif
#ifndef _MeshShape_MapOfCouple_HeaderFile
#include <MeshShape_MapOfCouple.hxx>
#endif
#ifndef _TColStd_IndexedMapOfReal_HeaderFile
#include <TColStd_IndexedMapOfReal.hxx>
#endif
#ifndef _BRepMesh_Status_HeaderFile
#include <BRepMesh_Status.hxx>
#endif
#ifndef _BRepMesh_DataMapOfShapeReal_HeaderFile
#include <BRepMesh_DataMapOfShapeReal.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _MeshDS_BaseAllocator_HeaderFile
#include <MeshDS_BaseAllocator.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_BRepAdaptor_HSurface_HeaderFile
#include <Handle_BRepAdaptor_HSurface.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _MeshDS_MapOfInteger_HeaderFile
#include <MeshDS_MapOfInteger.hxx>
#endif
class BRepMesh_DataStructureOfDelaun;
class Bnd_Box;
class TopoDS_Shape;
class TopoDS_Face;
class TopoDS_Edge;
class BRepAdaptor_HSurface;
class Geom2d_Curve;
class TopoDS_Vertex;
class BRepMesh_ListOfVertex;
class TColStd_ListOfReal;
class BRepMesh_Classifier;
class TColStd_ListOfInteger;
class BRepMesh_Delaun;
class MeshShape_SurfacePoint;
class MeshShape_ListOfSurfacePoint;
class gp_XY;
class gp_Pnt2d;
class BRepMesh_Triangle;
class BRepMesh_Edge;
class BRepMesh_Vertex;
class gp_Pnt;
class gp_Dir;


//! Algorithm  to mesh  a shape  with  respect of  the <br>
//!          frontier the deflection  and by option the  shared <br>
//!          components. <br>
class BRepMesh_FastDiscret : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT BRepMesh_FastDiscret(const Standard_Real defle,const Standard_Real angle,const Bnd_Box& B,const Standard_Boolean withShare = Standard_True,const Standard_Boolean inshape = Standard_False,const Standard_Boolean relative = Standard_False,const Standard_Boolean shapetrigu = Standard_False);

//! if the  boolean    <relative>   is  True,    the <br>
//!          deflection used   for the polygonalisation   of <br>
//!          each edge will be <defle> * Size of Edge. <br>
//!          the deflection used for the faces will be the maximum <br>
//!          deflection of their edges. <br>
//! <br>
//!          if <shapetrigu> is True, the triangulation, if exists <br>
//!          with a correct deflection, can be used to re-triangulate <br>
//!          the shape. <br>
//! <br>
//!          if   <inshape>   is   True, the      calculated <br>
//!          triangulation will be stored in the shape. <br>
Standard_EXPORT BRepMesh_FastDiscret(const Standard_Real defle,const TopoDS_Shape& shape,const Bnd_Box& B,const Standard_Real angle,const Standard_Boolean withShare = Standard_True,const Standard_Boolean inshape = Standard_False,const Standard_Boolean relative = Standard_False,const Standard_Boolean shapetrigu = Standard_False);


Standard_EXPORT   void Add(const TopoDS_Shape& shape) ;


Standard_EXPORT   void Add(const TopoDS_Face& face) ;
//! Returns mode defining if internal vertices on faces <br>
//! are taken into consideration or not. If this mode is equal to true <br>
//! that internal vertices on faces are considered during triangulation. <br>
//! Default value is equal to false (old behaviour). <br>
  Standard_Boolean& InternalVerticesMode() ;


Standard_EXPORT   BRepMesh_Status CurrentFaceStatus() const;


Standard_EXPORT   Standard_Boolean Update(const TopoDS_Edge& Edge,const TopoDS_Face& Face,const Handle(Geom2d_Curve)& C,const Standard_Real defedge,const Standard_Real first,const Standard_Real last) ;


Standard_EXPORT   Standard_Real Control(const Handle(BRepAdaptor_HSurface)& caro,const Standard_Real defface,BRepMesh_ListOfVertex& inter,TColStd_ListOfInteger& badTri,TColStd_ListOfInteger& nulTri,BRepMesh_Delaun& trigu,const Standard_Boolean isfirst) ;


Standard_EXPORT   Standard_Integer Uindex(const MeshShape_SurfacePoint& P) const;


Standard_EXPORT   Standard_Integer Vindex(const MeshShape_SurfacePoint& P) const;


Standard_EXPORT   void Append(MeshShape_ListOfSurfacePoint& pntsOnSurf,const MeshShape_SurfacePoint& P) ;


Standard_EXPORT   gp_XY FindUV(const TopoDS_Vertex& V,const gp_Pnt2d& XY,const Standard_Integer ip,const Handle(BRepAdaptor_HSurface)& S,const Standard_Real mindist) ;

//! Gives  the number  of  domains. For  each  domain <br>
//!          there is a different TopFace. <br>
Standard_EXPORT   Standard_Integer NbDomains() const;

//! Gives the TopFace of the domain <Index>. <br>
Standard_EXPORT  const TopoDS_Face& DomainFace(const Standard_Integer Index) const;

//! Gives the number of built triangles. <br>
Standard_EXPORT   Standard_Integer NbTriangles() const;

//! Gives the triangle of <Index>. <br>
Standard_EXPORT  const BRepMesh_Triangle& Triangle(const Standard_Integer Index) const;

//! Gives the number of built Edges <br>
Standard_EXPORT   Standard_Integer NbEdges() const;

//! Gives the edge of index <Index>. <br>
Standard_EXPORT  const BRepMesh_Edge& Edge(const Standard_Integer Index) const;

//! Gives the number of built Vertices. <br>
Standard_EXPORT   Standard_Integer NbVertices() const;

//! Gives the vertex of <Index>. <br>
Standard_EXPORT  const BRepMesh_Vertex& Vertex(const Standard_Integer Index) const;

//! Gives the location3d of the vertex of <Index>. <br>
Standard_EXPORT  const gp_Pnt& Pnt(const Standard_Integer Index) const;

//! Gives the list of indices of the vertices of the <br>
//!          domain <Index>. <br>
Standard_EXPORT   void VerticesOfDomain(const Standard_Integer Index,MeshDS_MapOfInteger& Indices) const;

//! Gives the list of indices of the edges of the <br>
//!          domain <Index>. <br>
Standard_EXPORT   void EdgesOfDomain(const Standard_Integer Index,MeshDS_MapOfInteger& Indices) const;

//! Gives the list of indices of the triangles <br>
//!          of the domain <Index>. <br>
Standard_EXPORT   void TrianglesOfDomain(const Standard_Integer Index,MeshDS_MapOfInteger& Indices) const;

//! Gives the  number of different  location in 3d <br>
//!          space.  It  is  different    of the number  of <br>
//!          vertices if there is more than one surface. <br>
//!          Even for one surface, the number can be different <br>
//!          if an edge is shared. <br>
Standard_EXPORT   Standard_Integer NbPoint3d() const;

//! Gives the 3d space location of the vertex <Index>. <br>
Standard_EXPORT  const gp_Pnt& Point3d(const Standard_Integer Index) const;

//! Gives the normale of   the vertex of <Index>  on <br>
//!          his face. <br>
//! <br>
//!          This  function create  at each call the surface. <br>
//!          To optimize the systematic computing you can use <br>
//!          the folowing loop : <br>
//! <br>
//!          Surface mySurface(DomainFace(theDomain)); <br>
//!          loop-On-Vertices-Of-theDomain { <br>
//!            GeomTool::Normal(mySurface, u, v, Pnt, Dir); <br>
//!          } <br>
//! <br>
//!          WARNING : The vertex from wich the <u> and <v> are <br>
//!          used is on <theDomain>. <br>
//! <br>
Standard_EXPORT   void Normal(const Standard_Integer Index,gp_Pnt& Pon,gp_Dir& Nor) const;

//! Gives the data structure of the mesh. <br>
Standard_EXPORT   Handle_BRepMesh_DataStructureOfDelaun Result() const;

//! returns the deflection value. <br>
Standard_EXPORT   Standard_Real GetDeflection() const;

//! returns the deflection value. <br>
Standard_EXPORT   Standard_Real GetAngle() const;
//Standard_EXPORT ~BRepMesh_FastDiscret();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Add(const TopoDS_Edge& edge,const TopoDS_Face& face,const Handle(BRepAdaptor_HSurface)& S,const Handle(Geom2d_Curve)& C,const Standard_Real defedge,const Standard_Real first,const Standard_Real last) ;


Standard_EXPORT   void Add(const TopoDS_Vertex& theVert,const TopoDS_Face& face,const Handle(BRepAdaptor_HSurface)& S) ;


Standard_EXPORT   void InternalVerticesForRectangle(const Handle(BRepAdaptor_HSurface)& caro,BRepMesh_ListOfVertex& inter,const TColStd_ListOfReal& u1pars,const TColStd_ListOfReal& u2pars,const TColStd_ListOfReal& v1pars,const TColStd_ListOfReal& v2pars) ;


Standard_EXPORT   void InternalVertices(const Handle(BRepAdaptor_HSurface)& caro,BRepMesh_ListOfVertex& inter,const Standard_Real defedge,const BRepMesh_Classifier& classifier) ;


Standard_EXPORT   void AddInShape(const TopoDS_Face& face,const Standard_Real defedge) ;


 // Fields PRIVATE
 //
MeshShape_DataMapOfIntegerXY myrealuv;
Standard_Real angle;
Standard_Real deflection;
Standard_Real mydtotale;
Standard_Boolean WithShare;
BRepMesh_DataMapOfVertexInteger vertices;
MeshShape_DataMapOfShapeListOfTransient edges;
MeshShape_DataMapOfShapeListOfTransient internaledges;
Standard_Integer nbDomains;
BRepMesh_DataMapOfIntegerFace Domains;
Standard_Integer nbLocat;
MeshShape_DataMapOfIntegerPnt Location3d;
Handle_BRepMesh_DataStructureOfDelaun structure;
BRepMesh_ListOfVertex mylistver;
TColStd_IndexedMapOfInteger myvemap;
BRepMesh_DataMapOfIntegerListOfXY mylocation2d;
MeshShape_MapOfCouple mymap;
Standard_Real myumin;
Standard_Real myumax;
Standard_Real myvmin;
Standard_Real myvmax;
Standard_Boolean myrelative;
Standard_Boolean myshapetrigu;
Standard_Boolean myinshape;
Standard_Boolean myInternalVerticesMode;
Standard_Real deltaX;
Standard_Real deltaY;
TColStd_IndexedMapOfReal myUParam;
TColStd_IndexedMapOfReal myVParam;
BRepMesh_Status myfacestate;
BRepMesh_DataMapOfShapeReal mapdefle;
TopTools_ListOfShape mynottriangulated;
MeshDS_BaseAllocator myAllocator;


};


#include <BRepMesh_FastDiscret.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
