// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_CompositeClassifier_HeaderFile
#define _BOP_CompositeClassifier_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _BOP_LoopClassifier_HeaderFile
#include <BOP_LoopClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Handle_BOP_Loop_HeaderFile
#include <Handle_BOP_Loop.hxx>
#endif
class BOP_BlockBuilder;
class BOP_Loop;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The Root class for algorithms <br>
//!  to   classify composite Loops, i.e, Loops that <br>
//!  can be either a Shape, or a block of Elements. <br>
//! <br>
class BOP_CompositeClassifier  : public BOP_LoopClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Classify loop <L1> with  <L2> <br>
Standard_EXPORT virtual  TopAbs_State Compare(const Handle(BOP_Loop)& L1,const Handle(BOP_Loop)& L2) ;


//! Classify shape <B1> with shape <B2> <br>
Standard_EXPORT virtual  TopAbs_State CompareShapes(const TopoDS_Shape& B1,const TopoDS_Shape& B2)  = 0;


//! Classify element <E> with shape <B> <br>
Standard_EXPORT virtual  TopAbs_State CompareElementToShape(const TopoDS_Shape& E,const TopoDS_Shape& B)  = 0;


//! Prepare classification involving shape <B> <br>
//! Calls ResetElement on first element of <B> <br>
Standard_EXPORT virtual  void ResetShape(const TopoDS_Shape& B)  = 0;


//! Prepare classification involving element <E>. <br>
Standard_EXPORT virtual  void ResetElement(const TopoDS_Shape& E)  = 0;


//! Add element <E> in the set of elements used in classification. <br>
Standard_EXPORT virtual  void CompareElement(const TopoDS_Shape& E)  = 0;


//! Returns state of classification of 2D point, defined by <br>
//! ResetElement, with the current set of elements, <br>
//! defined by Compare. <br>
Standard_EXPORT virtual  TopAbs_State State()  = 0;





protected:

 // Methods PROTECTED
 // 


//! Initializing the object with BlockBuilder; <br>
Standard_EXPORT BOP_CompositeClassifier(const BOP_BlockBuilder& BB);


 // Fields PROTECTED
 //
Standard_Address myBlockBuilder;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
