// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_Builder_HeaderFile
#define _BOP_Builder_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_PDSFiller_HeaderFile
#include <BOPTools_PDSFiller.hxx>
#endif
#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _TopTools_IndexedDataMapOfShapeListOfShape_HeaderFile
#include <TopTools_IndexedDataMapOfShapeListOfShape.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Handle_BOP_HistoryCollector_HeaderFile
#include <Handle_BOP_HistoryCollector.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class BOP_HistoryCollector;
class TopoDS_Shape;
class BOPTools_DSFiller;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BOP_Builder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Set shapes (arguments) to perform BO <br>
Standard_EXPORT   void SetShapes(const TopoDS_Shape& aS1,const TopoDS_Shape& aS2) ;


//!  Set type of the BO to perform <br>
//! <br>
Standard_EXPORT   void SetOperation(const BOP_Operation anOp) ;

//! Set the flag to allow the result <br>
//!          be manifold or non-manifold (not used) <br>
Standard_EXPORT   void SetManifoldFlag(const Standard_Boolean aFlag) ;


//!  Selector <br>
Standard_EXPORT  const TopoDS_Shape& Shape1() const;


//!  Selector <br>
Standard_EXPORT  const TopoDS_Shape& Shape2() const;


//!  Selector <br>
//! <br>
Standard_EXPORT   BOP_Operation Operation() const;


//!  Selector <br>
//! <br>
Standard_EXPORT   Standard_Boolean ManifoldFlag() const;


//!	Selector <br>
//! <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//!  Selector <br>
Standard_EXPORT   Standard_Integer ErrorStatus() const;


//!  Returns the result of the BO <br>
//! <br>
Standard_EXPORT  const TopoDS_Shape& Result() const;


//!           Does the BO from the beggining to the end, <br>
//!           i.e.  create new DataStructure, DSFiller, <br>
//!           compute all  interferences, compute states, <br>
//!           build result etc <br>
Standard_EXPORT virtual  void Do() ;


//!  Does the BO using existing Filler to the end <br>
//! <br>
Standard_EXPORT virtual  void DoWithFiller(const BOPTools_DSFiller& aDSF) ;


//!  Constructs the final result of the BO <br>
//! <br>
Standard_EXPORT virtual  void BuildResult() ;


//!  Destructor <br>
//! <br>
Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~BOP_Builder(){Destroy();}


//!  Sort types of shapes as integers in increasing order <br>
//! <br>
Standard_EXPORT static  void SortTypes(TopAbs_ShapeEnum& aType1,TopAbs_ShapeEnum& aType2) ;


//! Returns the list  of shapes modified from the shape aS <br>
//! <br>
Standard_EXPORT  const TopTools_ListOfShape& Modified(const TopoDS_Shape& aS) const;


//! Returns TRUE if the result does  not contain the shape aS <br>
//! <br>
Standard_EXPORT   Standard_Boolean IsDeleted(const TopoDS_Shape& aS) const;


//! Returns the list of shapes that are parts of BO "Section" <br>
//! for  given arguments. <br>
//! For Internal usage <br>
//! <br>
Standard_EXPORT  const TopTools_ListOfShape& SectionEdges() const;


Standard_EXPORT virtual  void SetHistoryCollector(const Handle(BOP_HistoryCollector)& theHistory) ;


Standard_EXPORT   Handle_BOP_HistoryCollector GetHistoryCollector() const;





protected:

 // Methods PROTECTED
 // 


//! Empty constructor; <br>
//! <br>
Standard_EXPORT BOP_Builder();


//! Fill the list  of shapes modified from the shape aS. <br>
//! For Internal usage <br>
//! <br>
Standard_EXPORT   void FillModified() ;


//! Fill the list  of shapes modified from the shape aS. <br>
//! For Internal usage <br>
//! <br>
Standard_EXPORT   void FillModified(const TopoDS_Shape& aS,const TopTools_ListOfShape& aL) ;


//! Fill the list  of shapes modified from the shape aS <br>
//! For Internal usage <br>
//! <br>
Standard_EXPORT   void FillModified(const TopoDS_Shape& aE,const TopoDS_Shape& aSp) ;


 // Fields PROTECTED
 //
TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
BOP_Operation myOperation;
Standard_Boolean myManifoldFlag;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;
TopoDS_Shape myResult;
Standard_Integer myDraw;
BOPTools_PDSFiller myDSFiller;
TopTools_IndexedMapOfShape myResultMap;
TopTools_IndexedDataMapOfShapeListOfShape myModifiedMap;
TopTools_ListOfShape myEmptyList;
TopTools_ListOfShape mySectionEdges;
Handle_BOP_HistoryCollector myHistory;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
