/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.List;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class MidiSequenceParser {
    private static final int DEFAULT_METRONOME_KEY = 37;
    private static final int DEFAULT_DURATION_PM = 60;
    private static final int DEFAULT_DURATION_DEAD = 30;
    private static final int DEFAULT_BEND = 64;
    private static final float DEFAULT_BEND_SEMI_TONE = 2.75f;
    public static final int ADD_DEFAULT_CONTROLS = 1;
    public static final int ADD_MIXER_MESSAGES = 2;
    public static final int ADD_METRONOME = 4;
    public static final int ADD_FIRST_TICK_MOVE = 8;
    public static final int DEFAULT_PLAY_FLAGS = 4;
    public static final int DEFAULT_EXPORT_FLAGS = 11;
    private TGSongManager manager;
    private int flags;
    private int infoTrack;
    private int metronomeTrack;
    private int firstTickMove;
    private int tempoPercent;
    private int transpose;
    private int sHeader;
    private int eHeader;

    public MidiSequenceParser(TGSongManager tGSongManager, int n, int n2, int n3) {
        this.manager = tGSongManager;
        this.flags = n;
        this.transpose = n3;
        this.tempoPercent = n2;
        this.firstTickMove = (int)((n & 8) != 0 ? -960L : 0L);
        this.sHeader = -1;
        this.eHeader = -1;
    }

    public MidiSequenceParser(TGSongManager tGSongManager, int n) {
        this(tGSongManager, n, 100, 0);
    }

    public void parse(MidiSequenceHandler midiSequenceHandler) {
        this.infoTrack = 0;
        this.metronomeTrack = midiSequenceHandler.getTracks() - 1;
        this.addDefaultMessages(midiSequenceHandler);
        for (int i = 0; i < this.manager.getSong().countTracks(); ++i) {
            TGTrack tGTrack = this.manager.getSong().getTrack(i);
            this.createTrack(midiSequenceHandler, tGTrack);
        }
        midiSequenceHandler.notifyFinish();
    }

    public int getInfoTrack() {
        return this.infoTrack;
    }

    public int getMetronomeTrack() {
        return this.metronomeTrack;
    }

    private long getTick(long l) {
        return l + (long)this.firstTickMove;
    }

    public void setSHeader(int n) {
        this.sHeader = n;
    }

    public void setEHeader(int n) {
        this.eHeader = n;
    }

    private int fix(int n) {
        return n >= 0 ? (n <= 127 ? n : 127) : 0;
    }

    private void createTrack(MidiSequenceHandler midiSequenceHandler, TGTrack tGTrack) {
        TGMeasure tGMeasure = null;
        MidiRepeatController midiRepeatController = new MidiRepeatController(tGTrack.getSong(), this.sHeader, this.eHeader);
        this.addBend(midiSequenceHandler, tGTrack.getNumber(), 960L, 64, tGTrack.getChannel().getChannel());
        this.makeChannel(midiSequenceHandler, tGTrack.getChannel(), tGTrack.getNumber());
        while (!midiRepeatController.finished()) {
            TGMeasure tGMeasure2 = tGTrack.getMeasure(midiRepeatController.getIndex());
            int n = midiRepeatController.getIndex();
            long l = midiRepeatController.getRepeatMove();
            midiRepeatController.process();
            if (!midiRepeatController.shouldPlay()) continue;
            if (tGTrack.getNumber() == 1) {
                this.addTimeSignature(midiSequenceHandler, tGMeasure2, tGMeasure, l);
                this.addTempo(midiSequenceHandler, tGMeasure2, tGMeasure, l);
                this.addMetronome(midiSequenceHandler, tGMeasure2.getHeader(), l);
            }
            this.makeBeats(midiSequenceHandler, tGTrack, tGMeasure2, n, l);
            tGMeasure = tGMeasure2;
        }
    }

    private void makeBeats(MidiSequenceHandler midiSequenceHandler, TGTrack tGTrack, TGMeasure tGMeasure, int n, long l) {
        int[] nArray = new int[tGTrack.stringCount()];
        TGBeat tGBeat = null;
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            this.makeNotes(midiSequenceHandler, tGTrack, tGBeat2, tGMeasure.getTempo(), n, i, l, this.getStroke(tGBeat2, tGBeat, nArray));
            tGBeat = tGBeat2;
        }
    }

    private void makeNotes(MidiSequenceHandler midiSequenceHandler, TGTrack tGTrack, TGBeat tGBeat, TGTempo tGTempo, int n, int n2, long l, int[] nArray) {
        int n3 = tGTrack.getNumber();
        for (int i = 0; i < tGBeat.countVoices(); ++i) {
            TGVoice tGVoice = tGBeat.getVoice(i);
            BeatData beatData = this.checkTripletFeel(tGVoice, n2);
            for (int j = 0; j < tGVoice.countNotes(); ++j) {
                int n4;
                int n5;
                TGNote tGNote = tGVoice.getNote(j);
                if (tGNote.isTiedNote()) continue;
                int n6 = this.transpose + tGTrack.getOffset() + tGNote.getValue() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
                long l2 = this.applyStrokeStart(tGNote, beatData.getStart() + l, nArray);
                long l3 = this.applyStrokeDuration(tGNote, this.getRealNoteDuration(tGTrack, tGNote, tGTempo, beatData.getDuration(), n, n2), nArray);
                int n7 = this.getRealVelocity(tGNote, tGTrack, n, n2);
                short s = tGTrack.getChannel().getChannel();
                short s2 = tGTrack.getChannel().getEffectChannel();
                boolean bl = tGTrack.isPercussionTrack();
                if (tGNote.getEffect().isFadeIn()) {
                    s = s2;
                    this.makeFadeIn(midiSequenceHandler, n3, l2, l3, tGTrack.getChannel().getVolume(), s);
                }
                if (tGNote.getEffect().isGrace() && s2 >= 0 && !bl) {
                    long l4;
                    s = s2;
                    n5 = tGTrack.getOffset() + tGNote.getEffect().getGrace().getFret() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
                    n4 = tGNote.getEffect().getGrace().getDurationTime();
                    int n8 = tGNote.getEffect().getGrace().getDynamic();
                    long l5 = l4 = tGNote.getEffect().getGrace().isDead() ? this.applyStaticDuration(tGTempo, 30L, n4) : (long)n4;
                    if (tGNote.getEffect().getGrace().isOnBeat() || l2 - (long)n4 < 960L) {
                        l2 += (long)n4;
                        l3 -= (long)n4;
                    }
                    this.makeNote(midiSequenceHandler, n3, n5, l2 - (long)n4, l4, n8, s);
                }
                if (tGNote.getEffect().isTrill() && s2 >= 0 && !bl) {
                    n5 = tGTrack.getOffset() + tGNote.getEffect().getTrill().getFret() + ((TGString)tGTrack.getStrings().get(tGNote.getString() - 1)).getValue();
                    long l6 = tGNote.getEffect().getTrill().getDuration().getTime();
                    boolean bl2 = true;
                    long l7 = l2;
                    while (l7 + 10L < l2 + l3) {
                        if (l7 + l6 >= l2 + l3) {
                            l6 = l2 + l3 - l7 - 1L;
                        }
                        this.makeNote(midiSequenceHandler, n3, bl2 ? n6 : n5, l7, l6, n7, s);
                        bl2 = !bl2;
                        l7 += l6;
                    }
                    continue;
                }
                if (tGNote.getEffect().isTremoloPicking() && s2 >= 0) {
                    long l8 = tGNote.getEffect().getTremoloPicking().getDuration().getTime();
                    long l9 = l2;
                    while (l9 + 10L < l2 + l3) {
                        if (l9 + l8 >= l2 + l3) {
                            l8 = l2 + l3 - l9 - 1L;
                        }
                        this.makeNote(midiSequenceHandler, n3, n6, l9, l8, n7, s);
                        l9 += l8;
                    }
                    continue;
                }
                if (tGNote.getEffect().isBend() && s2 >= 0 && !bl) {
                    s = s2;
                    this.makeBend(midiSequenceHandler, n3, l2, l3, tGNote.getEffect().getBend(), s);
                } else if (tGNote.getEffect().isTremoloBar() && s2 >= 0 && !bl) {
                    s = s2;
                    this.makeTremoloBar(midiSequenceHandler, n3, l2, l3, tGNote.getEffect().getTremoloBar(), s);
                } else if (tGNote.getEffect().isSlide() && s2 >= 0 && !bl) {
                    s = s2;
                    TGNote tGNote2 = this.getNextNote(tGNote, tGTrack, n, n2, true);
                    this.makeSlide(midiSequenceHandler, n3, tGNote, tGNote2, l, s);
                } else if (tGNote.getEffect().isVibrato() && s2 >= 0 && !bl) {
                    s = s2;
                    this.makeVibrato(midiSequenceHandler, n3, l2, l3, s);
                }
                if (tGNote.getEffect().isHarmonic() && !bl) {
                    n5 = n6;
                    if (tGNote.getEffect().getHarmonic().isNatural()) {
                        for (n4 = 0; n4 < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++n4) {
                            if (tGNote.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[n4][0] % 12) continue;
                            n6 = n5 + TGEffectHarmonic.NATURAL_FREQUENCIES[n4][1] - tGNote.getValue();
                            break;
                        }
                    } else {
                        if (tGNote.getEffect().getHarmonic().isSemi() && !bl) {
                            this.makeNote(midiSequenceHandler, n3, Math.min(127, n5), l2, l3, Math.max(15, n7 - 48), s);
                        }
                        n6 = n5 + TGEffectHarmonic.NATURAL_FREQUENCIES[tGNote.getEffect().getHarmonic().getData()][1];
                    }
                    if (n6 - 12 > 0) {
                        n4 = Math.max(15, n7 - 64);
                        this.makeNote(midiSequenceHandler, n3, n6 - 12, l2, l3, n4, s);
                    }
                }
                this.makeNote(midiSequenceHandler, n3, Math.min(127, n6), l2, l3, n7, s);
            }
        }
    }

    private void makeNote(MidiSequenceHandler midiSequenceHandler, int n, int n2, long l, long l2, int n3, int n4) {
        midiSequenceHandler.addNoteOn(this.getTick(l), n, n4, this.fix(n2), this.fix(n3));
        midiSequenceHandler.addNoteOff(this.getTick(l + l2), n, n4, this.fix(n2), this.fix(n3));
    }

    private void makeChannel(MidiSequenceHandler midiSequenceHandler, TGChannel tGChannel, int n) {
        if ((this.flags & 2) != 0) {
            this.makeChannel(midiSequenceHandler, tGChannel, n, true);
            if (tGChannel.getChannel() != tGChannel.getEffectChannel()) {
                this.makeChannel(midiSequenceHandler, tGChannel, n, false);
            }
        }
    }

    private void makeChannel(MidiSequenceHandler midiSequenceHandler, TGChannel tGChannel, int n, boolean bl) {
        short s = bl ? tGChannel.getChannel() : tGChannel.getEffectChannel();
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 7, this.fix(tGChannel.getVolume()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 10, this.fix(tGChannel.getBalance()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 93, this.fix(tGChannel.getChorus()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 91, this.fix(tGChannel.getReverb()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 95, this.fix(tGChannel.getPhaser()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 92, this.fix(tGChannel.getTremolo()));
        midiSequenceHandler.addControlChange(this.getTick(960L), n, s, 11, 127);
        midiSequenceHandler.addProgramChange(this.getTick(960L), n, s, this.fix(tGChannel.getInstrument()));
    }

    private void addTimeSignature(MidiSequenceHandler midiSequenceHandler, TGMeasure tGMeasure, TGMeasure tGMeasure2, long l) {
        boolean bl = false;
        if (tGMeasure2 == null) {
            bl = true;
        } else {
            int n = tGMeasure.getTimeSignature().getNumerator();
            int n2 = tGMeasure.getTimeSignature().getDenominator().getValue();
            int n3 = tGMeasure2.getTimeSignature().getNumerator();
            int n4 = tGMeasure2.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                bl = true;
            }
        }
        if (bl) {
            midiSequenceHandler.addTimeSignature(this.getTick(tGMeasure.getStart() + l), this.getInfoTrack(), tGMeasure.getTimeSignature());
        }
    }

    private void addTempo(MidiSequenceHandler midiSequenceHandler, TGMeasure tGMeasure, TGMeasure tGMeasure2, long l) {
        boolean bl = false;
        if (tGMeasure2 == null) {
            bl = true;
        } else if (tGMeasure.getTempo().getInUSQ() != tGMeasure2.getTempo().getInUSQ()) {
            bl = true;
        }
        if (bl) {
            int n = (int)((double)tGMeasure.getTempo().getInUSQ() * 100.0 / (double)this.tempoPercent);
            midiSequenceHandler.addTempoInUSQ(this.getTick(tGMeasure.getStart() + l), this.getInfoTrack(), n);
        }
    }

    private long getRealNoteDuration(TGTrack tGTrack, TGNote tGNote, TGTempo tGTempo, long l, int n, int n2) {
        long l2 = tGNote.getVoice().getBeat().getStart() + tGNote.getVoice().getDuration().getTime();
        long l3 = l;
        int n3 = n2 + 1;
        int n4 = this.eHeader == -1 ? tGTrack.countMeasures() : Math.min(this.eHeader, tGTrack.countMeasures());
        for (int i = n; i < n4; ++i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            int n5 = tGMeasure.countBeats();
            for (int j = n3; j < n5; ++j) {
                TGBeat tGBeat = tGMeasure.getBeat(j);
                TGVoice tGVoice = tGBeat.getVoice(tGNote.getVoice().getIndex());
                if (tGVoice.isRestVoice()) {
                    return this.applyDurationEffects(tGNote, tGTempo, l3);
                }
                int n6 = tGVoice.countNotes();
                for (int k = 0; k < n6; ++k) {
                    TGNote tGNote2 = tGVoice.getNote(k);
                    if (tGNote2.equals(tGNote) || tGNote2.getString() != tGNote.getString()) continue;
                    if (tGNote2.isTiedNote()) {
                        l3 += tGBeat.getStart() - l2 + tGNote2.getVoice().getDuration().getTime();
                        l2 = tGBeat.getStart() + tGVoice.getDuration().getTime();
                        continue;
                    }
                    return this.applyDurationEffects(tGNote, tGTempo, l3);
                }
            }
            n3 = 0;
        }
        return this.applyDurationEffects(tGNote, tGTempo, l3);
    }

    private long applyDurationEffects(TGNote tGNote, TGTempo tGTempo, long l) {
        if (tGNote.getEffect().isDeadNote()) {
            return this.applyStaticDuration(tGTempo, 30L, l);
        }
        if (tGNote.getEffect().isPalmMute()) {
            return this.applyStaticDuration(tGTempo, 60L, l);
        }
        if (tGNote.getEffect().isStaccato()) {
            return (long)((double)l * 50.0 / 100.0);
        }
        return l;
    }

    private long applyStaticDuration(TGTempo tGTempo, long l, long l2) {
        long l3 = (long)tGTempo.getValue() * l / 60L;
        return l3 < l2 ? l3 : l2;
    }

    private int getRealVelocity(TGNote tGNote, TGTrack tGTrack, int n, int n2) {
        TGNote tGNote2;
        int n3 = tGNote.getVelocity();
        if (!tGTrack.isPercussionTrack() && (tGNote2 = this.getPreviousNote(tGNote, tGTrack, n, n2, false)) != null && tGNote2.getEffect().isHammer()) {
            n3 = Math.max(15, n3 - 25);
        }
        if (tGNote.getEffect().isGhostNote()) {
            n3 = Math.max(15, n3 - 16);
        } else if (tGNote.getEffect().isAccentuatedNote()) {
            n3 = Math.max(15, n3 + 16);
        } else if (tGNote.getEffect().isHeavyAccentuatedNote()) {
            n3 = Math.max(15, n3 + 32);
        }
        return n3 > 127 ? 127 : n3;
    }

    public void addMetronome(MidiSequenceHandler midiSequenceHandler, TGMeasureHeader tGMeasureHeader, long l) {
        if ((this.flags & 4) != 0) {
            long l2 = l + tGMeasureHeader.getStart();
            long l3 = tGMeasureHeader.getTimeSignature().getDenominator().getTime();
            for (int i = 1; i <= tGMeasureHeader.getTimeSignature().getNumerator(); ++i) {
                this.makeNote(midiSequenceHandler, this.getMetronomeTrack(), 37, l2, l3, 95, 9);
                l2 += l3;
            }
        }
    }

    public void addDefaultMessages(MidiSequenceHandler midiSequenceHandler) {
        if ((this.flags & 1) != 0) {
            for (int i = 0; i < 16; ++i) {
                midiSequenceHandler.addControlChange(this.getTick(960L), this.getInfoTrack(), i, 101, 0);
                midiSequenceHandler.addControlChange(this.getTick(960L), this.getInfoTrack(), i, 100, 0);
                midiSequenceHandler.addControlChange(this.getTick(960L), this.getInfoTrack(), i, 6, 12);
                midiSequenceHandler.addControlChange(this.getTick(960L), this.getInfoTrack(), i, 38, 0);
            }
        }
    }

    private void addBend(MidiSequenceHandler midiSequenceHandler, int n, long l, int n2, int n3) {
        midiSequenceHandler.addPitchBend(this.getTick(l), n, n3, this.fix(n2));
    }

    public void makeVibrato(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, int n2) {
        long l3 = l;
        long l4 = l3 + l2;
        while (l3 < l4) {
            l3 = l3 + 160L > l4 ? l4 : l3 + 160L;
            this.addBend(midiSequenceHandler, n, l3, 64, n2);
            l3 = l3 + 160L > l4 ? l4 : l3 + 160L;
            this.addBend(midiSequenceHandler, n, l3, 65, n2);
        }
        this.addBend(midiSequenceHandler, n, l3, 64, n2);
    }

    public void makeBend(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, TGEffectBend tGEffectBend, int n2) {
        List list = tGEffectBend.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)list.get(i);
            long l3 = l + bendPoint.getTime(l2);
            int n3 = 64 + (int)((float)bendPoint.getValue() * 2.75f / 1.0f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequenceHandler, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            TGEffectBend.BendPoint bendPoint2 = (TGEffectBend.BendPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)bendPoint2.getValue() * 2.75f / 1.0f);
            long l4 = l + bendPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequenceHandler, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequenceHandler, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequenceHandler, n, l + l2, 64, n2);
    }

    public void makeTremoloBar(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, TGEffectTremoloBar tGEffectTremoloBar, int n2) {
        List list = tGEffectTremoloBar.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)list.get(i);
            long l3 = l + tremoloBarPoint.getTime(l2);
            int n3 = 64 + (int)((float)tremoloBarPoint.getValue() * 5.5f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequenceHandler, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint2 = (TGEffectTremoloBar.TremoloBarPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)tremoloBarPoint2.getValue() * 5.5f);
            long l4 = l + tremoloBarPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequenceHandler, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequenceHandler, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequenceHandler, n, l + l2, 64, n2);
    }

    public void makeSlide(MidiSequenceHandler midiSequenceHandler, int n, TGNote tGNote, TGNote tGNote2, long l, int n2) {
        if (tGNote2 != null) {
            this.makeSlide(midiSequenceHandler, n, tGNote.getVoice().getBeat().getStart() + l, tGNote.getValue(), tGNote2.getVoice().getBeat().getStart() + l, tGNote2.getValue(), n2);
            this.addBend(midiSequenceHandler, n, tGNote2.getVoice().getBeat().getStart() + l, 64, n2);
        }
    }

    public void makeSlide(MidiSequenceHandler midiSequenceHandler, int n, long l, int n2, long l2, int n3, int n4) {
        long l3 = n3 - n2;
        long l4 = l2 - l;
        int n5 = (int)(l4 / 120L);
        for (int i = 1; i <= n5; ++i) {
            float f = (float)(l4 / (long)n5) * (float)i * (float)l3 / (float)l4;
            int n6 = 64 + (int)(f * 5.5f);
            this.addBend(midiSequenceHandler, n, l + l4 / (long)n5 * (long)i, n6, n4);
        }
    }

    private void makeFadeIn(MidiSequenceHandler midiSequenceHandler, int n, long l, long l2, int n2, int n3) {
        int n4 = 31;
        int n5 = 1;
        long l3 = l2 / (long)((127 - n4) / n5);
        for (long i = l; i < l + l2 && n4 < 127; i += l3, n4 += n5) {
            midiSequenceHandler.addControlChange(this.getTick(i), n, n3, 11, this.fix(n4));
        }
        midiSequenceHandler.addControlChange(this.getTick(l + l2), n, n3, 11, 127);
    }

    private int[] getStroke(TGBeat tGBeat, TGBeat tGBeat2, int[] nArray) {
        block4: {
            int n;
            int n2;
            int n3;
            block5: {
                n3 = tGBeat.getStroke().getDirection();
                if (tGBeat2 != null && n3 == 0 && tGBeat2.getStroke().getDirection() == 0) break block4;
                if (n3 != 0) break block5;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = 0;
                }
                break block4;
            }
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < tGBeat.countVoices(); ++n2) {
                TGVoice tGVoice = tGBeat.getVoice(n2);
                for (n = 0; n < tGVoice.countNotes(); ++n) {
                    TGNote tGNote = tGVoice.getNote(n);
                    if (tGNote.isTiedNote()) continue;
                    n4 |= 1 << tGNote.getString() - 1;
                    ++n5;
                }
            }
            if (n5 <= 0) break block4;
            n2 = 0;
            int n6 = tGBeat.getStroke().getIncrementTime(tGBeat);
            for (n = 0; n < nArray.length; ++n) {
                int n7;
                int n8 = n7 = n3 == -1 ? nArray.length - 1 - n : n;
                if ((n4 & 1 << n7) == 0) continue;
                nArray[n7] = n2;
                n2 += n6;
            }
        }
        return nArray;
    }

    private long applyStrokeStart(TGNote tGNote, long l, int[] nArray) {
        return l + (long)nArray[tGNote.getString() - 1];
    }

    private long applyStrokeDuration(TGNote tGNote, long l, int[] nArray) {
        return l - (long)nArray[tGNote.getString() - 1];
    }

    private BeatData checkTripletFeel(TGVoice tGVoice, int n) {
        long l = tGVoice.getBeat().getStart();
        long l2 = tGVoice.getDuration().getTime();
        if (tGVoice.getBeat().getMeasure().getTripletFeel() == 2) {
            if (tGVoice.getDuration().isEqual(this.newDuration(8))) {
                TGVoice tGVoice2;
                if (l % 960L == 0L) {
                    TGVoice tGVoice3 = this.getNextBeat(tGVoice, n);
                    if (tGVoice3 == null || tGVoice3.getBeat().getStart() > l + tGVoice.getDuration().getTime() || tGVoice3.getDuration().isEqual(this.newDuration(8))) {
                        TGDuration tGDuration = this.newDuration(8);
                        tGDuration.getDivision().setEnters(3);
                        tGDuration.getDivision().setTimes(2);
                        l2 = tGDuration.getTime() * 2L;
                    }
                } else if (l % 480L == 0L && ((tGVoice2 = this.getPreviousBeat(tGVoice, n)) == null || tGVoice2.getBeat().getStart() < l - tGVoice.getDuration().getTime() || tGVoice2.getDuration().isEqual(this.newDuration(8)))) {
                    TGDuration tGDuration = this.newDuration(8);
                    tGDuration.getDivision().setEnters(3);
                    tGDuration.getDivision().setTimes(2);
                    l = l - tGVoice.getDuration().getTime() + tGDuration.getTime() * 2L;
                    l2 = tGDuration.getTime();
                }
            }
        } else if (tGVoice.getBeat().getMeasure().getTripletFeel() == 3 && tGVoice.getDuration().isEqual(this.newDuration(16))) {
            TGVoice tGVoice4;
            if (l % 480L == 0L) {
                TGVoice tGVoice5 = this.getNextBeat(tGVoice, n);
                if (tGVoice5 == null || tGVoice5.getBeat().getStart() > l + tGVoice.getDuration().getTime() || tGVoice5.getDuration().isEqual(this.newDuration(16))) {
                    TGDuration tGDuration = this.newDuration(16);
                    tGDuration.getDivision().setEnters(3);
                    tGDuration.getDivision().setTimes(2);
                    l2 = tGDuration.getTime() * 2L;
                }
            } else if (l % 240L == 0L && ((tGVoice4 = this.getPreviousBeat(tGVoice, n)) == null || tGVoice4.getBeat().getStart() < l - tGVoice.getDuration().getTime() || tGVoice4.getDuration().isEqual(this.newDuration(16)))) {
                TGDuration tGDuration = this.newDuration(16);
                tGDuration.getDivision().setEnters(3);
                tGDuration.getDivision().setTimes(2);
                l = l - tGVoice.getDuration().getTime() + tGDuration.getTime() * 2L;
                l2 = tGDuration.getTime();
            }
        }
        return new BeatData(l, l2);
    }

    private TGDuration newDuration(int n) {
        TGDuration tGDuration = this.manager.getFactory().newDuration();
        tGDuration.setValue(n);
        return tGDuration;
    }

    private TGVoice getPreviousBeat(TGVoice tGVoice, int n) {
        TGVoice tGVoice2 = null;
        for (int i = n - 1; i >= 0; --i) {
            TGBeat tGBeat = tGVoice.getBeat().getMeasure().getBeat(i);
            if (tGBeat.getStart() >= tGVoice.getBeat().getStart() || tGBeat.getVoice(tGVoice.getIndex()).isEmpty() || tGVoice2 != null && tGBeat.getStart() <= tGVoice2.getBeat().getStart()) continue;
            tGVoice2 = tGBeat.getVoice(tGVoice.getIndex());
        }
        return tGVoice2;
    }

    private TGVoice getNextBeat(TGVoice tGVoice, int n) {
        TGVoice tGVoice2 = null;
        for (int i = n + 1; i < tGVoice.getBeat().getMeasure().countBeats(); ++i) {
            TGBeat tGBeat = tGVoice.getBeat().getMeasure().getBeat(i);
            if (tGBeat.getStart() <= tGVoice.getBeat().getStart() || tGBeat.getVoice(tGVoice.getIndex()).isEmpty() || tGVoice2 != null && tGBeat.getStart() >= tGVoice2.getBeat().getStart()) continue;
            tGVoice2 = tGBeat.getVoice(tGVoice.getIndex());
        }
        return tGVoice2;
    }

    private TGNote getNextNote(TGNote tGNote, TGTrack tGTrack, int n, int n2, boolean bl) {
        int n3 = n2 + 1;
        int n4 = this.eHeader == -1 ? tGTrack.countMeasures() : Math.min(this.eHeader, tGTrack.countMeasures());
        for (int i = n; i < n4; ++i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            int n5 = tGMeasure.countBeats();
            for (int j = n3; j < n5; ++j) {
                TGBeat tGBeat = tGMeasure.getBeat(j);
                TGVoice tGVoice = tGBeat.getVoice(tGNote.getVoice().getIndex());
                if (tGVoice.isEmpty()) continue;
                int n6 = tGVoice.countNotes();
                for (int k = 0; k < n6; ++k) {
                    TGNote tGNote2 = tGVoice.getNote(k);
                    if (tGNote2.getString() != tGNote.getString()) continue;
                    return tGNote2;
                }
                if (!bl) continue;
                return null;
            }
            n3 = 0;
        }
        return null;
    }

    private TGNote getPreviousNote(TGNote tGNote, TGTrack tGTrack, int n, int n2, boolean bl) {
        int n3 = n2;
        for (int i = n; i >= 0; --i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            if (this.sHeader == -1 || this.sHeader <= tGMeasure.getNumber()) {
                n3 = n3 < 0 ? tGMeasure.countBeats() : n3;
                for (int j = n3 - 1; j >= 0; --j) {
                    TGBeat tGBeat = tGMeasure.getBeat(j);
                    TGVoice tGVoice = tGBeat.getVoice(tGNote.getVoice().getIndex());
                    if (tGVoice.isEmpty()) continue;
                    int n4 = tGVoice.countNotes();
                    for (int k = 0; k < n4; ++k) {
                        TGNote tGNote2 = tGVoice.getNote(k);
                        if (tGNote2.getString() != tGNote.getString()) continue;
                        return tGNote2;
                    }
                    if (!bl) continue;
                    return null;
                }
            }
            n3 = -1;
        }
        return null;
    }

    private class BeatData {
        private long start;
        private long duration;

        public BeatData(long l, long l2) {
            this.start = l;
            this.duration = l2;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getStart() {
            return this.start;
        }
    }
}

