/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasure;

public class UndoableChangeOpenRepeat
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;

    private UndoableChangeOpenRepeat() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.changeOpenRepeat(this.position);
        TGMeasure tGMeasure = tGSongManager.getTrackManager().getMeasureAt(tGSongManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(tGMeasure.getNumber());
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.changeOpenRepeat(this.position);
        TGMeasure tGMeasure = tGSongManager.getTrackManager().getMeasureAt(tGSongManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(tGMeasure.getNumber());
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeOpenRepeat startUndo() {
        UndoableChangeOpenRepeat undoableChangeOpenRepeat = new UndoableChangeOpenRepeat();
        Caret caret = UndoableChangeOpenRepeat.getCaret();
        undoableChangeOpenRepeat.doAction = 1;
        undoableChangeOpenRepeat.undoCaret = new UndoableCaretHelper();
        undoableChangeOpenRepeat.position = caret.getPosition();
        return undoableChangeOpenRepeat;
    }

    public UndoableChangeOpenRepeat endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

