/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableJoined
implements UndoableEdit {
    private int doAction = 1;
    private UndoableCaretHelper undoCaret = new UndoableCaretHelper();
    private UndoableCaretHelper redoCaret;
    private List undoables = new ArrayList();

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        this.undoables.add(undoableEdit);
    }

    public void redo() throws CannotRedoException {
        int n = this.undoables.size();
        for (int i = 0; i < n; ++i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.undoables.get(i);
            undoableEdit.redo();
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        int n = this.undoables.size();
        for (int i = n - 1; i >= 0; --i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.undoables.get(i);
            undoableEdit.undo();
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public UndoableJoined endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    public boolean isEmpty() {
        return this.undoables.isEmpty();
    }
}

