/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.dialog;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserBar;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserDialog;

public class TGBrowserMenuBar
extends TGBrowserBar {
    private Menu menu;
    private Menu newCollection;
    private Menu openCollection;
    private Menu removeCollection;
    private MenuItem menuFileItem;
    private MenuItem menuCollectionItem;
    private MenuItem menuGoItem;
    private MenuItem open;
    private MenuItem exit;
    private MenuItem newItem;
    private MenuItem openItem;
    private MenuItem removeItem;
    private MenuItem close;
    private MenuItem root;
    private MenuItem back;
    private MenuItem refresh;

    public TGBrowserMenuBar(TGBrowserDialog tGBrowserDialog) {
        super(tGBrowserDialog);
    }

    public void init(Shell shell) {
        this.menu = new Menu((Decorations)shell, 2);
        Menu menu = new Menu((Decorations)shell, 4);
        this.menuFileItem = new MenuItem(this.menu, 64);
        this.menuFileItem.setMenu(menu);
        this.open = new MenuItem(menu, 8);
        this.open.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.getBrowser().openElement();
            }
        });
        new MenuItem(menu, 2);
        this.exit = new MenuItem(menu, 8);
        this.exit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.getBrowser().getShell().dispose();
            }
        });
        Menu menu2 = new Menu((Decorations)shell, 4);
        this.menuCollectionItem = new MenuItem(this.menu, 64);
        this.menuCollectionItem.setMenu(menu2);
        this.newCollection = new Menu((Decorations)menu2.getShell(), 4);
        this.newItem = new MenuItem(menu2, 64);
        this.newItem.setImage(TuxGuitar.instance().getIconManager().getBrowserNew());
        this.newItem.setMenu(this.newCollection);
        this.updateTypes();
        this.openCollection = new Menu((Decorations)menu2.getShell(), 4);
        this.openItem = new MenuItem(menu2, 64);
        this.openItem.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.openItem.setMenu(this.openCollection);
        this.removeCollection = new Menu((Decorations)menu2.getShell(), 4);
        this.removeItem = new MenuItem(menu2, 64);
        this.removeItem.setMenu(this.removeCollection);
        new MenuItem(menu2, 2);
        this.close = new MenuItem(menu2, 8);
        this.close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.closeCollection();
            }
        });
        Menu menu3 = new Menu((Decorations)shell, 4);
        this.menuGoItem = new MenuItem(this.menu, 64);
        this.menuGoItem.setMenu(menu3);
        this.root = new MenuItem(menu3, 8);
        this.root.setImage(TuxGuitar.instance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.getBrowser().getConnection().cdRoot(3);
            }
        });
        this.back = new MenuItem(menu3, 8);
        this.back.setImage(TuxGuitar.instance().getIconManager().getBrowserBack());
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.getBrowser().getConnection().cdUp(4);
            }
        });
        this.refresh = new MenuItem(menu3, 8);
        this.refresh.setImage(TuxGuitar.instance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserMenuBar.this.getBrowser().getConnection().listElements(5);
            }
        });
        shell.setMenuBar(this.menu);
    }

    public void updateItems() {
        this.open.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.newItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.openItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.removeItem.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.close.setEnabled(!this.getBrowser().getConnection().isLocked());
    }

    public void loadProperties() {
        this.menuFileItem.setText(TuxGuitar.getProperty("browser.menu.file"));
        this.menuCollectionItem.setText(TuxGuitar.getProperty("browser.menu.collection"));
        this.menuGoItem.setText(TuxGuitar.getProperty("browser.menu.go"));
        this.open.setText(TuxGuitar.getProperty("browser.open"));
        this.exit.setText(TuxGuitar.getProperty("browser.exit"));
        this.newItem.setText(TuxGuitar.getProperty("browser.collection.new"));
        this.openItem.setText(TuxGuitar.getProperty("browser.collection.open"));
        this.removeItem.setText(TuxGuitar.getProperty("browser.collection.remove"));
        this.close.setText(TuxGuitar.getProperty("browser.collection.close"));
        this.root.setText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setText(TuxGuitar.getProperty("browser.refresh"));
    }

    public void updateCollections(TGBrowserCollection tGBrowserCollection) {
        MenuItem[] menuItemArray = this.openCollection.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].dispose();
        }
        MenuItem[] menuItemArray2 = this.removeCollection.getItems();
        for (int i = 0; i < menuItemArray2.length; ++i) {
            menuItemArray2[i].dispose();
        }
        Iterator iterator = TGBrowserManager.instance().getCollections();
        while (iterator.hasNext()) {
            final TGBrowserCollection tGBrowserCollection2 = (TGBrowserCollection)iterator.next();
            if (tGBrowserCollection2.getData() == null) continue;
            MenuItem menuItem = new MenuItem(this.openCollection, 8);
            menuItem.setText(tGBrowserCollection2.getData().getTitle());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGBrowserMenuBar.this.openCollection(tGBrowserCollection2);
                }
            });
            if (tGBrowserCollection != null && tGBrowserCollection.equals(tGBrowserCollection2)) {
                menuItem.setSelection(true);
            }
            MenuItem menuItem2 = new MenuItem(this.removeCollection, 8);
            menuItem2.setText(tGBrowserCollection2.getData().getTitle());
            menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGBrowserMenuBar.this.removeCollection(tGBrowserCollection2);
                }
            });
            if (tGBrowserCollection == null || !tGBrowserCollection.equals(tGBrowserCollection2)) continue;
            menuItem2.setSelection(true);
        }
    }

    public void updateTypes() {
        MenuItem[] menuItemArray = this.newCollection.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].dispose();
        }
        Iterator iterator = TGBrowserManager.instance().getFactories();
        while (iterator.hasNext()) {
            final TGBrowserFactory tGBrowserFactory = (TGBrowserFactory)iterator.next();
            MenuItem menuItem = new MenuItem(this.newCollection, 8);
            menuItem.setText(tGBrowserFactory.getName());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGBrowserMenuBar.this.newCollection(tGBrowserFactory.getType());
                }
            });
        }
    }

    public void reload(Shell shell) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.init(shell);
        this.loadProperties();
        this.updateItems();
    }
}

