/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollectionInfo;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserFactoryHandler;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserData;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.gui.tools.browser.filesystem.TGBrowserFactoryImpl;
import org.herac.tuxguitar.gui.tools.browser.xml.TGBrowserReader;
import org.herac.tuxguitar.gui.tools.browser.xml.TGBrowserWriter;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class TGBrowserManager {
    private static TGBrowserManager instance;
    private List factories = new ArrayList();
    private List collections = new ArrayList();
    private List collectionInfos = new ArrayList();
    private boolean changes;
    private TGBrowserFactoryHandler handler;

    private TGBrowserManager() {
        this.readCollections();
        this.addDefaultFactory();
    }

    public static TGBrowserManager instance() {
        if (instance == null) {
            instance = new TGBrowserManager();
        }
        return instance;
    }

    public void setFactoryHandler(TGBrowserFactoryHandler tGBrowserFactoryHandler) {
        this.handler = tGBrowserFactoryHandler;
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    public TGBrowserFactory getFactory(String string) {
        Iterator iterator = this.getFactories();
        while (iterator.hasNext()) {
            TGBrowserFactory tGBrowserFactory = (TGBrowserFactory)iterator.next();
            if (!tGBrowserFactory.getType().equals(string)) continue;
            return tGBrowserFactory;
        }
        return null;
    }

    public void addFactory(TGBrowserFactory tGBrowserFactory) {
        this.factories.add(tGBrowserFactory);
        Iterator iterator = this.collectionInfos.iterator();
        while (iterator.hasNext()) {
            TGBrowserCollectionInfo tGBrowserCollectionInfo = (TGBrowserCollectionInfo)iterator.next();
            if (!tGBrowserCollectionInfo.getType().equals(tGBrowserFactory.getType())) continue;
            TGBrowserCollection tGBrowserCollection = new TGBrowserCollection();
            tGBrowserCollection.setType(tGBrowserFactory.getType());
            tGBrowserCollection.setData(tGBrowserFactory.parseData(tGBrowserCollectionInfo.getData()));
            this.addCollection(tGBrowserCollection);
        }
        if (this.handler != null) {
            this.handler.notifyAdded();
        }
    }

    public void removeFactory(TGBrowserFactory tGBrowserFactory) {
        this.factories.remove(tGBrowserFactory);
        int n = 0;
        while (n < this.collections.size()) {
            TGBrowserCollection tGBrowserCollection = (TGBrowserCollection)this.collections.get(n);
            if (tGBrowserCollection.getType().equals(tGBrowserFactory.getType())) {
                this.removeCollection(tGBrowserCollection);
                continue;
            }
            ++n;
        }
        if (this.handler != null) {
            this.handler.notifyRemoved();
        }
    }

    public void addInfo(TGBrowserCollectionInfo tGBrowserCollectionInfo) {
        this.collectionInfos.add(tGBrowserCollectionInfo);
    }

    public Iterator getCollections() {
        return this.collections.iterator();
    }

    public int countCollections() {
        return this.collections.size();
    }

    public void removeCollection(TGBrowserCollection tGBrowserCollection) {
        this.collections.remove(tGBrowserCollection);
        this.changes = true;
    }

    public TGBrowserCollection addCollection(TGBrowserCollection tGBrowserCollection) {
        if (tGBrowserCollection.getData() != null) {
            TGBrowserCollection tGBrowserCollection2 = this.getCollection(tGBrowserCollection.getType(), tGBrowserCollection.getData());
            if (tGBrowserCollection2 != null) {
                return tGBrowserCollection2;
            }
            this.collections.add(tGBrowserCollection);
            this.changes = true;
        }
        return tGBrowserCollection;
    }

    public TGBrowserCollection getCollection(String string, TGBrowserData tGBrowserData) {
        Iterator iterator = this.getCollections();
        while (iterator.hasNext()) {
            TGBrowserCollection tGBrowserCollection = (TGBrowserCollection)iterator.next();
            if (!tGBrowserCollection.getType().equals(string) || !tGBrowserCollection.getData().equals(tGBrowserData)) continue;
            return tGBrowserCollection;
        }
        return null;
    }

    public TGBrowserCollection getCollection(int n) {
        if (n >= 0 && n < this.countCollections()) {
            return (TGBrowserCollection)this.collections.get(n);
        }
        return null;
    }

    public void readCollections() {
        new TGBrowserReader().loadCollections(this, new File(this.getCollectionsFileName()));
        this.changes = false;
    }

    public void writeCollections() {
        if (this.changes) {
            new TGBrowserWriter().saveCollections(this, this.getCollectionsFileName());
        }
        this.changes = false;
    }

    private String getCollectionsFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "browser-collections.xml";
    }

    private void addDefaultFactory() {
        this.addFactory(new TGBrowserFactoryImpl());
    }
}

