/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings;

import org.herac.tuxguitar.gui.system.keybindings.KeyConversion;

public class KeyBinding {
    public static final String MASK_SEPARATOR = "+";
    private int mask;
    private int key;

    public KeyBinding(int n, int n2) {
        this.key = n;
        this.mask = n2;
    }

    public KeyBinding() {
        this(0, 0);
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    private String getSpecialKey() {
        for (int i = 0; i < KeyConversion.relations.length; ++i) {
            if (this.key != KeyConversion.relations[i].getCode()) continue;
            return KeyConversion.relations[i].getKey();
        }
        return null;
    }

    private String getSpecialMask() {
        String string = new String();
        for (int i = 0; i < KeyConversion.relations.length; ++i) {
            if ((this.mask & KeyConversion.relations[i].getCode()) != KeyConversion.relations[i].getCode()) continue;
            string = string + KeyConversion.relations[i].getKey() + MASK_SEPARATOR;
        }
        return string;
    }

    public boolean isSameAs(KeyBinding keyBinding) {
        if (keyBinding != null) {
            return this.key == keyBinding.key && this.mask == keyBinding.mask;
        }
        return false;
    }

    public String toString() {
        String string = this.getSpecialMask();
        String string2 = this.getSpecialKey();
        return string2 != null ? string + string2 : string + (char)this.key;
    }

    public Object clone() {
        return new KeyBinding(this.getKey(), this.getMask());
    }
}

