/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class ToolBarsOption
extends Option {
    protected boolean initialized = false;
    protected Table table;
    protected TableColumn column;
    protected Button moveUp;
    protected Button moveDown;

    public ToolBarsOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.toolbars"), 4, 4);
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.toolbars"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionToolbars());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 4, 128, true, false, 16576, 1, 0, TuxGuitar.getProperty("settings.config.toolbars.tip"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData(4, 4));
        this.table = new Table(composite, 68388);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.column = new TableColumn(this.table, 16384);
        this.column.setText(TuxGuitar.getProperty("settings.config.toolbars.list"));
        this.column.pack();
        Composite composite2 = new Composite(this.getComposite(), 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.moveUp = new Button(composite2, 8);
        this.moveUp.setLayoutData((Object)this.getButtonData());
        this.moveUp.setText(TuxGuitar.getProperty("settings.config.toolbars.move-up"));
        this.moveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.moveUp();
            }
        });
        this.moveDown = new Button(composite2, 8);
        this.moveDown.setLayoutData((Object)this.getButtonData());
        this.moveDown.setText(TuxGuitar.getProperty("settings.config.toolbars.move-down"));
        this.moveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolBarsOption.this.moveDown();
            }
        });
        this.loadConfig();
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void moveUp() {
        if (this.initialized) {
            int n = this.table.getItemCount();
            int n2 = this.table.getSelectionIndex();
            if (n2 > 0 && n2 < n) {
                TableItem tableItem = this.table.getItem(n2);
                TableItem tableItem2 = this.table.getItem(n2 - 1);
                this.swapItems(tableItem, tableItem2);
                this.table.setSelection(n2 - 1);
            }
        }
    }

    protected void moveDown() {
        if (this.initialized) {
            int n = this.table.getItemCount();
            int n2 = this.table.getSelectionIndex();
            if (n2 >= 0 && n2 < n - 1) {
                TableItem tableItem = this.table.getItem(n2);
                TableItem tableItem2 = this.table.getItem(n2 + 1);
                this.swapItems(tableItem, tableItem2);
                this.table.setSelection(n2 + 1);
            }
        }
    }

    protected void swapItems(TableItem tableItem, TableItem tableItem2) {
        ToolItems toolItems = (ToolItems)tableItem.getData();
        ToolItems toolItems2 = (ToolItems)tableItem2.getData();
        this.loadItem(tableItem, toolItems2);
        this.loadItem(tableItem2, toolItems);
    }

    protected void loadItem(TableItem tableItem, ToolItems toolItems) {
        tableItem.setText(TuxGuitar.getProperty(toolItems.getName()));
        tableItem.setChecked(toolItems.isEnabled());
        tableItem.setData((Object)toolItems);
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final ToolItems[] toolItemsArray = TuxGuitar.instance().getItemManager().getToolBars();
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!ToolBarsOption.this.isDisposed()) {
                            for (int i = 0; i < toolItemsArray.length; ++i) {
                                ToolBarsOption.this.loadItem(new TableItem((this).ToolBarsOption.this.table, 0), toolItemsArray[i]);
                            }
                            (this).ToolBarsOption.this.initialized = true;
                            (this).ToolBarsOption.this.column.pack();
                            ToolBarsOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            for (int i = 0; i < this.table.getItemCount(); ++i) {
                TableItem tableItem = this.table.getItem(i);
                ToolItems toolItems = (ToolItems)tableItem.getData();
                TuxGuitar.instance().getItemManager().setToolBarStatus(toolItems.getName(), tableItem.getChecked(), i);
            }
            TuxGuitar.instance().getItemManager().writeToolBars();
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            TuxGuitar.instance().getItemManager().setDefaultToolBars();
            TuxGuitar.instance().getItemManager().writeToolBars();
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized && TuxGuitar.instance().getItemManager().shouldReloadToolBars()) {
            this.addSyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().loadToolBars();
                }
            });
        }
    }

    public Point computeSize() {
        return this.computeSize(-1, 0);
    }
}

