/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class StylesOption
extends Option {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 0;
    protected boolean initialized = false;
    protected FontData defaultFontData = new FontData();
    protected FontData noteFontData = new FontData();
    protected FontData timeSignatureFontData = new FontData();
    protected FontData textFontData = new FontData();
    protected FontData lyricFontData = new FontData();
    protected FontData printerDefaultFontData = new FontData();
    protected FontData printerNoteFontData = new FontData();
    protected FontData printerTSFontData = new FontData();
    protected FontData printerTextFontData = new FontData();
    protected FontData printerLyricFontData = new FontData();
    protected Button defaultFontButton;
    protected Button noteFontButton;
    protected Button timeSignatureFontButton;
    protected Button textFontButton;
    protected Button lyricFontButton;
    protected Button printerDefaultFontButton;
    protected Button printerNoteFontButton;
    protected Button printerTSFontButton;
    protected Button printerTextFontButton;
    protected Button printerLyricFontButton;
    protected ButtonColor scoreNoteColorButton;
    protected ButtonColor tabNoteColorButton;
    protected ButtonColor playNoteColorButton;
    protected ButtonColor linesColorButton;

    public StylesOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.styles"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionStyle());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.general"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.defaultFontButton = new Button(composite, 8);
        this.defaultFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.defaultFontButton, this.defaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.noteFontButton = new Button(composite, 8);
        this.noteFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.noteFontButton, this.noteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.lyricFontButton = new Button(composite, 8);
        this.lyricFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.lyricFontButton, this.lyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.textFontButton = new Button(composite, 8);
        this.textFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.textFontButton, this.textFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.timeSignatureFontButton = new Button(composite, 8);
        this.timeSignatureFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.timeSignatureFontButton, this.timeSignatureFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.score-note"));
        this.scoreNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
        this.tabNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.play-note"));
        this.playNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.lines"));
        this.linesColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.printer"));
        composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.printerDefaultFontButton = new Button(composite, 8);
        this.printerDefaultFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.printerDefaultFontButton, this.printerDefaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.printerNoteFontButton = new Button(composite, 8);
        this.printerNoteFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.printerNoteFontButton, this.printerNoteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.printerLyricFontButton = new Button(composite, 8);
        this.printerLyricFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.printerLyricFontButton, this.printerLyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.printerTextFontButton = new Button(composite, 8);
        this.printerTextFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.printerTextFontButton, this.printerTextFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.printerTSFontButton = new Button(composite, 8);
        this.printerTSFontButton.setLayoutData((Object)this.makeButtonData());
        this.addFontButtonListeners(this.printerTSFontButton, this.printerTSFontData);
        this.loadConfig();
    }

    private void addFontButtonListeners(final Button button, final FontData fontData) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (StylesOption.this.initialized) {
                    Font font = new Font((Device)StylesOption.this.getDisplay(), fontData);
                    FontData[] fontDataArray = font.getFontData();
                    font.dispose();
                    FontDialog fontDialog = new FontDialog(StylesOption.this.getShell());
                    fontDialog.setFontList(fontDataArray);
                    FontData fontData2 = fontDialog.open();
                    if (fontData2 != null) {
                        StylesOption.this.loadFontData(fontData2, fontData, button);
                    }
                }
            }
        });
    }

    protected void loadFontData(FontData fontData, FontData fontData2, Button button) {
        this.copyFontData(fontData, fontData2);
        this.setButtonFontData(button, fontData2);
    }

    protected void loadColor(ButtonColor buttonColor, RGB rGB) {
        buttonColor.loadColor(rGB);
    }

    protected void setButtonFontData(Button button, FontData fontData) {
        String string = fontData.getName();
        if ((fontData.getStyle() & 1) != 0) {
            string = string + " Bold";
        }
        if ((fontData.getStyle() & 2) != 0) {
            string = string + " Italic";
        }
        string = string + " " + fontData.getHeight();
        button.setText(string);
    }

    protected void copyFontData(FontData fontData, FontData fontData2) {
        fontData2.setName(fontData.getName());
        fontData2.setStyle(fontData.getStyle());
        fontData2.setHeight(fontData.getHeight());
    }

    protected void copyRGB(RGB rGB, RGB rGB2) {
        rGB2.red = rGB.red;
        rGB2.green = rGB.green;
        rGB2.blue = rGB.blue;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final FontData fontData = StylesOption.this.getConfig().getFontDataConfigValue("font.default");
                final FontData fontData2 = StylesOption.this.getConfig().getFontDataConfigValue("font.note");
                final FontData fontData3 = StylesOption.this.getConfig().getFontDataConfigValue("font.time-signature");
                final FontData fontData4 = StylesOption.this.getConfig().getFontDataConfigValue("font.text");
                final FontData fontData5 = StylesOption.this.getConfig().getFontDataConfigValue("font.lyric");
                final FontData fontData6 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.default");
                final FontData fontData7 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.note");
                final FontData fontData8 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.time-signature");
                final FontData fontData9 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.text");
                final FontData fontData10 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.lyric");
                final RGB rGB = StylesOption.this.getConfig().getRGBConfigValue("color.score.note");
                final RGB rGB2 = StylesOption.this.getConfig().getRGBConfigValue("color.tab.note");
                final RGB rGB3 = StylesOption.this.getConfig().getRGBConfigValue("color.play.note");
                final RGB rGB4 = StylesOption.this.getConfig().getRGBConfigValue("color.line");
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!StylesOption.this.isDisposed()) {
                            StylesOption.this.loadFontData(fontData, (this).StylesOption.this.defaultFontData, (this).StylesOption.this.defaultFontButton);
                            StylesOption.this.loadFontData(fontData2, (this).StylesOption.this.noteFontData, (this).StylesOption.this.noteFontButton);
                            StylesOption.this.loadFontData(fontData3, (this).StylesOption.this.timeSignatureFontData, (this).StylesOption.this.timeSignatureFontButton);
                            StylesOption.this.loadFontData(fontData4, (this).StylesOption.this.textFontData, (this).StylesOption.this.textFontButton);
                            StylesOption.this.loadFontData(fontData5, (this).StylesOption.this.lyricFontData, (this).StylesOption.this.lyricFontButton);
                            StylesOption.this.loadFontData(fontData6, (this).StylesOption.this.printerDefaultFontData, (this).StylesOption.this.printerDefaultFontButton);
                            StylesOption.this.loadFontData(fontData7, (this).StylesOption.this.printerNoteFontData, (this).StylesOption.this.printerNoteFontButton);
                            StylesOption.this.loadFontData(fontData8, (this).StylesOption.this.printerTSFontData, (this).StylesOption.this.printerTSFontButton);
                            StylesOption.this.loadFontData(fontData9, (this).StylesOption.this.printerTextFontData, (this).StylesOption.this.printerTextFontButton);
                            StylesOption.this.loadFontData(fontData10, (this).StylesOption.this.printerLyricFontData, (this).StylesOption.this.printerLyricFontButton);
                            (this).StylesOption.this.scoreNoteColorButton.loadColor(rGB);
                            (this).StylesOption.this.tabNoteColorButton.loadColor(rGB2);
                            (this).StylesOption.this.playNoteColorButton.loadColor(rGB3);
                            (this).StylesOption.this.linesColorButton.loadColor(rGB4);
                            (this).StylesOption.this.initialized = true;
                            StylesOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public GridData makeButtonData() {
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.minimumWidth = 200;
        gridData.minimumHeight = 0;
        return gridData;
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setProperty("font.default", this.defaultFontData);
            this.getConfig().setProperty("font.note", this.noteFontData);
            this.getConfig().setProperty("font.time-signature", this.timeSignatureFontData);
            this.getConfig().setProperty("font.text", this.textFontData);
            this.getConfig().setProperty("font.lyric", this.lyricFontData);
            this.getConfig().setProperty("font.printer.default", this.printerDefaultFontData);
            this.getConfig().setProperty("font.printer.note", this.printerNoteFontData);
            this.getConfig().setProperty("font.printer.time-signature", this.printerTSFontData);
            this.getConfig().setProperty("font.printer.text", this.printerTextFontData);
            this.getConfig().setProperty("font.printer.lyric", this.printerLyricFontData);
            this.getConfig().setProperty("color.score.note", this.scoreNoteColorButton.getValue());
            this.getConfig().setProperty("color.tab.note", this.tabNoteColorButton.getValue());
            this.getConfig().setProperty("color.play.note", this.playNoteColorButton.getValue());
            this.getConfig().setProperty("color.line", this.linesColorButton.getValue());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("font.default", this.getDefaults().getProperty("font.default"));
            this.getConfig().setProperty("font.note", this.getDefaults().getProperty("font.note"));
            this.getConfig().setProperty("font.time-signature", this.getDefaults().getProperty("font.time-signature"));
            this.getConfig().setProperty("font.text", this.getDefaults().getProperty("font.text"));
            this.getConfig().setProperty("font.lyric", this.getDefaults().getProperty("font.lyric"));
            this.getConfig().setProperty("font.printer.default", this.getDefaults().getProperty("font.printer.default"));
            this.getConfig().setProperty("font.printer.note", this.getDefaults().getProperty("font.printer.note"));
            this.getConfig().setProperty("font.printer.time-signature", this.getDefaults().getProperty("font.printer.time-signature"));
            this.getConfig().setProperty("font.printer.text", this.getDefaults().getProperty("font.printer.text"));
            this.getConfig().setProperty("font.printer.lyric", this.getDefaults().getProperty("font.printer.lyric"));
            this.getConfig().setProperty("color.score.note", this.getDefaults().getProperty("color.score.note"));
            this.getConfig().setProperty("color.tab.note", this.getDefaults().getProperty("color.tab.note"));
            this.getConfig().setProperty("color.play.note", this.getDefaults().getProperty("color.play.note"));
            this.getConfig().setProperty("color.line", this.getDefaults().getProperty("color.line"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            this.addSyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().loadStyles();
                }
            });
        }
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite composite, int n, Object object, String string) {
            this.button = new Button(composite, n);
            this.button.setLayoutData(object);
            this.button.setText(string);
            this.addListeners();
        }

        protected void loadColor(RGB rGB) {
            this.value.red = rGB.red;
            this.value.green = rGB.green;
            this.value.blue = rGB.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (((ButtonColor)ButtonColor.this).StylesOption.this.initialized) {
                        ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                        colorDialog.setRGB(ButtonColor.this.value);
                        colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                        RGB rGB = colorDialog.open();
                        if (rGB != null) {
                            ButtonColor.this.loadColor(rGB);
                        }
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

