/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class LanguageOption
extends Option {
    protected boolean initialized = false;
    protected Table table;
    protected TableColumn column;

    public LanguageOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.language"), 4, 4);
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionLanguage());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 4, 128, true, false, 16576, 1, 0, TuxGuitar.getProperty("settings.config.language.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData(4, 4));
        this.table = new Table(composite, 68356);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.column = new TableColumn(this.table, 16384);
        this.column.setText(TuxGuitar.getProperty("settings.config.language.choose"));
        this.column.pack();
        this.loadConfig();
    }

    protected void loadTableItem(String string, String string2, boolean bl) {
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(string);
        tableItem.setData((Object)string2);
        if (bl) {
            this.table.setSelection(tableItem);
        }
    }

    protected List getLanguageItems(String[] stringArray) {
        ArrayList<LanguageItem> arrayList = new ArrayList<LanguageItem>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new LanguageItem(stringArray[i], TuxGuitar.getProperty("locale." + stringArray[i])));
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof LanguageItem && object2 instanceof LanguageItem) {
                        LanguageItem languageItem = (LanguageItem)object;
                        LanguageItem languageItem2 = (LanguageItem)object2;
                        return languageItem.getValue().compareTo(languageItem2.getValue());
                    }
                    return 0;
                }
            });
        }
        return arrayList;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final String string = LanguageOption.this.getConfig().getStringConfigValue("language");
                final List list = LanguageOption.this.getLanguageItems(TuxGuitar.instance().getLanguageManager().getLanguages());
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!LanguageOption.this.isDisposed()) {
                            LanguageOption.this.loadTableItem(TuxGuitar.getProperty("locale.default"), new String(), true);
                            for (int i = 0; i < list.size(); ++i) {
                                LanguageItem languageItem = (LanguageItem)list.get(i);
                                LanguageOption.this.loadTableItem(languageItem.getValue(), languageItem.getKey(), string != null && languageItem.getKey().equals(string));
                            }
                            (this).LanguageOption.this.initialized = true;
                            (this).LanguageOption.this.column.pack();
                            LanguageOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            int n;
            String string = null;
            if (this.table != null && !this.table.isDisposed() && (n = this.table.getSelectionIndex()) >= 0 && n < this.table.getItemCount()) {
                string = (String)this.table.getItem(n).getData();
            }
            this.getConfig().setProperty("language", string);
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("language", this.getDefaults().getProperty("language"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            boolean bl2 = bl;
            if (!bl2) {
                String string = TuxGuitar.instance().getLanguageManager().getLanguage();
                String string2 = this.getConfig().getStringConfigValue("language");
                bl2 = string == null && string2 == null ? false : (string != null && string2 != null ? !string.equals(string2) : true);
            }
            if (bl2) {
                this.addSyncThread(new Runnable(){

                    public void run() {
                        TuxGuitar.instance().loadLanguage();
                    }
                });
            }
        }
    }

    public Point computeSize() {
        return this.computeSize(-1, 0);
    }

    private class LanguageItem {
        private String key;
        private String value;

        public LanguageItem(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

