/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.TGNote;

public class DynamicMenuItem
extends MenuItems {
    private MenuItem dynamicMenuItem;
    private Menu menu;
    private MenuItem pianoPianissimo;
    private MenuItem pianissimo;
    private MenuItem piano;
    private MenuItem mezzoPiano;
    private MenuItem mezzoForte;
    private MenuItem forte;
    private MenuItem fortissimo;
    private MenuItem forteFortissimo;

    public DynamicMenuItem(Shell shell, Menu menu, int n) {
        this.dynamicMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.pianoPianissimo = new MenuItem(this.menu, 32);
        this.pianoPianissimo.setData((Object)new Integer(15));
        this.pianoPianissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.pianissimo = new MenuItem(this.menu, 32);
        this.pianissimo.setData((Object)new Integer(31));
        this.pianissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.piano = new MenuItem(this.menu, 32);
        this.piano.setData((Object)new Integer(47));
        this.piano.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoPiano = new MenuItem(this.menu, 32);
        this.mezzoPiano.setData((Object)new Integer(63));
        this.mezzoPiano.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoForte = new MenuItem(this.menu, 32);
        this.mezzoForte.setData((Object)new Integer(79));
        this.mezzoForte.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forte = new MenuItem(this.menu, 32);
        this.forte.setData((Object)new Integer(95));
        this.forte.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.fortissimo = new MenuItem(this.menu, 32);
        this.fortissimo.setData((Object)new Integer(111));
        this.fortissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forteFortissimo = new MenuItem(this.menu, 32);
        this.forteFortissimo.setData((Object)new Integer(127));
        this.forteFortissimo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.dynamicMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote tGNote = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        int n = tGNote != null ? tGNote.getVelocity() : TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getVelocity();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.pianoPianissimo.setSelection(n == 15);
        this.pianoPianissimo.setEnabled(!bl);
        this.pianissimo.setSelection(n == 31);
        this.pianissimo.setEnabled(!bl);
        this.piano.setSelection(n == 47);
        this.piano.setEnabled(!bl);
        this.mezzoPiano.setSelection(n == 63);
        this.mezzoPiano.setEnabled(!bl);
        this.mezzoForte.setSelection(n == 79);
        this.mezzoForte.setEnabled(!bl);
        this.forte.setSelection(n == 95);
        this.forte.setEnabled(!bl);
        this.fortissimo.setSelection(n == 111);
        this.fortissimo.setEnabled(!bl);
        this.forteFortissimo.setSelection(n == 127);
        this.forteFortissimo.setEnabled(!bl);
    }

    public void loadProperties() {
        this.dynamicMenuItem.setText(TuxGuitar.getProperty("dynamic"));
        this.pianoPianissimo.setText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }

    public void loadIcons() {
    }
}

