/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGBeatSpacing;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGNotePainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGNoteImpl
extends TGNote {
    private Rectangle noteOrientation = new Rectangle(0, 0, 0, 0);
    private int tabPosY;
    private int scorePosY;
    private int accidental;

    public TGNoteImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public void update(ViewLayout viewLayout) {
        this.accidental = this.getMeasureImpl().getNoteAccidental(this.getRealValue());
        this.tabPosY = this.getString() * viewLayout.getStringSpacing() - viewLayout.getStringSpacing();
        this.scorePosY = this.getVoiceImpl().getBeatGroup().getY1(viewLayout, this, this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        int n3 = this.getBeatImpl().getSpacing();
        this.paintScoreNote(viewLayout, tGPainter, n, n2 + this.getPaintPosition(8), n3);
        if (!viewLayout.isPlayModeEnabled()) {
            this.paintOfflineEffects(viewLayout, tGPainter, n, n2, n3);
        }
        this.paintTablatureNote(viewLayout, tGPainter, n, n2 + this.getPaintPosition(13), n3);
    }

    private void paintOfflineEffects(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4;
        int n5;
        TGBeatSpacing tGBeatSpacing = this.getBeatImpl().getBs();
        TGTrackSpacing tGTrackSpacing = this.getMeasureImpl().getTs();
        TGNoteEffect tGNoteEffect = this.getEffect();
        int n6 = n2 + tGTrackSpacing.getPosition(11);
        int n7 = n6 + (tGTrackSpacing.getSize(11) - tGBeatSpacing.getSize());
        viewLayout.setOfflineEffectStyle(tGPainter);
        if (tGNoteEffect.isAccentuatedNote()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(0);
            this.paintAccentuated(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isHeavyAccentuatedNote()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(1);
            this.paintHeavyAccentuated(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isFadeIn()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(9);
            this.paintFadeIn(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isHarmonic() && (viewLayout.getStyle() & 4) == 0) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(2);
            String string = new String();
            string = tGNoteEffect.getHarmonic().isNatural() ? "N.H" : string;
            string = tGNoteEffect.getHarmonic().isArtificial() ? "A.H" : string;
            string = tGNoteEffect.getHarmonic().isTapped() ? "T.H" : string;
            string = tGNoteEffect.getHarmonic().isPinch() ? "P.H" : string;
            string = tGNoteEffect.getHarmonic().isSemi() ? "S.H" : string;
            tGPainter.drawString(string, n5, n4);
        }
        if (tGNoteEffect.isTapping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(3);
            tGPainter.drawString("T", n5, n4);
        }
        if (tGNoteEffect.isSlapping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(4);
            tGPainter.drawString("S", n5, n4);
        }
        if (tGNoteEffect.isPopping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(5);
            tGPainter.drawString("P", n5, n4);
        }
        if (tGNoteEffect.isPalmMute()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(6);
            tGPainter.drawString("P.M", n5, n4);
        }
        if (tGNoteEffect.isVibrato()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(7);
            this.paintVibrato(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isTrill()) {
            n5 = n + this.getPosX() + n3;
            n4 = n7 + tGBeatSpacing.getPosition(8);
            this.paintTrill(viewLayout, tGPainter, n5, n4);
        }
    }

    public void paintTablatureNote(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4 = viewLayout.getStyle();
        if ((n4 & 8) != 0) {
            int n5 = viewLayout.getStringSpacing();
            int n6 = n + this.getPosX() + n3 + 2;
            int n7 = n2 + this.getTabPosY();
            this.noteOrientation.x = n6;
            this.noteOrientation.y = n7;
            this.noteOrientation.width = 1;
            this.noteOrientation.height = 1;
            viewLayout.setTabNoteStyle(tGPainter, viewLayout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(viewLayout));
            if (this.isTiedNote() && (n4 & 4) == 0) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = n5 * 3;
                TGNoteImpl tGNoteImpl = this.getNoteForTie();
                if (tGNoteImpl != null) {
                    f = n + tGNoteImpl.getPosX() + tGNoteImpl.getBeatImpl().getSpacing();
                    f2 = n2 + tGNoteImpl.getTabPosY() + n5;
                    f3 = (float)n6 - f;
                } else {
                    Rectangle rectangle = viewLayout.getNoteOrientation(tGPainter, n6, n7, this);
                    f = rectangle.x - n5 * 2;
                    f2 = n2 + this.getTabPosY() + n5;
                    f3 = n5 * 2;
                }
                tGPainter.initPath();
                tGPainter.addArc(f, f2 - f4, f3, f4, 225.0f, 90.0f);
                tGPainter.closePath();
            } else if (!this.isTiedNote()) {
                Rectangle rectangle = viewLayout.getNoteOrientation(tGPainter, n6, n7, this);
                this.noteOrientation.x = rectangle.x;
                this.noteOrientation.y = rectangle.y;
                this.noteOrientation.width = rectangle.width;
                this.noteOrientation.height = rectangle.height;
                String string = this.getEffect().isDeadNote() ? "X" : Integer.toString(this.getValue());
                string = this.getEffect().isGhostNote() ? "(" + string + ")" : string;
                tGPainter.drawString(string, this.noteOrientation.x, this.noteOrientation.y);
            }
            if (!viewLayout.isPlayModeEnabled()) {
                this.paintEffects(viewLayout, tGPainter, n, n2, n3);
                if ((n4 & 4) == 0) {
                    int n8 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n5 / 2;
                    int n9 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n5 / 2 * 5;
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setTabEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n10 = n8 + (n9 - n8) / 2;
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            tGPainter.moveTo(n6 - 3, n10 - 1);
                            tGPainter.lineTo(n6 + 4, n10 + 1);
                            n10 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            }
        }
    }

    private void paintScoreNote(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        if ((viewLayout.getStyle() & 4) != 0) {
            float f = viewLayout.getScoreLineSpacing();
            int n4 = this.getVoiceImpl().getBeatGroup().getDirection();
            int n5 = this.getMeasureImpl().getKeySignature();
            int n6 = this.getMeasureImpl().getClef();
            int n7 = n + this.getPosX() + n3;
            int n8 = n2 + this.getScorePosY();
            boolean bl = viewLayout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(viewLayout);
            viewLayout.setScoreNoteStyle(tGPainter, bl);
            if (this.isTiedNote()) {
                TGNoteImpl tGNoteImpl = this.getNoteForTie();
                float f2 = f / 8.0f;
                float f3 = (float)n7 - 20.0f * f2;
                float f4 = (float)n8 - 2.0f * f2;
                float f5 = 20.0f * f2;
                float f6 = 30.0f * f2;
                if (tGNoteImpl != null) {
                    int n9 = n + tGNoteImpl.getPosX() + tGNoteImpl.getBeatImpl().getSpacing();
                    int n10 = n2 + this.getScorePosY();
                    f3 = (float)n9 + 6.0f * f2;
                    f4 = (float)n10 - 3.0f * f2;
                    f5 = (float)(n7 - n9) - 3.0f * f2;
                    f6 = 35.0f * f2;
                }
                tGPainter.initPath();
                tGPainter.addArc(f3, f4, f5, f6, 45.0f, 90.0f);
                tGPainter.closePath();
            }
            if (this.accidental == 1) {
                tGPainter.initPath(2);
                TGKeySignaturePainter.paintNatural(tGPainter, (float)n7 - (f - f / 4.0f), (float)n8 + f / 2.0f, f);
                tGPainter.closePath();
            } else if (this.accidental == 2) {
                tGPainter.initPath(2);
                TGKeySignaturePainter.paintSharp(tGPainter, (float)n7 - (f - f / 4.0f), (float)n8 + f / 2.0f, f);
                tGPainter.closePath();
            } else if (this.accidental == 3) {
                tGPainter.initPath(2);
                TGKeySignaturePainter.paintFlat(tGPainter, (float)n7 - (f - f / 4.0f), (float)n8 + f / 2.0f, f);
                tGPainter.closePath();
            }
            if (this.getEffect().isHarmonic()) {
                if (viewLayout.isBufferEnabled()) {
                    tGPainter.drawImage(viewLayout.getResources().getHarmonicNote(this.getVoice().getDuration().getValue(), bl), n7, n8);
                } else {
                    boolean bl2 = this.getVoice().getDuration().getValue() >= 4;
                    tGPainter.initPath(bl2 ? 3 : 1);
                    TGNotePainter.paintHarmonic(tGPainter, n7, n8 + 1, viewLayout.getScoreLineSpacing() - 2);
                    tGPainter.closePath();
                }
            } else if (viewLayout.isBufferEnabled()) {
                tGPainter.drawImage(viewLayout.getResources().getScoreNote(this.getVoice().getDuration().getValue(), bl), n7, n8);
            } else {
                boolean bl3 = this.getVoice().getDuration().getValue() >= 4;
                tGPainter.initPath(bl3 ? 2 : 1);
                TGNotePainter.paintNote(tGPainter, n7, n8 + 1, (bl3 ? viewLayout.getScoreLineSpacing() + 1 : viewLayout.getScoreLineSpacing()) - 2);
                tGPainter.closePath();
            }
            if (!viewLayout.isPlayModeEnabled()) {
                if (this.getEffect().isGrace()) {
                    this.paintGrace(viewLayout, tGPainter, n7, n8);
                }
                if (this.getVoice().getDuration().isDotted() || this.getVoice().getDuration().isDoubleDotted()) {
                    this.getVoiceImpl().paintDot(viewLayout, tGPainter, (float)n7 + 12.0f * (f / 8.0f), n8 + viewLayout.getScoreLineSpacing() / 2, f / 10.0f);
                }
                if (this.getVoice().getDuration().getValue() >= 2) {
                    viewLayout.setScoreNoteFooterStyle(tGPainter);
                    int n11 = n4 == 1 ? viewLayout.getResources().getScoreNoteWidth() : 0;
                    int n12 = n2 + this.getVoiceImpl().getBeatGroup().getY2(viewLayout, this.getPosX() + n3, n5, n6);
                    if (this.getEffect().isStaccato()) {
                        int n13 = 3;
                        int n14 = n7 + n11;
                        int n15 = n12 + 4 * (n4 == 1 ? -1 : 1);
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath(2);
                        tGPainter.moveTo(n14 - n13 / 2, n15 - n13 / 2);
                        tGPainter.addOval(n14 - n13 / 2, n15 - n13 / 2, n13, n13);
                        tGPainter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n16 = n2;
                        n16 = n4 == 1 ? (n16 += this.getVoiceImpl().getBeatGroup().getMaxNote().getScorePosY() - viewLayout.getScoreLineSpacing() - 4) : (n16 += this.getVoiceImpl().getBeatGroup().getMinNote().getScorePosY() + viewLayout.getScoreLineSpacing() + 4);
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            tGPainter.moveTo(n7 + n11 - 3, n16 + 1);
                            tGPainter.lineTo(n7 + n11 + 4, n16 - 1);
                            n16 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                } else {
                    if (this.getEffect().isStaccato()) {
                        int n17 = 3;
                        int n18 = n7 + viewLayout.getResources().getScoreNoteWidth() / 2;
                        int n19 = n2 + this.getVoiceImpl().getBeatGroup().getMinNote().getScorePosY() + viewLayout.getScoreLineSpacing() + 2;
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath(2);
                        tGPainter.moveTo(n18 - n17 / 2, n19 - n17 / 2);
                        tGPainter.addOval(n18 - n17 / 2, n19 - n17 / 2, n17, n17);
                        tGPainter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n20 = n7 + viewLayout.getResources().getScoreNoteWidth() / 2;
                        int n21 = n2 + (this.getVoiceImpl().getBeatGroup().getMaxNote().getScorePosY() - viewLayout.getScoreLineSpacing() - 4);
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            tGPainter.moveTo(n20 - 3, n21 + 1);
                            tGPainter.lineTo(n20 + 4, n21 - 1);
                            n21 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            }
        }
    }

    private TGNoteImpl getNoteForTie() {
        for (int i = this.getMeasureImpl().countBeats() - 1; i >= 0; --i) {
            TGBeat tGBeat = this.getMeasureImpl().getBeat(i);
            TGVoice tGVoice = tGBeat.getVoice(this.getVoice().getIndex());
            if (tGBeat.getStart() >= this.getBeatImpl().getStart() || tGVoice.isRestVoice()) continue;
            Iterator iterator = tGVoice.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                if (tGNoteImpl.getString() != this.getString()) continue;
                return tGNoteImpl;
            }
        }
        return null;
    }

    private void paintEffects(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        Object object;
        int n4 = n + this.getPosX() + n3;
        int n5 = n2 + this.getTabPosY();
        TGNoteEffect tGNoteEffect = this.getEffect();
        if (tGNoteEffect.isGrace()) {
            viewLayout.setTabGraceStyle(tGPainter);
            String string = Integer.toString(tGNoteEffect.getGrace().getFret());
            object = tGPainter.getStringExtent(string);
            tGPainter.drawString(string, this.noteOrientation.x - object.x - 2, this.noteOrientation.y);
        }
        if (tGNoteEffect.isBend()) {
            this.paintBend(viewLayout, tGPainter, this.noteOrientation.x + this.noteOrientation.width, n5);
        } else if (tGNoteEffect.isTremoloBar()) {
            this.paintTremoloBar(viewLayout, tGPainter, this.noteOrientation.x + this.noteOrientation.width, n5);
        } else if (tGNoteEffect.isSlide() || tGNoteEffect.isHammer()) {
            int n6 = n;
            object = (TGNoteImpl)viewLayout.getSongManager().getMeasureManager().getNextNote(this.getMeasureImpl(), this.getBeatImpl().getStart(), this.getVoice().getIndex(), this.getString());
            if (tGNoteEffect.isSlide()) {
                this.paintSlide(viewLayout, tGPainter, (TGNoteImpl)object, n4, n5, n6);
            } else if (tGNoteEffect.isHammer()) {
                this.paintHammer(viewLayout, tGPainter, (TGNoteImpl)object, n4, n5, n6);
            }
        }
    }

    private void paintBend(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = (float)n + 1.0f * f;
        float f3 = (float)n2 - 2.0f * f;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.lineTo(f2 + 1.0f * f, f3);
        tGPainter.cubicTo(f2 + 1.0f * f, f3, f2 + 3.0f * f, f3, f2 + 3.0f * f, f3 - 2.0f * f);
        tGPainter.lineTo(f2 + 3.0f * f, f3 - 12.0f * f);
        tGPainter.lineTo(f2 + 1.0f * f, f3 - 10.0f * f);
        tGPainter.moveTo(f2 + 3.0f * f, f3 - 12.0f * f);
        tGPainter.lineTo(f2 + 5.0f * f, f3 - 10.0f * f);
        tGPainter.closePath();
    }

    private void paintTremoloBar(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = (float)n + 1.0f * f;
        float f3 = f2 + 8.0f * f;
        float f4 = n2;
        float f5 = f4 + 9.0f * f;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.moveTo(f2, f4);
        tGPainter.lineTo(f2 + (f3 - f2) / 2.0f, f5);
        tGPainter.lineTo(f3, f4);
        tGPainter.closePath();
    }

    private void paintSlide(ViewLayout viewLayout, TGPainter tGPainter, TGNoteImpl tGNoteImpl, int n, int n2, int n3) {
        float f = viewLayout.getScale();
        float f2 = (float)viewLayout.getStringSpacing() / 10.0f;
        float f3 = 3.0f * f2;
        float f4 = n;
        float f5 = n2;
        viewLayout.setTabEffectStyle(tGPainter);
        if (tGNoteImpl != null) {
            float f6 = tGNoteImpl.getPosX() + n3 + tGNoteImpl.getBeatImpl().getSpacing();
            float f7 = f5;
            if (tGNoteImpl.getValue() < this.getValue()) {
                f5 -= f3;
                f7 += f3;
            } else if (tGNoteImpl.getValue() > this.getValue()) {
                f5 += f3;
                f7 -= f3;
            } else {
                f5 -= f3;
                f7 -= f3;
            }
            tGPainter.initPath();
            tGPainter.moveTo(f4 + 6.0f * f, f5);
            tGPainter.lineTo(f6 - 3.0f * f, f7);
            tGPainter.closePath();
        } else {
            tGPainter.initPath();
            tGPainter.moveTo(f4 + 6.0f * f, f5 - f3);
            tGPainter.lineTo(f4 + 17.0f * f, f5 - f3);
            tGPainter.closePath();
        }
    }

    private void paintHammer(ViewLayout viewLayout, TGPainter tGPainter, TGNoteImpl tGNoteImpl, int n, int n2, int n3) {
        float f = viewLayout.getScale();
        float f2 = (float)viewLayout.getStringSpacing() / 10.0f;
        float f3 = (float)n + 7.0f * f;
        float f4 = (float)n2 - 5.0f * f2;
        float f5 = tGNoteImpl != null ? (float)(tGNoteImpl.getPosX() + n3 + tGNoteImpl.getBeatImpl().getSpacing()) - 4.0f * f - f3 : 10.0f * f;
        float f6 = 15.0f * f2;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.addArc(f3, f4, f5, f6, 45.0f, 90.0f);
        tGPainter.closePath();
    }

    private void paintGrace(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = (float)viewLayout.getScoreLineSpacing() / 2.25f;
        float f2 = (float)n - 2.0f * f;
        float f3 = (float)n2 + f / 3.0f;
        viewLayout.setScoreEffectStyle(tGPainter);
        tGPainter.initPath(2);
        TGNotePainter.paintFooter(tGPainter, f2, f3, -1, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3 - 2.0f * f);
        tGPainter.lineTo(f2, f3 + 2.0f * f - f / 4.0f);
        tGPainter.closePath();
        tGPainter.initPath(3);
        TGNotePainter.paintNote(tGPainter, f2 - f * 1.33f, f3 + f + f / 4.0f, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(f2 - f, f3);
        tGPainter.lineTo(f2 + f, f3 - f);
        tGPainter.closePath();
    }

    private void paintVibrato(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 2.0f * f;
        float f4 = (float)this.getVoiceImpl().getWidth() - 2.0f * f;
        int n3 = (int)(f4 / (6.0f * f));
        if (n3 > 0) {
            int n4;
            viewLayout.setTabEffectStyle(tGPainter);
            tGPainter.initPath(2);
            tGPainter.moveTo(f2 + 2.0f * f, f3 + 1.0f * f);
            for (n4 = 0; n4 < n3; ++n4) {
                f2 = (float)n + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
                tGPainter.cubicTo(f2 + 2.0f * f, f3 + 1.0f * f, f2 + 3.0f * f, f3, f2 + 4.0f * f, f3 + 1.0f * f);
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 3.0f * f);
            }
            tGPainter.lineTo(f2 + 7.0f * f, f3 + 2.0f * f);
            tGPainter.cubicTo(f2 + 7.0f * f, f3 + 2.0f * f, f2 + 8.0f * f, f3 + 2.0f * f, f2 + 7.0f * f, f3 + 3.0f * f);
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                f2 = (float)n + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 4.0f * f);
                tGPainter.cubicTo(f2 + 6.0f * f, f3 + 4.0f * f, f2 + 5.0f * f, f3 + 5.0f * f, f2 + 4.0f * f, f3 + 4.0f * f);
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 2.0f * f);
                tGPainter.lineTo(f2 + 1.0f * f, f3 + 3.0f * f);
            }
            tGPainter.cubicTo(f2 + 1.0f * f, f3 + 3.0f * f, f2, f3 + 3.0f * f, f2 + 1.0f * f, f3 + 2.0f * f);
            tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
            tGPainter.closePath();
        }
    }

    private void paintTrill(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        String string = "Tr";
        Point point = tGPainter.getStringExtent(string);
        float f = viewLayout.getScale();
        float f2 = n + point.x;
        float f3 = (float)n2 + ((float)point.y - 5.0f * f) / 2.0f;
        float f4 = (float)(this.getVoiceImpl().getWidth() - point.x) - 2.0f * f;
        int n3 = (int)(f4 / (6.0f * f));
        if (n3 > 0) {
            int n4;
            tGPainter.drawString(string, n, n2);
            viewLayout.setTabEffectStyle(tGPainter);
            tGPainter.initPath(2);
            tGPainter.moveTo(f2 + 2.0f * f, f3 + 1.0f * f);
            for (n4 = 0; n4 < n3; ++n4) {
                f2 = (float)(n + point.x) + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
                tGPainter.cubicTo(f2 + 2.0f * f, f3 + 1.0f * f, f2 + 3.0f * f, f3, f2 + 4.0f * f, f3 + 1.0f * f);
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 3.0f * f);
            }
            tGPainter.lineTo(f2 + 7.0f * f, f3 + 2.0f * f);
            tGPainter.cubicTo(f2 + 7.0f * f, f3 + 2.0f * f, f2 + 8.0f * f, f3 + 2.0f * f, f2 + 7.0f * f, f3 + 3.0f * f);
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                f2 = (float)(n + point.x) + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 4.0f * f);
                tGPainter.cubicTo(f2 + 6.0f * f, f3 + 4.0f * f, f2 + 5.0f * f, f3 + 5.0f * f, f2 + 4.0f * f, f3 + 4.0f * f);
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 2.0f * f);
                tGPainter.lineTo(f2 + 1.0f * f, f3 + 3.0f * f);
            }
            tGPainter.cubicTo(f2 + 1.0f * f, f3 + 3.0f * f, f2, f3 + 3.0f * f, f2 + 1.0f * f, f3 + 2.0f * f);
            tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
            tGPainter.closePath();
        }
    }

    private void paintFadeIn(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 4.0f * f;
        float f4 = this.getVoiceImpl().getWidth();
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.cubicTo(f2, f3, f2 + f4, f3, f2 + f4, f3 - 4.0f * f);
        tGPainter.moveTo(f2, f3);
        tGPainter.cubicTo(f2, f3, f2 + f4, f3, f2 + f4, f3 + 4.0f * f);
        tGPainter.closePath();
    }

    private void paintAccentuated(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 2.0f * f;
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.lineTo(f2 + 6.0f * f, f3 + 2.5f * f);
        tGPainter.lineTo(f2, f3 + 5.0f * f);
        tGPainter.closePath();
    }

    private void paintHeavyAccentuated(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = n2;
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3 + 5.0f * f);
        tGPainter.lineTo(f2 + 3.0f * f, f3 + 1.0f * f);
        tGPainter.lineTo(f2 + 6.0f * f, f3 + 5.0f * f);
        tGPainter.closePath();
    }

    public int getRealValue() {
        return this.getValue() + this.getMeasureImpl().getTrack().getString(this.getString()).getValue();
    }

    public int getScorePosY() {
        return this.scorePosY;
    }

    public int getTabPosY() {
        return this.tabPosY;
    }

    public TGMeasureImpl getMeasureImpl() {
        return this.getBeatImpl().getMeasureImpl();
    }

    public int getPaintPosition(int n) {
        return this.getMeasureImpl().getTs().getPosition(n);
    }

    public TGBeatImpl getBeatImpl() {
        return this.getVoiceImpl().getBeatImpl();
    }

    public TGVoiceImpl getVoiceImpl() {
        return (TGVoiceImpl)super.getVoice();
    }

    public int getPosX() {
        return this.getBeatImpl().getPosX();
    }
}

