/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.TGLyric;

public class TGLyricImpl
extends TGLyric {
    private int height = 0;
    private int nextIndex = 0;

    public void setFrom(int n) {
        super.setFrom(n);
        this.update();
    }

    public void setLyrics(String string) {
        super.setLyrics(string);
        this.update();
    }

    private void update() {
        this.height = this.isEmpty() ? 0 : 10;
    }

    public void start() {
        this.start(0);
    }

    public void start(int n) {
        this.nextIndex = n;
    }

    public void setCurrentMeasure(TGMeasureImpl tGMeasureImpl) {
        if (tGMeasureImpl.getNumber() >= this.getFrom()) {
            tGMeasureImpl.setLyricBeatIndex(this.nextIndex);
            this.nextIndex += tGMeasureImpl.getNotEmptyBeats();
        } else {
            tGMeasureImpl.setLyricBeatIndex(-1);
            this.start();
        }
    }

    public void paintCurrentNoteBeats(TGPainter tGPainter, ViewLayout viewLayout, TGMeasureImpl tGMeasureImpl, int n, int n2) {
        int n3 = tGMeasureImpl.getLyricBeatIndex();
        String[] stringArray = this.getLyricBeats();
        if (stringArray != null && n3 >= 0 && n3 < stringArray.length) {
            int n4 = 0;
            for (int i = 0; i < tGMeasureImpl.countBeats(); ++i) {
                String string;
                TGBeatImpl tGBeatImpl = (TGBeatImpl)tGMeasureImpl.getBeat(i);
                if (tGBeatImpl.isRestBeat()) continue;
                if (n3 + n4 < stringArray.length && (string = stringArray[n3 + n4].trim()).length() > 0) {
                    int n5 = n + tGBeatImpl.getPosX() + tGBeatImpl.getSpacing() + 2;
                    viewLayout.setLyricStyle(tGPainter, viewLayout.isPlayModeEnabled() && tGBeatImpl.isPlaying(viewLayout));
                    tGPainter.drawString(string, n5 + 13, n2 + tGMeasureImpl.getTs().getPosition(14));
                }
                ++n4;
            }
        }
    }

    public int getHeight() {
        return this.height;
    }
}

