/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordCreatorListener;
import org.herac.tuxguitar.gui.editors.chord.ChordDatabase;
import org.herac.tuxguitar.gui.editors.chord.ChordNamingConvention;
import org.herac.tuxguitar.gui.editors.chord.ChordSettings;
import org.herac.tuxguitar.song.models.TGChord;

public class ChordCreatorUtil {
    public static final int MAX_STRINGS = 7;
    public static final int MAX_FRET_SPAN = 5;
    private final int BASS_INDEX = -1;
    private final int ESSENTIAL_INDEX = -2;
    private final int NOT_ESSENTIAL_INDEX = -3;
    private static long runningProcess;
    private long processId;
    private ChordCreatorListener listener;
    private int alteration;
    private int chordIndex;
    private int[] requiredNotes;
    private int[] expandingNotes;
    private int add5 = 0;
    private String chordName = null;
    private int bassTonic;
    private int chordTonic;
    private int[] tuning;

    private ChordCreatorUtil(long l, ChordCreatorListener chordCreatorListener) {
        this.processId = l;
        this.listener = chordCreatorListener;
    }

    public boolean isValidProcess() {
        return this.processId == runningProcess;
    }

    public static long getNewProcess() {
        return ++runningProcess;
    }

    public static void getChords(ChordCreatorListener chordCreatorListener, final int[] nArray, final int n, final int n2, final int n3, final boolean bl, final int n4, final int n5, final int n6, final int n7, final int n8, final boolean bl2) {
        final ChordCreatorUtil chordCreatorUtil = new ChordCreatorUtil(ChordCreatorUtil.getNewProcess(), chordCreatorListener);
        new Thread(new Runnable(){

            public void run() {
                chordCreatorUtil.getChords(nArray, n, n2, n3, bl, n4, n5, n6, n7, n8, bl2);
            }
        }).start();
    }

    protected void getChords(int[] nArray, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        List list;
        int n9;
        if (!this.isValidProcess()) {
            return;
        }
        this.add5 = n4;
        this.tuning = nArray;
        this.chordIndex = n;
        this.chordTonic = n8;
        this.bassTonic = n7;
        this.alteration = n2;
        this.chordName = new ChordNamingConvention().createChordName(this.chordTonic, this.chordIndex, this.alteration, n3, bl, n4, n5, n6, this.bassTonic, bl2);
        if (this.alteration != 0) {
            if (bl) {
                this.expandingNotes = new int[1];
                this.expandingNotes[0] = this.getAddNote(this.alteration - 1, n3);
            } else {
                this.expandingNotes = new int[1 + this.alteration];
                this.expandingNotes[0] = 11;
                this.expandingNotes[1] = this.getAddNote(this.alteration - 1, n3);
                for (n9 = 2; n9 <= this.alteration; ++n9) {
                    this.expandingNotes[n9] = this.getAddNote(n9 - 2, n9 == 2 ? n5 : n6);
                }
            }
        } else {
            this.expandingNotes = new int[0];
        }
        this.requiredNotes = ChordDatabase.get(n).cloneRequireds();
        if (n4 != 0) {
            for (n9 = 0; n9 < this.requiredNotes.length; ++n9) {
                if (this.requiredNotes[n9] != 8) continue;
                int n10 = n9;
                this.requiredNotes[n10] = this.requiredNotes[n10] + (n4 == 1 ? 1 : -1);
            }
        }
        n9 = 0;
        for (int i = 0; i < this.requiredNotes.length; ++i) {
            this.requiredNotes[i] = this.checkForOverlapping(this.requiredNotes[i]);
            if (this.requiredNotes[i] == -1) continue;
            ++n9;
        }
        int[] nArray2 = new int[n9];
        n9 = 0;
        for (int i = 0; i < this.requiredNotes.length; ++i) {
            if (this.requiredNotes[i] == -1) continue;
            nArray2[n9] = this.requiredNotes[i];
            ++n9;
        }
        this.requiredNotes = nArray2;
        if (this.isValidProcess() && (list = this.getChords()) != null && this.isValidProcess()) {
            this.listener.notifyChords(this, list);
        }
    }

    protected int checkForOverlapping(int n) {
        for (int i = 0; i < this.expandingNotes.length; ++i) {
            if (this.expandingNotes[i] != n) continue;
            return -1;
        }
        return n;
    }

    private List getChords() {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList arrayList = this.makePotentialNotes();
        ArrayList arrayList2 = this.makeCombinations(arrayList);
        ArrayList arrayList3 = this.determinePriority(arrayList2);
        ArrayList arrayList4 = this.takeBest(arrayList3);
        return this.createChords(arrayList4);
    }

    private ArrayList createChords(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<TGChord> arrayList2 = new ArrayList<TGChord>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TGChord tGChord = TuxGuitar.instance().getSongManager().getFactory().newChord(this.tuning.length);
            Iterator iterator2 = ((ArrayList)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                StringValue stringValue = (StringValue)iterator2.next();
                int n = tGChord.getStrings().length - 1 - stringValue.getString();
                int n2 = stringValue.getFret();
                tGChord.addFretValue(n, n2);
                tGChord.setName(this.chordName);
            }
            arrayList2.add(tGChord);
        }
        return arrayList2;
    }

    private void find(int n, int n2, int n3, List list) {
        int n4;
        if (!this.isValidProcess()) {
            return;
        }
        boolean bl = false;
        for (n4 = 0; n4 < this.requiredNotes.length; ++n4) {
            if ((n + n3) % 12 != (this.chordTonic + this.requiredNotes[n4] - 1) % 12) continue;
            if (!bl && (n + n3) % 12 == this.bassTonic) {
                bl = true;
            }
            list.add(new StringValue(n2, n3, n4));
            return;
        }
        if (this.expandingNotes.length != 0) {
            for (n4 = 0; n4 < this.expandingNotes.length; ++n4) {
                if ((n + n3) % 12 != (this.chordTonic + this.expandingNotes[n4] - 1) % 12) continue;
                if (!bl && (n + n3) % 12 == this.bassTonic) {
                    bl = true;
                }
                list.add(new StringValue(n2, n3, n4 < 2 ? this.ESSENTIAL_INDEX : this.NOT_ESSENTIAL_INDEX));
            }
        }
        if (!bl && (n + n3) % 12 == this.bassTonic) {
            list.add(new StringValue(n2, n3, this.BASS_INDEX));
            return;
        }
    }

    private int getAddNote(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 6;
                break;
            }
            case 2: {
                n3 = 10;
            }
        }
        switch (n2) {
            case 1: {
                ++n3;
                break;
            }
            case 2: {
                --n3;
                break;
            }
        }
        return n3;
    }

    private ArrayList makePotentialNotes() {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.tuning.length);
        for (int i = 0; i < this.tuning.length; ++i) {
            ArrayList arrayList2 = new ArrayList(10);
            if (ChordSettings.instance().getFindChordsMin() > 0 && ChordSettings.instance().isEmptyStringChords()) {
                this.find(this.tuning[i], i, 0, arrayList2);
            }
            for (int j = ChordSettings.instance().getFindChordsMin(); j <= ChordSettings.instance().getFindChordsMax(); ++j) {
                this.find(this.tuning[i], i, j, arrayList2);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private ArrayList makeCombinations(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList arrayList2 = new ArrayList(60);
        ArrayList arrayList3 = null;
        for (int i = 0; i < this.tuning.length - 1; ++i) {
            arrayList3 = this.makeStringCombination(arrayList3);
            arrayList2.addAll(arrayList3);
        }
        ArrayList arrayList4 = new ArrayList(800);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList5 = (ArrayList)iterator.next();
            arrayList3 = null;
            for (int i = 0; i < arrayList5.size(); ++i) {
                int n = (Integer)arrayList5.get(i);
                arrayList3 = this.makeStringValueCombination(arrayList3, (ArrayList)arrayList.get(n));
            }
            if (arrayList3 == null) continue;
            arrayList4.addAll(arrayList3);
        }
        return arrayList4;
    }

    private ArrayList makeStringCombination(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            for (int i = 0; i < this.tuning.length; ++i) {
                arrayList2.add(new ArrayList());
                ((ArrayList)arrayList2.get(i)).add(new Integer(i));
            }
        }
        ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
        for (int i = 1; i < this.tuning.length; ++i) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList4 = (ArrayList)iterator.next();
                Integer n = new Integer(i);
                if ((Integer)arrayList4.get(arrayList4.size() - 1) >= i || arrayList4.contains(n)) continue;
                ArrayList arrayList5 = (ArrayList)arrayList4.clone();
                arrayList5.add(n);
                arrayList3.add(arrayList5);
            }
        }
        return arrayList3;
    }

    private ArrayList makeStringValueCombination(ArrayList arrayList, ArrayList arrayList2) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<ArrayList> arrayList3 = null;
        if (arrayList == null) {
            arrayList3 = new ArrayList(arrayList2.size());
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList3.add(new ArrayList(6));
                ((ArrayList)arrayList3.get(i)).add(arrayList2.get(i));
            }
        } else {
            arrayList3 = new ArrayList<ArrayList>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    ArrayList arrayList4 = (ArrayList)((ArrayList)arrayList.get(j)).clone();
                    arrayList4.add(arrayList2.get(i));
                    if (!this.checkCombination(arrayList4)) continue;
                    arrayList3.add(arrayList4);
                }
            }
        }
        return arrayList3;
    }

    private boolean checkCombination(ArrayList arrayList) {
        int n;
        Iterator iterator = arrayList.iterator();
        int n2 = n = ((StringValue)arrayList.get(0)).getFret();
        while (iterator.hasNext()) {
            int n3 = ((StringValue)iterator.next()).getFret();
            if (n3 == 0 && ChordSettings.instance().isEmptyStringChords()) continue;
            if (n3 < n2) {
                n2 = n3;
            }
            if (n3 <= n) continue;
            n = n3;
        }
        return Math.abs(n2 - n) < 5;
    }

    private ArrayList determinePriority(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<PriorityItem> arrayList2 = new ArrayList<PriorityItem>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && this.isValidProcess()) {
            float f = 0.0f;
            ArrayList arrayList3 = (ArrayList)iterator.next();
            f += this.combinationHasAllRequiredNotes(arrayList3);
            f += this.combinationChordSemantics(arrayList3);
            f += this.combinationHasSubsequentStrings(arrayList3);
            f = (float)((double)(f += this.combinationBassInBass(arrayList3)) + (double)(ChordSettings.instance().getManyStringsGrade() / 3.0f) * ((double)arrayList3.size() - (double)this.tuning.length / (ChordSettings.instance().getManyStringsGrade() > 0.0f ? 2.0 : 1.2)));
            PriorityItem priorityItem = new PriorityItem();
            priorityItem.priority = f += this.combinationHasGoodFingering(arrayList3);
            priorityItem.stringValues = arrayList3;
            arrayList2.add(priorityItem);
        }
        return arrayList2;
    }

    private ArrayList takeBest(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return null;
        }
        int n = ChordSettings.instance().getChordsToDisplay();
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>(n);
        Collections.sort(arrayList, new PriorityComparator());
        for (int i = 0; i < arrayList.size() && this.isValidProcess(); ++i) {
            PriorityItem priorityItem = (PriorityItem)arrayList.get(i);
            if (this.checkIfSubset(priorityItem.stringValues, arrayList2)) continue;
            arrayList2.add(priorityItem.stringValues);
            if (arrayList2.size() >= n) break;
        }
        return arrayList2;
    }

    private float combinationHasAllRequiredNotes(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        Iterator iterator = arrayList.iterator();
        int[] nArray = new int[this.requiredNotes.length];
        int n = 0;
        while (iterator.hasNext()) {
            StringValue stringValue = (StringValue)iterator.next();
            if (stringValue.getRequiredNoteIndex() < 0) continue;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] != stringValue.getRequiredNoteIndex() + 1) continue;
                bl = false;
            }
            if (!bl) continue;
            nArray[n] = stringValue.getRequiredNoteIndex() + 1;
            ++n;
        }
        if (n == this.requiredNotes.length) {
            return ChordSettings.instance().getRequiredBasicsGrade();
        }
        if (n == this.requiredNotes.length - 1) {
            boolean bl = false;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                StringValue stringValue = (StringValue)iterator2.next();
                if ((this.tuning[stringValue.getString()] + stringValue.getFret()) % 12 != (this.chordTonic + 7) % 12) continue;
                bl = true;
            }
            if (!bl && n == this.requiredNotes.length - 1 && ChordDatabase.get(this.chordIndex).getName().indexOf("sus") >= 0 && this.requiredNotes.length != 2 && this.add5 == 0) {
                return ChordSettings.instance().getRequiredBasicsGrade() * 4.0f / 5.0f;
            }
        }
        int n2 = (this.alteration == 0 ? 0 : 1 + this.alteration) + n + (this.bassTonic == this.chordTonic ? 0 : 1);
        return -ChordSettings.instance().getRequiredBasicsGrade() * (float)(this.tuning.length - n2) / (float)this.tuning.length * 2.0f;
    }

    private float combinationHasSubsequentStrings(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.tuning.length; ++i) {
            boolean bl4 = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (((StringValue)iterator.next()).getString() != i) continue;
                bl4 = true;
            }
            if (bl4) {
                if (!bl) {
                    bl = true;
                }
                if (bl2) {
                    bl3 = true;
                }
                if (!bl3) continue;
                return -ChordSettings.instance().getSubsequentGrade();
            }
            if (!bl) continue;
            bl2 = true;
        }
        if (bl3) {
            return 0.0f;
        }
        return ChordSettings.instance().getSubsequentGrade();
    }

    private float combinationBassInBass(ArrayList arrayList) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        for (int i = 0; i < this.tuning.length; ++i) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                StringValue stringValue = (StringValue)iterator.next();
                if (stringValue.getString() != i) continue;
                if ((this.tuning[stringValue.getString()] + stringValue.getFret()) % 12 == this.bassTonic) {
                    return ChordSettings.instance().getBassGrade();
                }
                return -ChordSettings.instance().getBassGrade();
            }
        }
        return 0.0f;
    }

    private float combinationHasGoodFingering(ArrayList arrayList) {
        int n;
        float f;
        int n2;
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        float f2 = 0.0f;
        int[] nArray = new int[this.tuning.length];
        for (int i = 0; i < this.tuning.length; ++i) {
            nArray[i] = -1;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            StringValue stringValue = (StringValue)iterator.next();
            nArray[stringValue.getString()] = stringValue.getFret();
        }
        int n3 = ChordSettings.instance().getFindChordsMax() + 2;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < this.tuning.length; ++n2) {
            bl |= ChordSettings.instance().isEmptyStringChords() && nArray[n2] == 0;
            bl2 |= nArray[n2] == 0;
            if (nArray[n2] < n3 && nArray[n2] != 0 && nArray[n2] != -1) {
                n3 = nArray[n2];
            }
            if (nArray[n2] > n4) {
                n4 = nArray[n2];
                n5 = 1;
                continue;
            }
            if (nArray[n2] != n4) continue;
            ++n5;
        }
        n2 = 0;
        for (int i = 0; i < this.tuning.length; ++i) {
            if (nArray[i] != n3) continue;
            ++n2;
        }
        if (!bl) {
            if (bl2) {
                f2 += ChordSettings.instance().getFingeringGrade() / 8.0f;
            } else if (n2 >= 2) {
                f2 += ChordSettings.instance().getFingeringGrade() / 8.0f;
            }
        } else if (bl) {
            f2 += ChordSettings.instance().getFingeringGrade() / 8.0f;
        }
        switch (Math.abs(n4 - n3)) {
            case 0: {
                f = ChordSettings.instance().getFingeringGrade() / 5.0f;
                break;
            }
            case 1: {
                f = ChordSettings.instance().getFingeringGrade() / (float)(5 + n5);
                break;
            }
            case 2: {
                f = ChordSettings.instance().getFingeringGrade() / (float)(6 + n5);
                if (n3 >= 5) break;
                f = (float)((double)f * 0.9);
                break;
            }
            case 3: {
                f = -ChordSettings.instance().getFingeringGrade() / 10.0f * (float)n5;
                if (n3 >= 5) break;
                f = (float)((double)f * 1.3);
                break;
            }
            case 4: {
                f = -ChordSettings.instance().getFingeringGrade() / 4.0f * (float)n5;
                if (n3 > 5) break;
                f = (float)((double)f * 1.8);
                break;
            }
            default: {
                f = -ChordSettings.instance().getFingeringGrade() * (float)n5;
            }
        }
        f2 += f;
        ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(2), new ArrayList(2), new ArrayList(2), new ArrayList(2)};
        int n6 = 0;
        if (bl2) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != 0) continue;
                n6 = n;
            }
        }
        arrayListArray[0].add(new Integer(n3));
        for (n = n6; n < nArray.length; ++n) {
            if (nArray[n] != n3) continue;
            arrayListArray[0].add(new Integer(n));
            nArray[n] = -1;
        }
        n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 || nArray[i] == -1) continue;
            if (n < 4) {
                arrayListArray[n].add(new Integer(nArray[i]));
                arrayListArray[n].add(new Integer(i));
                nArray[i] = -1;
            }
            ++n;
        }
        f2 = n > 4 ? (f2 -= ChordSettings.instance().getFingeringGrade()) : (float)((double)f2 + (double)ChordSettings.instance().getFingeringGrade() * 0.1 * (double)(15 - 2 * n));
        return f2;
    }

    private float combinationChordSemantics(ArrayList arrayList) {
        int n;
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        float f = 0.0f;
        int n2 = -1;
        int[] nArray = new int[this.expandingNotes.length];
        int n3 = 0;
        for (n = 0; n < this.tuning.length; ++n) {
            Iterator iterator = arrayList.iterator();
            StringValue stringValue = null;
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                StringValue stringValue2 = (StringValue)iterator.next();
                if (stringValue2.getString() != n || bl || stringValue2.getFret() == -1) continue;
                stringValue = stringValue2;
                bl = true;
                ++n3;
            }
            if (stringValue == null) continue;
            if (n2 == -1 && stringValue.getRequiredNoteIndex() == 0) {
                n2 = this.tuning[stringValue.getString()] + stringValue.getFret();
            }
            if (n3 <= true) continue;
            if (stringValue.getRequiredNoteIndex() == this.BASS_INDEX) {
                f -= ChordSettings.instance().getGoodChordSemanticsGrade();
            }
            if (stringValue.getRequiredNoteIndex() >= 0) continue;
            if (n2 == -1) {
                f -= ChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            } else if (n2 + 11 > this.tuning[stringValue.getString()] + stringValue.getFret()) {
                f -= ChordSettings.instance().getGoodChordSemanticsGrade() / 3.0f;
            }
            for (int i = 0; i < this.expandingNotes.length; ++i) {
                if ((this.tuning[n] + stringValue.getFret()) % 12 != (this.chordTonic + this.expandingNotes[i] - 1) % 12 || nArray[i] != 0) continue;
                nArray[i] = stringValue.getRequiredNoteIndex();
            }
        }
        if (this.alteration != 0) {
            n = 0;
            int n4 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.ESSENTIAL_INDEX) {
                    ++n;
                    continue;
                }
                if (nArray[i] == 0) continue;
                ++n4;
            }
            if (n + n4 == this.expandingNotes.length) {
                f += ChordSettings.instance().getGoodChordSemanticsGrade();
            } else if (n == 2) {
                f += ChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            } else {
                f += (float)(n + n4 - this.expandingNotes.length) * ChordSettings.instance().getGoodChordSemanticsGrade();
                f += (float)n4 * ChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            }
        }
        return f;
    }

    private boolean checkIfSubset(List list, List list2) {
        if (!this.isValidProcess()) {
            return false;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            List list3 = (List)iterator.next();
            boolean bl = false;
            for (int i = 0; i < list3.size(); ++i) {
                int n = ((StringValue)list3.get(i)).getString();
                for (int j = 0; j < list.size(); ++j) {
                    if (((StringValue)list.get(j)).getString() != n || ((StringValue)list.get(j)).getFret() == ((StringValue)list3.get(i)).getFret()) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    protected class PriorityComparator
    implements Comparator {
        protected PriorityComparator() {
        }

        public int compare(Object object, Object object2) {
            return Math.round(((PriorityItem)object2).priority - ((PriorityItem)object).priority);
        }
    }

    protected class PriorityItem {
        ArrayList stringValues;
        float priority;

        protected PriorityItem() {
        }
    }

    private class StringValue {
        protected int string;
        protected int fret;
        protected int requiredNoteIndex;

        public StringValue(int n, int n2, int n3) {
            this.string = n;
            this.fret = n2;
            this.requiredNoteIndex = n3;
        }

        public int getString() {
            return this.string;
        }

        public int getFret() {
            return this.fret;
        }

        public int getRequiredNoteIndex() {
            return this.requiredNoteIndex;
        }
    }
}

