/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.tools;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TransposeAction
extends Action {
    public static final String NAME = "action.tools.transpose";

    public TransposeAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        final int[] nArray = new int[25];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i - nArray.length / 2;
        }
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("tools.transpose"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("tools.transpose"));
        Label label = new Label((Composite)group, 0);
        label.setText(TuxGuitar.getProperty("tools.transpose.semitones"));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < nArray.length; ++i) {
            combo.add(Integer.toString(nArray[i]));
        }
        combo.select(nArray.length / 2);
        Group group2 = new Group((Composite)shell2, 16);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(TuxGuitar.getProperty("options"));
        final Button button = new Button((Composite)group2, 16);
        button.setText(TuxGuitar.getProperty("tools.transpose.apply-to-track"));
        button.setSelection(true);
        Button button2 = new Button((Composite)group2, 16);
        button2.setText(TuxGuitar.getProperty("tools.transpose.apply-to-measure"));
        final Button button3 = new Button((Composite)group2, 32);
        button3.setText(TuxGuitar.getProperty("tools.transpose.apply-to-all-tracks"));
        button3.setSelection(true);
        final Button button4 = new Button((Composite)group2, 32);
        button4.setText(TuxGuitar.getProperty("tools.transpose.apply-to-chords"));
        button4.setSelection(true);
        final Button button5 = new Button((Composite)group2, 32);
        button5.setText(TuxGuitar.getProperty("tools.transpose.try-keep-strings"));
        button5.setSelection(true);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button6 = new Button(composite, 8);
        button6.setText(TuxGuitar.getProperty("ok"));
        button6.setLayoutData((Object)this.getButtonData());
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                if (n >= 0 && n < nArray.length) {
                    final int n2 = nArray[n];
                    final boolean bl = button5.getSelection();
                    final boolean bl2 = button4.getSelection();
                    final boolean bl3 = button3.getSelection();
                    final boolean bl4 = button.getSelection();
                    shell2.dispose();
                    try {
                        TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                            public void run() throws Throwable {
                                ActionLock.lock();
                                TuxGuitar.instance().loadCursor(1);
                                TransposeAction.this.transpose(n2, bl, bl2, bl4, bl3);
                                TuxGuitar.instance().updateCache(true);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                } else {
                    shell2.dispose();
                }
            }
        });
        Button button7 = new Button(composite, 8);
        button7.setText(TuxGuitar.getProperty("cancel"));
        button7.setLayoutData((Object)this.getButtonData());
        button7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button6);
        DialogUtils.openDialog(shell2, 11);
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    public void transpose(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        UndoableJoined undoableJoined = new UndoableJoined();
        Caret caret = this.getEditor().getTablature().getCaret();
        if (bl3) {
            if (bl4) {
                TGSong tGSong = this.getSongManager().getSong();
                for (int i = 0; i < tGSong.countTracks(); ++i) {
                    this.transposeTrack(undoableJoined, tGSong.getTrack(i), n, bl, bl2);
                }
            } else {
                this.transposeTrack(undoableJoined, caret.getTrack(), n, bl, bl2);
            }
            this.updateTablature();
        } else {
            if (bl4) {
                TGSong tGSong = this.getSongManager().getSong();
                for (int i = 0; i < tGSong.countTracks(); ++i) {
                    TGTrack tGTrack = tGSong.getTrack(i);
                    TGMeasure tGMeasure = this.getSongManager().getTrackManager().getMeasure(tGTrack, caret.getMeasure().getNumber());
                    if (tGMeasure == null) continue;
                    this.transposeMeasure(undoableJoined, tGMeasure, n, bl, bl2);
                }
            } else {
                this.transposeMeasure(undoableJoined, caret.getMeasure(), n, bl, bl2);
            }
            this.fireUpdate(caret.getMeasure().getNumber());
        }
        if (!undoableJoined.isEmpty()) {
            this.addUndoableEdit(undoableJoined.endUndo());
        }
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
    }

    public void transposeMeasure(UndoableJoined undoableJoined, TGMeasure tGMeasure, int n, boolean bl, boolean bl2) {
        if (n != 0 && !tGMeasure.getTrack().isPercussionTrack()) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo(tGMeasure);
            this.getSongManager().getMeasureManager().transposeNotes(tGMeasure, n, bl, bl2, -1);
            undoableJoined.addUndoableEdit(undoableMeasureGeneric.endUndo(tGMeasure));
        }
    }

    public void transposeTrack(UndoableJoined undoableJoined, TGTrack tGTrack, int n, boolean bl, boolean bl2) {
        if (n != 0 && !tGTrack.isPercussionTrack()) {
            UndoableTrackGeneric undoableTrackGeneric = UndoableTrackGeneric.startUndo(tGTrack);
            this.getSongManager().getTrackManager().transposeNotes(tGTrack, n, bl, bl2, -1);
            undoableJoined.addUndoableEdit(undoableTrackGeneric.endUndo(tGTrack));
        }
    }
}

