/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.effects.StrokeEditor;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

public class SetStrokeDownAction
extends Action {
    public static final String NAME = "action.beat.general.set-stroke-down";

    public SetStrokeDownAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGBeatImpl tGBeatImpl = this.getEditor().getTablature().getCaret().getSelectedBeat();
        if (tGBeatImpl != null && !tGBeatImpl.isRestBeat()) {
            StrokeEditor strokeEditor = new StrokeEditor();
            strokeEditor.open(tGBeatImpl);
            if (strokeEditor.getStatus() != 3) {
                int n = strokeEditor.getStatus() == 2 ? 0 : -1;
                int n2 = strokeEditor.getValue();
                UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
                if (this.getSongManager().getMeasureManager().setStroke(tGBeatImpl.getMeasure(), tGBeatImpl.getStart(), n2, n)) {
                    this.addUndoableEdit(undoableMeasureGeneric.endUndo());
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                }
                this.updateTablature();
            }
        }
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

