/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;
import org.herac.tuxguitar.song.models.TGMeasure;

public class GoNextMeasureAction
extends Action {
    public static final String NAME = "action.measure.go-next";

    public GoNextMeasureAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (this.getSongManager().getTrackManager().isLastMeasure(caret.getMeasure())) {
            int n = this.getSongManager().getSong().countMeasureHeaders() + 1;
            UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n);
            this.getSongManager().addNewMeasure(n);
            this.fireUpdate(n);
            this.moveToNext();
            this.addUndoableEdit(undoableAddMeasure.endUndo());
        } else {
            this.moveToNext();
        }
        return 0;
    }

    private void moveToNext() {
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getTransport().gotoNext();
        } else {
            Caret caret = this.getEditor().getTablature().getCaret();
            TGTrackImpl tGTrackImpl = caret.getTrack();
            TGMeasure tGMeasure = this.getSongManager().getTrackManager().getNextMeasure(caret.getMeasure());
            if (tGTrackImpl != null && tGMeasure != null) {
                caret.update(tGTrackImpl.getNumber(), tGMeasure.getStart(), caret.getSelectedString().getNumber());
            }
        }
    }
}

