/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.Iterator;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGVoice;

public class InsertChordAction
extends Action {
    public static final String NAME = "action.insert.chord";

    public InsertChordAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        TGTrackImpl tGTrackImpl = caret.getTrack();
        TGMeasureImpl tGMeasureImpl = caret.getMeasure();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        if (tGTrackImpl != null && tGMeasureImpl != null && tGBeatImpl != null) {
            if (typedEvent.widget.getData() instanceof TGChord) {
                TGChord tGChord = ((TGChord)typedEvent.widget.getData()).clone(this.getSongManager().getFactory());
                this.insertChord(tGChord, tGTrackImpl, tGMeasureImpl, tGBeatImpl, caret.getVoice());
            } else {
                ChordDialog chordDialog = new ChordDialog();
                Shell shell = TuxGuitar.instance().getShell();
                int n = chordDialog.open(shell, tGMeasureImpl, tGBeatImpl, caret.getPosition());
                if (n == 1) {
                    this.insertChord(chordDialog.getChord(), tGTrackImpl, tGMeasureImpl, tGBeatImpl, caret.getVoice());
                } else if (n == 2) {
                    this.removeChord(tGMeasureImpl, tGBeatImpl);
                }
            }
        }
        return 0;
    }

    protected void insertChord(TGChord tGChord, TGTrackImpl tGTrackImpl, TGMeasureImpl tGMeasureImpl, TGBeat tGBeat, int n) {
        boolean bl = tGBeat.isRestBeat();
        if (!bl || tGChord.countNotes() > 0) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TGVoice tGVoice = tGBeat.getVoice(n);
            if (bl) {
                Iterator iterator = tGTrackImpl.getStrings().iterator();
                while (iterator.hasNext()) {
                    TGString tGString = (TGString)iterator.next();
                    int n2 = tGChord.getFretValue(tGString.getNumber() - 1);
                    if (n2 < 0) continue;
                    TGNote tGNote = this.getSongManager().getFactory().newNote();
                    tGNote.setValue(n2);
                    tGNote.setVelocity(this.getEditor().getTablature().getCaret().getVelocity());
                    tGNote.setString(tGString.getNumber());
                    TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
                    tGVoice.getDuration().copy(tGDuration);
                    this.getSongManager().getMeasureManager().addNote(tGBeat, tGNote, tGDuration, tGVoice.getIndex());
                }
            }
            this.getSongManager().getMeasureManager().addChord(tGBeat, tGChord);
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.fireUpdate(tGMeasureImpl.getNumber());
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
    }

    protected void removeChord(TGMeasureImpl tGMeasureImpl, TGBeat tGBeat) {
        if (tGBeat.isChordBeat()) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSongManager().getMeasureManager().removeChord(tGMeasureImpl, tGBeat.getStart());
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.fireUpdate(tGMeasureImpl.getNumber());
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
    }
}

