/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.base.TGLocalFileImporter;
import org.herac.tuxguitar.io.base.TGRawImporter;

public class ImportSongAction
extends Action {
    public static final String NAME = "action.file.import";

    public ImportSongAction() {
        super(NAME, 5);
    }

    protected int execute(final TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_CANCEL);
            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
            if (n == ConfirmDialog.STATUS_CANCEL) {
                return 2;
            }
            if (n == ConfirmDialog.STATUS_YES) {
                final String string = FileActionUtils.getFileName();
                if (string == null) {
                    return 2;
                }
                TuxGuitar.instance().loadCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            FileActionUtils.save(string);
                            new SyncThread(new Runnable(){

                                public void run() {
                                    if (!TuxGuitar.isDisposed()) {
                                        TuxGuitar.instance().loadCursor(0);
                                        ImportSongAction.this.processImporter((this).typedEvent.widget.getData());
                                    }
                                }
                            }).start();
                        }
                    }
                }).start();
                return 0;
            }
        }
        this.processImporter(typedEvent.widget.getData());
        return 0;
    }

    protected void processImporter(Object object) {
        if (object instanceof TGLocalFileImporter) {
            this.processLocalFileImporter((TGLocalFileImporter)object);
        } else if (object instanceof TGRawImporter) {
            this.processRawImporter((TGRawImporter)object);
        }
    }

    private void processLocalFileImporter(final TGLocalFileImporter tGLocalFileImporter) {
        final String string = FileChooser.instance().open(TuxGuitar.instance().getShell(), tGLocalFileImporter.getFileFormat());
        if (!this.isValidFile(string) || !tGLocalFileImporter.configure(false)) {
            ActionLock.unlock();
            return;
        }
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    FileActionUtils.importSong(tGLocalFileImporter, string);
                    TuxGuitar.instance().loadCursor(0);
                    ActionLock.unlock();
                }
            }
        }).start();
    }

    private void processRawImporter(final TGRawImporter tGRawImporter) {
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    FileActionUtils.importSong(tGRawImporter);
                    TuxGuitar.instance().loadCursor(0);
                    ActionLock.unlock();
                }
            }
        }).start();
    }

    protected boolean isValidFile(String string) {
        if (string != null) {
            File file = new File(string);
            return file.exists() && file.isFile();
        }
        return false;
    }
}

