/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;

public class LilypondSettingsDialog {
    private static final int STATUS_NONE = 0;
    private static final int STATUS_CANCELLED = 1;
    private static final int STATUS_ACCEPTED = 2;
    protected int status;

    public LilypondSettings open() {
        this.status = 0;
        final LilypondSettings lilypondSettings = LilypondSettings.getDefaults();
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setText(TuxGuitar.getProperty((String)"lilypond.options"));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)this.getColumnLayout());
        Composite composite2 = new Composite((Composite)shell, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)this.getColumnLayout());
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track.tip"));
        final Label label = new Label((Composite)group, 0);
        label.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track") + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)this.getComboData());
        for (int i = 1; i <= TuxGuitar.instance().getSongManager().getSong().countTracks(); ++i) {
            combo.add(TuxGuitar.instance().getSongManager().getTrack(i).getName());
        }
        combo.select(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        combo.setEnabled(lilypondSettings.getTrack() != -1);
        final Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        button.setText(TuxGuitar.getProperty((String)"lilypond.options.select-all-tracks"));
        button.setSelection(lilypondSettings.getTrack() == -1);
        Group group2 = new Group(composite, 16);
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.tip"));
        final int n = TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders();
        Label label2 = new Label((Composite)group2, 0);
        label2.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.from"));
        label2.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Spinner spinner = new Spinner((Composite)group2, 2048);
        spinner.setLayoutData((Object)this.getSpinnerData());
        spinner.setMaximum(n);
        spinner.setMinimum(1);
        spinner.setSelection(1);
        Label label3 = new Label((Composite)group2, 0);
        label3.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.to"));
        label3.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Spinner spinner2 = new Spinner((Composite)group2, 2048);
        spinner2.setLayoutData((Object)this.getSpinnerData());
        spinner2.setMinimum(1);
        spinner2.setMaximum(n);
        spinner2.setSelection(n);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = spinner.getSelection();
                int n2 = spinner2.getSelection();
                if (n < 1) {
                    spinner.setSelection(1);
                } else if (n > n2) {
                    spinner.setSelection(n2);
                }
            }
        });
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n3;
                int n2 = spinner2.getSelection();
                if (n2 < (n3 = spinner.getSelection())) {
                    spinner2.setSelection(n3);
                } else if (n2 > n) {
                    spinner2.setSelection(n);
                }
            }
        });
        Group group3 = new Group(composite2, 16);
        group3.setLayout((Layout)new GridLayout());
        group3.setLayoutData((Object)new GridData(4, 4, true, true));
        group3.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.tip"));
        final Button button2 = new Button((Composite)group3, 32);
        button2.setLayoutData((Object)new GridData(4, 4, true, true));
        button2.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-score"));
        button2.setSelection(lilypondSettings.isScoreEnabled());
        final Button button3 = new Button((Composite)group3, 32);
        button3.setLayoutData((Object)new GridData(4, 4, true, true));
        button3.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-tablature"));
        button3.setSelection(lilypondSettings.isTablatureEnabled());
        final Button button4 = new Button((Composite)group3, 32);
        button4.setLayoutData((Object)new GridData(4, 4, true, true));
        button4.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-groups"));
        button4.setSelection(lilypondSettings.isTrackGroupEnabled());
        button4.setEnabled(lilypondSettings.getTrack() == -1);
        final Button button5 = new Button((Composite)group3, 32);
        button5.setLayoutData((Object)new GridData(4, 4, true, true));
        button5.setSelection(lilypondSettings.isTrackNameEnabled());
        button5.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-names"));
        final Button button6 = new Button((Composite)group3, 32);
        button6.setLayoutData((Object)new GridData(4, 4, true, true));
        button6.setSelection(lilypondSettings.isLyricsEnabled());
        button6.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-lyrics"));
        final Button button7 = new Button((Composite)group3, 32);
        button7.setLayoutData((Object)new GridData(4, 4, true, true));
        button7.setSelection(lilypondSettings.isTextEnabled());
        button7.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-texts"));
        final Button button8 = new Button((Composite)group3, 32);
        button8.setLayoutData((Object)new GridData(4, 4, true, true));
        button8.setSelection(lilypondSettings.isChordDiagramEnabled());
        button8.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-chord-diagrams"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button3.getSelection()) {
                    button2.setSelection(true);
                }
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button2.getSelection()) {
                    button3.setSelection(true);
                }
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                label.setEnabled(!button.getSelection());
                combo.setEnabled(!button.getSelection());
                button4.setEnabled(button.getSelection());
            }
        });
        Composite composite3 = new Composite((Composite)shell, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(131072, 4, true, true, 2, 1));
        Button button9 = new Button(composite3, 8);
        button9.setText(TuxGuitar.getProperty((String)"ok"));
        button9.setLayoutData((Object)this.getButtonData());
        button9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LilypondSettingsDialog.this.status = 2;
                lilypondSettings.setTrack(button.getSelection() ? -1 : combo.getSelectionIndex() + 1);
                lilypondSettings.setTrackGroupEnabled(button.getSelection() ? button4.getSelection() : false);
                lilypondSettings.setTrackNameEnabled(button5.getSelection());
                lilypondSettings.setMeasureFrom(spinner.getSelection());
                lilypondSettings.setMeasureTo(spinner2.getSelection());
                lilypondSettings.setScoreEnabled(button2.getSelection());
                lilypondSettings.setTablatureEnabled(button3.getSelection());
                lilypondSettings.setChordDiagramEnabled(button8.getSelection());
                lilypondSettings.setLyricsEnabled(button6.getSelection());
                lilypondSettings.setTextEnabled(button7.getSelection());
                lilypondSettings.check();
                shell.dispose();
            }
        });
        Button button10 = new Button(composite3, 8);
        button10.setText(TuxGuitar.getProperty((String)"cancel"));
        button10.setLayoutData((Object)this.getButtonData());
        button10.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LilypondSettingsDialog.this.status = 1;
                shell.dispose();
            }
        });
        shell.setDefaultButton(button9);
        DialogUtils.openDialog((Shell)shell, (int)11);
        return this.status == 2 ? lilypondSettings : null;
    }

    private GridLayout getColumnLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private GridData getComboData() {
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.minimumWidth = 120;
        return gridData;
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.minimumWidth = 60;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }
}

