/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;

public class LilypondOutputStream {
    private static final String LILYPOND_VERSION = "2.10.5";
    private static final String[] LILYPOND_SHARP_NOTES = new String[]{"c", "cis", "d", "dis", "e", "f", "fis", "g", "gis", "a", "ais", "b"};
    private static final String[] LILYPOND_FLAT_NOTES = new String[]{"c", "des", "d", "ees", "e", "f", "ges", "g", "aes", "a", "bes", "b"};
    private static final String[] LILYPOND_KEY_SIGNATURES = new String[]{"c", "g", "d", "a", "e", "b", "fis", "cis", "f", "bes", "ees", "aes", "des", "ges", "ces"};
    private static final String INDENT = new String("   ");
    private TGSongManager manager;
    private PrintWriter writer;
    private LilypondSettings settings;
    private LilypondTempData temp;

    public LilypondOutputStream(OutputStream outputStream, LilypondSettings lilypondSettings) {
        this.writer = new PrintWriter(outputStream);
        this.temp = new LilypondTempData();
        this.settings = lilypondSettings;
    }

    public void writeSong(TGSong tGSong) {
        this.manager = new TGSongManager();
        this.manager.setSong(tGSong);
        this.addFunctions();
        this.addVersion();
        this.addPaper(tGSong);
        this.addLayout();
        this.addCommands();
        this.addSongDefinitions(tGSong);
        this.addSong(tGSong);
        this.writer.flush();
        this.writer.close();
    }

    private void addVersion() {
        this.writer.println("\\version \"2.10.5\"");
    }

    private void addFunctions() {
        this.writer.println("#(define (tie::tab-clear-tied-fret-numbers grob)");
        this.writer.println(this.indent(1) + "(let* ((tied-fret-nr (ly:spanner-bound grob RIGHT)))");
        this.writer.println(this.indent(2) + "(ly:grob-set-property! tied-fret-nr 'transparent #t)))");
        this.writer.println();
    }

    private void addCommands() {
        this.writer.println("deadNote = #(define-music-function (parser location note) (ly:music?)");
        this.writer.println(this.indent(1) + "(set! (ly:music-property note 'tweaks)");
        this.writer.println(this.indent(2) + "(acons 'stencil ly:note-head::print");
        this.writer.println(this.indent(3) + "(acons 'glyph-name \"2cross\"");
        this.writer.println(this.indent(4) + "(acons 'style 'special");
        this.writer.println(this.indent(5) + "(ly:music-property note 'tweaks)))))");
        this.writer.println(this.indent(1) + "note)");
        this.writer.println();
        this.writer.println("palmMute = #(define-music-function (parser location note) (ly:music?)");
        this.writer.println(this.indent(1) + "(set! (ly:music-property note 'tweaks)");
        this.writer.println(this.indent(2) + "(acons 'style 'do (ly:music-property note 'tweaks)))");
        this.writer.println(this.indent(1) + "note)");
        this.writer.println();
    }

    private void addPaper(TGSong tGSong) {
        this.writer.println("\\paper {");
        this.writer.println(this.indent(1) + "indent = #" + (this.addTrackTitleOnGroup(tGSong) ? 30 : 0));
        this.writer.println(this.indent(1) + "printallheaders = #" + this.getLilypondBoolean(true));
        this.writer.println(this.indent(1) + "print-all-headers = #" + this.getLilypondBoolean(true));
        this.writer.println(this.indent(1) + "ragged-right = #" + this.getLilypondBoolean(false));
        this.writer.println(this.indent(1) + "ragged-bottom = #" + this.getLilypondBoolean(true));
        this.writer.println("}");
    }

    private void addHeader(TGSong tGSong, String string, int n) {
        this.writer.println(this.indent(n) + "\\header {");
        this.writer.println(this.indent(n + 1) + "title = \"" + tGSong.getName() + "\" ");
        this.writer.println(this.indent(n + 1) + "composer = \"" + tGSong.getAuthor() + "\" ");
        if (this.settings.isTrackNameEnabled() && !this.addTrackTitleOnGroup(tGSong) && string != null) {
            this.writer.println(this.indent(n + 1) + "instrument = \"" + string + "\" ");
        }
        this.writer.println(this.indent(n) + "}");
    }

    private void addLayout() {
        this.writer.println("\\layout {");
        this.writer.println(this.indent(1) + "\\context { \\Score");
        this.writer.println(this.indent(2) + "\\override MetronomeMark #'padding = #'5");
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\Staff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override StringNumber #'transparent = #" + this.getLilypondBoolean(true));
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\TabStaff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override Stem #'transparent = #" + this.getLilypondBoolean(this.settings.isScoreEnabled()));
        this.writer.println(this.indent(2) + "\\override Beam #'transparent = #" + this.getLilypondBoolean(this.settings.isScoreEnabled()));
        this.writer.println(this.indent(2) + "\\override Tie  #'after-line-breaking = #tie::tab-clear-tied-fret-numbers");
        this.writer.println(this.indent(1) + "}");
        if (this.settings.isScoreEnabled()) {
            this.writer.println(this.indent(1) + "\\context { \\TabVoice");
            this.writer.println(this.indent(2) + "\\override Tie #'stencil = ##f");
            this.writer.println(this.indent(1) + "}");
        }
        this.writer.println(this.indent(1) + "\\context { \\StaffGroup");
        this.writer.println(this.indent(2) + "\\consists \"Instrument_name_engraver\"");
        this.writer.println(this.indent(1) + "}");
        this.writer.println("}");
    }

    private void addSongDefinitions(TGSong tGSong) {
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            String string = this.trackID(i, "");
            this.temp.reset();
            this.addMusic(tGTrack, string);
            this.addLyrics(tGTrack, string);
            this.addScoreStaff(tGTrack, string);
            this.addTabStaff(tGTrack, string);
            this.addStaffGroup(tGTrack, string);
        }
    }

    private void addSong(TGSong tGSong) {
        int n = tGSong.countTracks();
        if (this.settings.isTrackGroupEnabled() && n > 1) {
            this.writer.println("\\score {");
            if (this.settings.getTrack() == -1) {
                this.writer.println(this.indent(1) + "<<");
            }
        }
        for (int i = 0; i < n; ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            if (this.settings.getTrack() != -1 && this.settings.getTrack() != tGTrack.getNumber()) continue;
            if (!this.settings.isTrackGroupEnabled() || n == 1) {
                this.writer.println("\\score {");
            }
            this.writer.println(this.indent(1) + "\\" + this.trackID(i, "StaffGroup"));
            if (this.settings.isTrackGroupEnabled() && n != 1) continue;
            this.addHeader(tGSong, tGTrack.getName(), 1);
            this.writer.println("}");
        }
        if (this.settings.isTrackGroupEnabled() && n > 1) {
            if (this.settings.getTrack() == -1) {
                this.writer.println(this.indent(1) + ">>");
            }
            this.addHeader(tGSong, null, 1);
            this.writer.println("}");
        }
    }

    private void addMusic(TGTrack tGTrack, String string) {
        for (int i = 0; i < 2; ++i) {
            this.writer.println(this.trackVoiceID(i, string, "Music") + " = #(define-music-function (parser location inTab) (boolean?)");
            this.writer.println("#{");
            if (this.isVoiceAvailable(tGTrack, i)) {
                TGMeasure tGMeasure = null;
                int n = tGTrack.countMeasures();
                for (int j = 0; j < n; ++j) {
                    TGMeasure tGMeasure2 = tGTrack.getMeasure(j);
                    int n2 = this.settings.getMeasureFrom();
                    int n3 = this.settings.getMeasureTo();
                    if (n2 > tGMeasure2.getNumber() && n2 != -1 || n3 < tGMeasure2.getNumber() && n3 != -1) continue;
                    this.addMeasure(tGMeasure2, tGMeasure, i, 1, j == n - 1);
                    tGMeasure = tGMeasure2;
                }
                this.writer.println(this.indent(1) + "\\bar \"|.\"");
                this.writer.println(this.indent(1) + "\\pageBreak");
            }
            this.writer.println("#})");
        }
    }

    private void addScoreStaff(TGTrack tGTrack, String string) {
        boolean bl = this.settings.isLyricsEnabled() && !this.settings.isTablatureEnabled() && !tGTrack.getLyrics().isEmpty();
        boolean bl2 = this.settings.isChordDiagramEnabled();
        boolean bl3 = this.settings.isTextEnabled();
        this.writer.println(string + "Staff = \\new Staff <<");
        for (int i = 0; i < 2; ++i) {
            String string2 = this.trackVoiceID(i, string, "Music");
            this.writer.println(this.indent(1) + "\\context Voice = \"" + string2 + "\" {");
            if (!bl2) {
                this.writer.println(this.indent(2) + "\\removeWithTag #'chords");
            }
            if (!bl3) {
                this.writer.println(this.indent(2) + "\\removeWithTag #'texts");
            }
            this.writer.println(this.indent(2) + "\\" + string2 + " #" + this.getLilypondBoolean(false));
            this.writer.println(this.indent(1) + "}");
        }
        if (bl) {
            this.writer.println(this.indent(1) + "\\new Lyrics \\lyricsto \"" + this.trackVoiceID(0, string, "Music") + "\" \\" + string + "Lyrics");
        }
        this.writer.println(">>");
    }

    private void addTabStaff(TGTrack tGTrack, String string) {
        boolean bl = this.settings.isLyricsEnabled() && !tGTrack.getLyrics().isEmpty();
        boolean bl2 = this.settings.isChordDiagramEnabled() && !this.settings.isScoreEnabled();
        boolean bl3 = this.settings.isTextEnabled() && !this.settings.isScoreEnabled();
        this.writer.println(string + "TabStaff = \\new TabStaff " + this.getLilypondTuning(tGTrack) + " <<");
        for (int i = 0; i < 2; ++i) {
            String string2 = this.trackVoiceID(i, string, "Music");
            this.writer.println(this.indent(1) + "\\context TabVoice = \"" + string2 + "\" {");
            if (!bl2) {
                this.writer.println(this.indent(2) + "\\removeWithTag #'chords");
            }
            if (!bl3) {
                this.writer.println(this.indent(2) + "\\removeWithTag #'texts");
            }
            this.writer.println(this.indent(2) + "\\" + string2 + " #" + this.getLilypondBoolean(true));
            this.writer.println(this.indent(1) + "}");
        }
        if (bl) {
            this.writer.println(this.indent(1) + "\\new Lyrics \\lyricsto \"" + this.trackVoiceID(0, string, "Music") + "\" \\" + string + "Lyrics");
        }
        this.writer.println(">>");
    }

    private void addLyrics(TGTrack tGTrack, String string) {
        this.writer.println(string + "Lyrics = \\lyricmode {");
        this.writer.println(this.indent(1) + "\\set ignoreMelismata = #" + this.getLilypondBoolean(true));
        int n = this.temp.getSkippedLyricBeats().size();
        if (n > 0) {
            this.writer.print(this.indent(1));
            for (int i = 0; i < n; ++i) {
                this.writer.print("\\skip " + (String)this.temp.getSkippedLyricBeats().get(i) + " ");
            }
            this.writer.println();
        }
        this.writer.println(this.indent(1) + tGTrack.getLyrics().getLyrics());
        this.writer.println(this.indent(1) + "\\unset ignoreMelismata");
        this.writer.println("}");
    }

    private void addStaffGroup(TGTrack tGTrack, String string) {
        this.writer.println(string + "StaffGroup = \\new StaffGroup <<");
        if (this.addTrackTitleOnGroup(tGTrack.getSong())) {
            this.writer.println(this.indent(1) + "\\set StaffGroup.instrumentName = #\"" + tGTrack.getName() + "\"");
        }
        if (this.settings.isScoreEnabled()) {
            this.writer.println(this.indent(1) + "\\" + string + "Staff");
        }
        if (this.settings.isTablatureEnabled()) {
            this.writer.println(this.indent(1) + "\\" + string + "TabStaff");
        }
        this.writer.println(">>");
    }

    private void addMeasure(TGMeasure tGMeasure, TGMeasure tGMeasure2, int n, int n2, boolean bl) {
        if (tGMeasure2 == null || tGMeasure.getTempo().getValue() != tGMeasure2.getTempo().getValue()) {
            this.addTempo(tGMeasure.getTempo(), n2);
        }
        if (tGMeasure2 == null || tGMeasure.getClef() != tGMeasure2.getClef()) {
            this.addClef(tGMeasure.getClef(), n2);
        }
        if (tGMeasure2 == null || tGMeasure.getKeySignature() != tGMeasure2.getKeySignature()) {
            this.addKeySignature(tGMeasure.getKeySignature(), n2);
        }
        if (tGMeasure2 == null || !tGMeasure.getTimeSignature().isEqual(tGMeasure2.getTimeSignature())) {
            this.addTimeSignature(tGMeasure.getTimeSignature(), n2);
        }
        this.addMeasureVoice(tGMeasure, n, tGMeasure2 == null, n2);
        if (tGMeasure.isRepeatOpen()) {
            this.addRepeatOpen(tGMeasure.getHeader(), n2);
        } else if (tGMeasure.getNumber() == 1) {
            this.checkRepeatCount(tGMeasure.getHeader());
            if (this.temp.getRepeatCount() > 0) {
                this.addRepeatOpen(tGMeasure.getHeader(), n2);
            }
        }
        if (!tGMeasure.isRepeatOpen() && tGMeasure.getHeader().getRepeatAlternative() > 0) {
            this.addRepeatAlternativeOpen(n2);
        }
        this.addMeasureComponents(tGMeasure, n, this.temp.isRepeatOpen() || this.temp.isRepeatAlternativeOpen() ? n2 + 1 : n2);
        if (this.temp.isRepeatAlternativeOpen() && this.temp.getRepeatAlternativeNumber() >= this.temp.getRepeatCount()) {
            this.addRepeatClose(n2);
            this.addRepeatAlternativeClose(n2);
        }
        if (tGMeasure.getRepeatClose() > 0) {
            this.addRepeatClose(n2);
        }
        if (bl) {
            this.addRepeatClose(n2);
            this.addRepeatAlternativeClose(n2);
        }
    }

    private void addRepeatOpen(TGMeasureHeader tGMeasureHeader, int n) {
        this.addRepeatClose(n);
        this.addRepeatAlternativeClose(n);
        this.checkRepeatCount(tGMeasureHeader);
        this.writer.println(this.indent(n) + "\\repeat volta " + this.temp.getRepeatCount() + " {");
        this.temp.setRepeatOpen(true);
    }

    private void addRepeatClose(int n) {
        if (this.temp.isRepeatOpen()) {
            this.writer.println(this.indent(n) + "}");
        }
        this.temp.setRepeatOpen(false);
        if (!this.temp.isRepeatAlternativeOpen()) {
            this.temp.setRepeatCount(0);
        }
    }

    private void addRepeatAlternativeOpen(int n) {
        if (this.temp.isRepeatOpen() && !this.temp.isRepeatAlternativeOpen()) {
            this.temp.setRepeatAlternativeOpen(true);
            this.addRepeatClose(n);
            this.writer.println(this.indent(n) + "\\alternative {");
        }
        if (this.temp.isRepeatAlternativeOpen()) {
            if (this.temp.getRepeatAlternativeNumber() > 0) {
                this.writer.println(this.indent(n) + "}");
            }
            this.writer.println(this.indent(n) + "{");
            this.temp.setRepeatAlternativeNumber(this.temp.getRepeatAlternativeNumber() + 1);
        }
    }

    private void addRepeatAlternativeClose(int n) {
        if (this.temp.isRepeatAlternativeOpen()) {
            if (this.temp.getRepeatAlternativeNumber() > 0) {
                this.writer.println(this.indent(n) + "}");
            }
            this.writer.println(this.indent(n) + "}");
        }
        this.temp.setRepeatAlternativeOpen(false);
        this.temp.setRepeatAlternativeNumber(0);
        if (!this.temp.isRepeatOpen()) {
            this.temp.setRepeatCount(0);
        }
    }

    private void addTempo(TGTempo tGTempo, int n) {
        this.writer.println(this.indent(n) + "\\tempo 4=" + tGTempo.getValue());
    }

    private void addTimeSignature(TGTimeSignature tGTimeSignature, int n) {
        this.writer.println(this.indent(n) + "\\time " + tGTimeSignature.getNumerator() + "/" + tGTimeSignature.getDenominator().getValue());
    }

    private void addKeySignature(int n, int n2) {
        if (n >= 0 && n < LILYPOND_KEY_SIGNATURES.length) {
            this.writer.println(this.indent(n2) + "\\key " + LILYPOND_KEY_SIGNATURES[n] + " \\major");
        }
    }

    private void addClef(int n, int n2) {
        String string = "";
        if (n == 1) {
            string = "treble";
        } else if (n == 2) {
            string = "bass";
        } else if (n == 4) {
            string = "alto";
        } else if (n == 3) {
            string = "tenor";
        }
        if (string != "") {
            this.writer.println(this.indent(n2) + "\\clef #(if $inTab \"tab\" \"" + string + "_8\")");
        }
    }

    private void addMeasureVoice(TGMeasure tGMeasure, int n, boolean bl, int n2) {
        boolean bl2 = this.hasMultipleVoices(tGMeasure);
        if (bl || bl2 != this.temp.isMultipleVoices()) {
            this.writer.println(this.indent(n2) + this.getLilypondVoice(bl2 ? n : -1));
        }
        this.temp.setMultipleVoices(bl2);
    }

    private void addMeasureComponents(TGMeasure tGMeasure, int n, int n2) {
        this.writer.print(this.indent(n2));
        this.addComponents(tGMeasure, n);
        this.writer.println();
    }

    private void addComponents(TGMeasure tGMeasure, int n) {
        int n2 = tGMeasure.getKeySignature();
        TGBeat tGBeat = null;
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            TGVoice tGVoice = tGBeat2.getVoice(n);
            if (tGVoice.isEmpty()) continue;
            TGDivisionType tGDivisionType = tGVoice.getDuration().getDivision();
            if (tGBeat != null && this.temp.isDivisionTypeOpen() && !tGDivisionType.isEqual(tGBeat.getVoice(0).getDuration().getDivision())) {
                this.writer.print("} ");
                this.temp.setDivisionTypeOpen(false);
            }
            if (!this.temp.isDivisionTypeOpen() && !tGDivisionType.isEqual(TGDivisionType.NORMAL)) {
                this.writer.print("\\times " + tGDivisionType.getTimes() + "/" + tGDivisionType.getEnters() + " {");
                this.temp.setDivisionTypeOpen(true);
            }
            this.addBeat(n2, tGBeat2, tGVoice);
            tGBeat = tGBeat2;
        }
        if (tGBeat == null) {
            this.writer.print("\\skip ");
            this.addDuration(tGMeasure.getTimeSignature().getDenominator());
            this.writer.print("*" + tGMeasure.getTimeSignature().getNumerator() + " ");
        }
        if (this.temp.isDivisionTypeOpen()) {
            this.writer.print("} ");
            this.temp.setDivisionTypeOpen(false);
        }
    }

    private void addBeat(int n, TGBeat tGBeat, TGVoice tGVoice) {
        TGVoice tGVoice2;
        int n2;
        int n3;
        if (tGVoice.isRestVoice()) {
            n3 = 0;
            for (n2 = 0; n2 < tGBeat.countVoices(); ++n2) {
                if (n3 != 0 || n2 == tGVoice.getIndex() || (tGVoice2 = tGBeat.getVoice(n2)).isEmpty() || !tGVoice2.getDuration().isEqual(tGVoice.getDuration())) continue;
                n3 = !tGVoice2.isRestVoice() || tGVoice2.getIndex() < tGVoice.getIndex() ? 1 : 0;
            }
            this.writer.print(n3 != 0 ? "\\skip " : "r");
            this.addDuration(tGVoice.getDuration());
        } else {
            this.addEffectsBeforeBeat(tGVoice);
            this.writer.print("<");
            n3 = tGVoice.countNotes();
            for (n2 = 0; n2 < n3; ++n2) {
                tGVoice2 = tGVoice.getNote(n2);
                this.addEffectsBeforeNote((TGNote)tGVoice2);
                this.addKey(n, tGBeat.getMeasure().getTrack().getString(tGVoice2.getString()).getValue() + tGVoice2.getValue());
                if (this.isAnyTiedTo((TGNote)tGVoice2)) {
                    this.writer.print("~");
                }
                this.addString(tGVoice2.getString());
                this.addEffectsOnNote(tGVoice2.getEffect());
                if (n3 <= 1) continue;
                this.writer.print(" ");
            }
            this.writer.print(">");
            this.addDuration(tGVoice.getDuration());
            this.addEffectsOnDuration(tGVoice);
            this.addEffectsOnBeat(tGVoice);
        }
        if (tGBeat.isChordBeat() && !tGVoice.isRestVoice()) {
            n3 = 0;
            for (n2 = 0; n2 < tGVoice.getIndex(); ++n2) {
                tGVoice2 = tGBeat.getVoice(n2);
                n3 = n3 != 0 || !tGVoice2.isEmpty() && !tGVoice2.isRestVoice() ? 1 : 0;
            }
            if (n3 == 0) {
                this.writer.print("-\\tag #'chords ^\\markup \\fret-diagram #\"");
                TGChord tGChord = tGBeat.getChord();
                for (int i = 0; i < tGChord.countStrings(); ++i) {
                    this.writer.print(i + 1 + "-" + this.getLilypondChordFret(tGChord.getFretValue(i)) + ";");
                }
                this.writer.print("\"");
            }
        }
        if (tGBeat.isTextBeat()) {
            n3 = 0;
            for (int i = 0; i < tGVoice.getIndex(); ++i) {
                n3 = n3 != 0 || !tGBeat.getVoice(i).isEmpty() ? 1 : 0;
            }
            if (n3 == 0) {
                this.writer.print("-\\tag #'texts ^\\markup {\"" + tGBeat.getText().getValue() + "\"}");
            }
        }
        if (tGVoice.getIndex() == 0 && !tGVoice.isRestVoice() && tGBeat.getMeasure().getTrack().getLyrics().getFrom() > tGBeat.getMeasure().getNumber()) {
            this.temp.addSkippedLyricBeat(this.getLilypondDuration(tGVoice.getDuration()));
        }
        this.writer.print(" ");
    }

    private void addKey(int n, int n2) {
        this.writer.print(this.getLilypondKey(n, n2));
    }

    private void addString(int n) {
        this.writer.print("\\" + n);
    }

    private void addDuration(TGDuration tGDuration) {
        this.writer.print(this.getLilypondDuration(tGDuration));
    }

    private void addEffectsBeforeNote(TGNote tGNote) {
        TGNoteEffect tGNoteEffect = tGNote.getEffect();
        if (tGNoteEffect.isDeadNote()) {
            this.writer.print("\\deadNote ");
        }
        if (tGNoteEffect.isPalmMute()) {
            this.writer.print("\\palmMute ");
        }
        if (tGNoteEffect.isGhostNote()) {
            this.writer.print("\\parenthesize ");
        }
        if (tGNoteEffect.isBend()) {
            this.writer.print("\\bendAfter #+6 ");
        }
    }

    private void addEffectsOnNote(TGNoteEffect tGNoteEffect) {
        if (tGNoteEffect.isHarmonic()) {
            this.writer.print("\\harmonic");
        }
    }

    private void addEffectsOnDuration(TGVoice tGVoice) {
        int n = -1;
        for (int i = 0; i < tGVoice.countNotes(); ++i) {
            TGNote tGNote = tGVoice.getNote(i);
            if (n != -1 || !tGNote.getEffect().isTremoloPicking()) continue;
            n = tGNote.getEffect().getTremoloPicking().getDuration().getValue();
        }
        if (n != -1) {
            this.writer.print(":" + n);
        }
    }

    private void addEffectsOnBeat(TGVoice tGVoice) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = tGVoice.getBeat().getStroke().getDirection() != 0;
        for (int i = 0; i < tGVoice.countNotes(); ++i) {
            TGNoteEffect tGNoteEffect = tGVoice.getNote(i).getEffect();
            bl = bl || tGNoteEffect.isTrill();
            bl2 = bl2 || tGNoteEffect.isVibrato();
            bl3 = bl3 || tGNoteEffect.isStaccato();
            bl4 = bl4 || tGNoteEffect.isAccentuatedNote();
            bl5 = bl5 || tGNoteEffect.isHeavyAccentuatedNote();
        }
        if (bl) {
            this.writer.print("\\trill");
        }
        if (bl2) {
            this.writer.print("\\prall");
        }
        if (bl3) {
            this.writer.print("\\staccato");
        }
        if (bl4) {
            this.writer.print("->");
        }
        if (bl5) {
            this.writer.print("-^");
        }
        if (bl6) {
            this.writer.print("\\arpeggio");
        }
    }

    private void addEffectsBeforeBeat(TGVoice tGVoice) {
        int n;
        ArrayList<TGNote> arrayList = new ArrayList<TGNote>();
        for (n = 0; n < tGVoice.countNotes(); ++n) {
            TGNote tGNote = tGVoice.getNote(n);
            if (!tGNote.getEffect().isGrace()) continue;
            arrayList.add(tGNote);
        }
        if (!arrayList.isEmpty()) {
            this.writer.print("\\grace ");
            this.writer.print("<");
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                TGNote tGNote = (TGNote)arrayList.get(i);
                TGMeasure tGMeasure = tGVoice.getBeat().getMeasure();
                TGString tGString = tGMeasure.getTrack().getString(tGNote.getString());
                TGEffectGrace tGEffectGrace = tGNote.getEffect().getGrace();
                if (n < 64 && tGEffectGrace.getDuration() == 1) {
                    n = 64;
                } else if (n < 32 && tGEffectGrace.getDuration() == 2) {
                    n = 32;
                } else if (n < 16 && tGEffectGrace.getDuration() == 3) {
                    n = 16;
                }
                if (i > 0) {
                    this.writer.print(" ");
                }
                this.addKey(tGMeasure.getKeySignature(), tGString.getValue() + tGEffectGrace.getFret());
                this.addString(tGNote.getString());
            }
            this.writer.print(">");
            this.writer.print(n);
            this.writer.print(" ");
        }
    }

    private void checkRepeatCount(TGMeasureHeader tGMeasureHeader) {
        boolean bl = false;
        TGMeasureHeader tGMeasureHeader2 = tGMeasureHeader;
        while (!(tGMeasureHeader2 == null || tGMeasureHeader2.isRepeatOpen() && tGMeasureHeader2.getNumber() != tGMeasureHeader.getNumber())) {
            if (tGMeasureHeader2.getNumber() > tGMeasureHeader.getNumber() && tGMeasureHeader2.getRepeatAlternative() > 0) {
                bl = true;
                this.temp.setRepeatCount(this.temp.getRepeatCount() + 1);
            } else if (!bl && tGMeasureHeader2.getRepeatClose() > 0) {
                this.temp.setRepeatCount(tGMeasureHeader2.getRepeatClose() + 1);
                break;
            }
            tGMeasureHeader2 = this.manager.getNextMeasureHeader(tGMeasureHeader2);
        }
    }

    private boolean hasMultipleVoices(TGMeasure tGMeasure) {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            if (!this.isVoiceAvailable(tGMeasure, i)) continue;
            ++n;
        }
        return n > 1;
    }

    private boolean isVoiceAvailable(TGMeasure tGMeasure, int n) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            if (tGBeat.getVoice(n).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isVoiceAvailable(TGTrack tGTrack, int n) {
        for (int i = 0; i < tGTrack.countMeasures(); ++i) {
            TGMeasure tGMeasure = tGTrack.getMeasure(i);
            if (!this.isVoiceAvailable(tGMeasure, n)) continue;
            return true;
        }
        return false;
    }

    private boolean addTrackTitleOnGroup(TGSong tGSong) {
        return this.settings.isTrackNameEnabled() && this.settings.isTrackGroupEnabled() && this.settings.getTrack() == -1 && tGSong.countTracks() > 1;
    }

    private boolean isAnyTiedTo(TGNote tGNote) {
        TGMeasure tGMeasure = tGNote.getVoice().getBeat().getMeasure();
        TGBeat tGBeat = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGNote.getVoice().getBeat());
        while (tGMeasure != null) {
            while (tGBeat != null) {
                TGVoice tGVoice = tGBeat.getVoice(0);
                if (tGVoice.isRestVoice()) {
                    return false;
                }
                Iterator iterator = tGVoice.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote2 = (TGNote)iterator.next();
                    if (tGNote2.getString() != tGNote.getString()) continue;
                    return tGNote2.isTiedNote();
                }
                tGBeat = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGBeat);
            }
            tGMeasure = this.manager.getTrackManager().getNextMeasure(tGMeasure);
            if (tGMeasure == null) continue;
            tGBeat = this.manager.getMeasureManager().getFirstBeat(tGMeasure.getBeats());
        }
        return false;
    }

    private String indent(int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + INDENT;
        }
        return string;
    }

    private String getLilypondBoolean(boolean bl) {
        return bl ? "#t" : "#f";
    }

    private String getLilypondKey(int n, int n2) {
        int n3;
        String[] stringArray = n <= 7 ? LILYPOND_SHARP_NOTES : LILYPOND_FLAT_NOTES;
        String string = stringArray[n2 % 12];
        for (n3 = 4; n3 < n2 / 12; ++n3) {
            string = string + "'";
        }
        for (n3 = n2 / 12; n3 < 4; ++n3) {
            string = string + ",";
        }
        return string;
    }

    private String getLilypondDuration(TGDuration tGDuration) {
        String string = Integer.toString(tGDuration.getValue());
        if (tGDuration.isDotted()) {
            string = string + ".";
        } else if (tGDuration.isDoubleDotted()) {
            string = string + "..";
        }
        return string;
    }

    private String getLilypondChordFret(int n) {
        if (n < 0) {
            return "x";
        }
        if (n == 0) {
            return "o";
        }
        return Integer.toString(n);
    }

    private String getLilypondTuning(TGTrack tGTrack) {
        String string = "\\with { stringTunings = #'( ";
        Iterator iterator = tGTrack.getStrings().iterator();
        while (iterator.hasNext()) {
            TGString tGString = (TGString)iterator.next();
            string = string + (tGString.getValue() - 60) + " ";
        }
        string = string + ") }";
        return string;
    }

    private String getLilypondVoice(int n) {
        if (n == -1) {
            return "\\oneVoice";
        }
        return n == 0 ? "\\voiceOne" : "\\voiceTwo";
    }

    private String toBase26(int n) {
        String string = new String();
        int n2 = n;
        while (n2 > 25) {
            string = (char)(n2 % 26 + 65) + string;
            n2 = n2 / 26 - 1;
        }
        return (char)(n2 + 65) + string;
    }

    private String trackID(int n, String string) {
        return "Track" + this.toBase26(n) + string;
    }

    private String trackVoiceID(int n, String string, String string2) {
        return string + "Voice" + this.toBase26(n) + string2;
    }

    protected class LilypondTempData {
        private int repeatCount;
        private int repeatAlternativeNumber;
        private boolean repeatOpen;
        private boolean repeatAlternativeOpen;
        private boolean divisionTypeOpen;
        private boolean multipleVoices;
        private List skippedLyricBeats = new ArrayList();

        protected LilypondTempData() {
            this.reset();
        }

        public void reset() {
            this.multipleVoices = false;
            this.repeatCount = 0;
            this.repeatOpen = false;
            this.divisionTypeOpen = false;
            this.skippedLyricBeats.clear();
        }

        public int getRepeatCount() {
            return this.repeatCount;
        }

        public void setRepeatCount(int n) {
            this.repeatCount = n;
        }

        public boolean isRepeatOpen() {
            return this.repeatOpen;
        }

        public void setRepeatOpen(boolean bl) {
            this.repeatOpen = bl;
        }

        public int getRepeatAlternativeNumber() {
            return this.repeatAlternativeNumber;
        }

        public void setRepeatAlternativeNumber(int n) {
            this.repeatAlternativeNumber = n;
        }

        public boolean isRepeatAlternativeOpen() {
            return this.repeatAlternativeOpen;
        }

        public void setRepeatAlternativeOpen(boolean bl) {
            this.repeatAlternativeOpen = bl;
        }

        public boolean isDivisionTypeOpen() {
            return this.divisionTypeOpen;
        }

        public void setDivisionTypeOpen(boolean bl) {
            this.divisionTypeOpen = bl;
        }

        public void setMultipleVoices(boolean bl) {
            this.multipleVoices = bl;
        }

        public boolean isMultipleVoices() {
            return this.multipleVoices;
        }

        public void addSkippedLyricBeat(String string) {
            this.skippedLyricBeats.add(string);
        }

        public List getSkippedLyricBeats() {
            return this.skippedLyricBeats;
        }
    }
}

