/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGVoice;

public class GTPVoiceJoiner {
    private TGFactory factory;
    private TGMeasure measure;

    public GTPVoiceJoiner(TGFactory tGFactory, TGMeasure tGMeasure) {
        this.factory = tGFactory;
        this.measure = tGMeasure.clone(tGFactory, tGMeasure.getHeader());
        this.measure.setTrack(tGMeasure.getTrack());
    }

    public TGMeasure process() {
        this.orderBeats();
        this.joinBeats();
        return this.measure;
    }

    public void joinBeats() {
        TGBeat tGBeat = null;
        boolean bl = true;
        long l = this.measure.getStart();
        long l2 = l + this.measure.getLength();
        for (int i = 0; i < this.measure.countBeats(); ++i) {
            TGVoice tGVoice;
            TGBeat tGBeat2 = this.measure.getBeat(i);
            TGVoice tGVoice2 = tGBeat2.getVoice(0);
            for (int j = 1; j < tGBeat2.countVoices(); ++j) {
                TGVoice tGVoice3 = tGBeat2.getVoice(j);
                if (tGVoice3.isEmpty()) continue;
                for (int k = 0; k < tGVoice3.countNotes(); ++k) {
                    TGNote tGNote = tGVoice3.getNote(k);
                    tGVoice2.addNote(tGNote);
                }
            }
            if (tGVoice2.isEmpty()) {
                this.measure.removeBeat(tGBeat2);
                bl = false;
                break;
            }
            long l3 = tGBeat2.getStart();
            if (tGBeat != null) {
                long l4 = tGBeat.getStart();
                tGVoice = null;
                for (int j = 0; j < tGBeat.countVoices(); ++j) {
                    long l5;
                    TGVoice tGVoice4 = tGBeat.getVoice(j);
                    if (tGVoice4.isEmpty() || l4 + (l5 = tGVoice4.getDuration().getTime()) > l3 || tGVoice != null && l5 <= tGVoice.getTime()) continue;
                    tGVoice = tGVoice4.getDuration();
                }
                if (tGVoice != null) {
                    tGVoice.copy(tGBeat.getVoice(0).getDuration());
                } else {
                    if (tGVoice2.isRestVoice()) {
                        this.measure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l3 - l4));
                    tGDuration.copy(tGBeat.getVoice(0).getDuration());
                }
            }
            TGDuration tGDuration = null;
            for (int j = 0; j < tGBeat2.countVoices(); ++j) {
                long l6;
                tGVoice = tGBeat2.getVoice(j);
                if (tGVoice.isEmpty() || l3 + (l6 = tGVoice.getDuration().getTime()) > l2 || tGDuration != null && l6 <= tGDuration.getTime()) continue;
                tGDuration = tGVoice.getDuration();
            }
            if (tGDuration == null) {
                if (tGVoice2.isRestVoice()) {
                    this.measure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                TGDuration tGDuration2 = TGDuration.fromTime((TGFactory)this.factory, (long)(l2 - l3));
                tGDuration2.copy(tGVoice2.getDuration());
            }
            tGBeat = tGBeat2;
        }
        if (!bl) {
            this.joinBeats();
        }
    }

    public void orderBeats() {
        for (int i = 0; i < this.measure.countBeats(); ++i) {
            TGBeat tGBeat = null;
            for (int j = i; j < this.measure.countBeats(); ++j) {
                TGBeat tGBeat2 = this.measure.getBeat(j);
                if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                tGBeat = tGBeat2;
            }
            this.measure.moveBeat(i, tGBeat);
        }
    }
}

