/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFileFormat;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class GTPOutputStream
extends GTPFileFormat
implements TGOutputStreamBase {
    private OutputStream outputStream;

    public GTPOutputStream(GTPSettings gTPSettings) {
        super(gTPSettings);
    }

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        super.init(tGFactory);
        this.outputStream = outputStream;
    }

    protected void skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.outputStream.write(0);
        }
    }

    protected void writeByte(byte by) throws IOException {
        this.outputStream.write(by);
    }

    protected void writeUnsignedByte(int n) throws IOException {
        this.outputStream.write(n);
    }

    protected void writeBytes(byte[] byArray) throws IOException {
        this.outputStream.write(byArray);
    }

    protected void writeBoolean(boolean bl) throws IOException {
        this.outputStream.write(bl ? 1 : 0);
    }

    protected void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        this.outputStream.write(byArray);
    }

    protected void writeString(byte[] byArray, int n) throws IOException {
        int n2 = n == 0 || n > byArray.length ? byArray.length : n;
        for (int i = 0; i < n2; ++i) {
            this.outputStream.write(byArray[i]);
        }
    }

    protected void writeStringInteger(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.writeInt(byArray.length);
        this.writeString(byArray, 0);
    }

    protected void writeStringInteger(String string) throws IOException {
        this.writeStringInteger(string, this.getSettings().getCharset());
    }

    protected void writeStringByte(String string, int n, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.writeByte((byte)(n == 0 || n > byArray.length ? byArray.length : n));
        this.writeString(byArray, n);
        this.skipBytes(n - byArray.length);
    }

    protected void writeStringByte(String string, int n) throws IOException {
        this.writeStringByte(string, n, this.getSettings().getCharset());
    }

    protected void writeStringByteSizeOfInteger(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.writeInt(byArray.length + 1);
        this.writeStringByte(string, byArray.length, string2);
    }

    protected void writeStringByteSizeOfInteger(String string) throws IOException {
        this.writeStringByteSizeOfInteger(string, this.getSettings().getCharset());
    }

    protected void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }
}

