/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFileFormat;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class GTPInputStream
extends GTPFileFormat
implements TGInputStreamBase {
    private int versionIndex;
    private String version;
    private String[] versions;
    private InputStream stream;

    public GTPInputStream(GTPSettings gTPSettings, String[] stringArray) {
        super(gTPSettings);
        this.versions = stringArray;
    }

    public void init(TGFactory tGFactory, InputStream inputStream) {
        super.init(tGFactory);
        this.stream = inputStream;
        this.version = null;
    }

    protected String getVersion() {
        return this.version;
    }

    protected int getVersionIndex() {
        return this.versionIndex;
    }

    public boolean isSupportedVersion(String string) {
        for (int i = 0; i < this.versions.length; ++i) {
            if (!string.equals(this.versions[i])) continue;
            this.versionIndex = i;
            return true;
        }
        return false;
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.getVersion());
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    protected void readVersion() {
        try {
            if (this.version == null) {
                this.version = this.readStringByte(30, "UTF-8");
            }
        }
        catch (IOException iOException) {
            this.version = "NOT_SUPPORTED";
        }
    }

    protected int read() throws IOException {
        return this.stream.read();
    }

    protected int read(byte[] byArray) throws IOException {
        return this.stream.read(byArray);
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        return this.stream.read(byArray, n, n2);
    }

    protected void skip(int n) throws IOException {
        this.stream.read(new byte[n]);
    }

    protected int readUnsignedByte() throws IOException {
        return this.stream.read() & 0xFF;
    }

    protected byte readByte() throws IOException {
        return (byte)this.stream.read();
    }

    protected boolean readBoolean() throws IOException {
        return this.stream.read() == 1;
    }

    protected int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.stream.read(byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    protected long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.stream.read(byArray);
        return (long)(byArray[7] & 0xFF) << 56 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
    }

    protected String readString(int n, int n2, String string) throws IOException {
        byte[] byArray = new byte[n > 0 ? n : n2];
        this.stream.read(byArray);
        return this.newString(byArray, n2 >= 0 ? n2 : n, string);
    }

    protected String readString(int n, String string) throws IOException {
        return this.readString(n, n, string);
    }

    protected String readString(int n) throws IOException {
        return this.readString(n, this.getSettings().getCharset());
    }

    protected String readStringInteger(String string) throws IOException {
        return this.readString(this.readInt(), string);
    }

    protected String readStringInteger() throws IOException {
        return this.readStringInteger(this.getSettings().getCharset());
    }

    protected String readStringByte(int n, String string) throws IOException {
        return this.readString(n, this.readUnsignedByte(), string);
    }

    protected String readStringByte(int n) throws IOException {
        return this.readStringByte(n, this.getSettings().getCharset());
    }

    protected String readStringByteSizeOfByte(String string) throws IOException {
        return this.readStringByte(this.readUnsignedByte() - 1, string);
    }

    protected String readStringByteSizeOfByte() throws IOException {
        return this.readStringByteSizeOfByte(this.getSettings().getCharset());
    }

    protected String readStringByteSizeOfInteger(String string) throws IOException {
        return this.readStringByte(this.readInt() - 1, string);
    }

    protected String readStringByteSizeOfInteger() throws IOException {
        return this.readStringByteSizeOfInteger(this.getSettings().getCharset());
    }

    private String newString(byte[] byArray, int n, String string) {
        try {
            return new String(new String(byArray, 0, n, string).getBytes("UTF-8"), "UTF-8");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new String(byArray, 0, n);
        }
    }

    protected void close() throws IOException {
        this.stream.close();
    }
}

