/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.startup;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGCommunityStartupScreen {
    private static final int MAIN_WIDTH = 550;
    private static final int MAIN_HEIGHT = -1;

    public void open() {
        try {
            final Shell shell = TuxGuitar.instance().getShell();
            TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    TGCommunityStartupScreen.this.open(shell);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void open(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)2144);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        shell2.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        shell2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(550, -1));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label label = new Label(composite3, 0);
        label.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addTitle(composite4, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        this.addTipItem(composite4);
        this.addComment(composite4, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-1"));
        this.addTipItem(composite4);
        this.addComment(composite4, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-2"));
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayout((Layout)new GridLayout());
        composite5.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addComment(composite5, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-bottom"));
        Composite composite6 = new Composite(composite, 0);
        composite6.setLayout((Layout)new GridLayout(2, false));
        composite6.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button button = new Button(composite6, 32);
        button.setLayoutData((Object)new GridData(16384, 4, true, true));
        button.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.disable"));
        button.setSelection(this.isDisabled());
        Button button2 = new Button(composite6, 8);
        button2.setText(TuxGuitar.getProperty((String)"ok"));
        button2.setLayoutData((Object)this.getButtonOkData());
        button2.setFocus();
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGCommunityStartupScreen.this.setDisabled(button.getSelection());
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog((Shell)shell2, (int)10);
    }

    private GridData getButtonOkData() {
        GridData gridData = new GridData(131072, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void addTitle(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        label.setText(string);
        FontData[] fontDataArray = label.getFont().getFontData();
        if (fontDataArray.length > 0) {
            int n = fontDataArray[0].getHeight() + 2;
            int n2 = fontDataArray[0].getStyle() | 1;
            final Font font = new Font((Device)label.getDisplay(), fontDataArray[0].getName(), n, n2);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    font.dispose();
                }
            });
        }
    }

    private void addTipItem(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData(16384, 128, false, true));
        label.setText("\u066d");
    }

    private void addComment(Composite composite, String string) {
        Link link = new Link(composite, 16384);
        link.setLayoutData((Object)new GridData(4, 4, true, true));
        link.setText(string);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                final String string = event.text;
                if (string != null) {
                    new Thread(new Runnable(){

                        public void run() {
                            TGCommunityWeb.open(string);
                        }
                    }).start();
                }
            }
        });
    }

    public void setDisabled(boolean bl) {
        TGCommunitySingleton.getInstance().getConfig().setProperty("community.welcome.disabled", bl);
    }

    public boolean isDisabled() {
        return TGCommunitySingleton.getInstance().getConfig().getBooleanConfigValue("community.welcome.disabled");
    }
}

