/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.browser;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.herac.tuxguitar.community.browser.TGBrowserElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TGBrowserResponse {
    private static final String TAG_STATUS = "status";
    private static final String TAG_ELEMENTS = "elements";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_SONG = "song";
    private static final String TAG_PARAMETERS = "parameters";
    private static final String TAG_PARAMETER = "parameter";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_VALUE = "value";
    private Document document;

    public TGBrowserResponse(InputStream inputStream) throws Throwable {
        this.initialize(inputStream);
    }

    private void initialize(InputStream inputStream) throws Throwable {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputStream);
    }

    public String getStatus() {
        if (this.document != null) {
            return this.getStatus(this.document.getFirstChild());
        }
        return null;
    }

    private String getStatus(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(TAG_STATUS)) continue;
            return this.getAttributeValue(node2.getAttributes(), ATTRIBUTE_CODE);
        }
        return null;
    }

    public void loadElements(List list) {
        if (this.document != null) {
            this.loadElements(list, this.document.getFirstChild());
        }
    }

    private void loadElements(List list, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(TAG_ELEMENTS)) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                NamedNodeMap namedNodeMap;
                String string;
                Node node3 = nodeList2.item(j);
                String string2 = node3.getNodeName();
                if (!string2.equals(TAG_ELEMENT) || (string = this.getAttributeValue(namedNodeMap = node3.getAttributes(), ATTRIBUTE_NAME)) == null || string.trim().length() <= 0) continue;
                TGBrowserElementImpl tGBrowserElementImpl = new TGBrowserElementImpl(string);
                NodeList nodeList3 = node3.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Node node4 = nodeList3.item(k);
                    if (node4.getNodeName().equals(TAG_SONG)) {
                        tGBrowserElementImpl.setUrl(this.getAttributeValue(node4.getAttributes(), ATTRIBUTE_URL));
                        continue;
                    }
                    if (!node4.getNodeName().equals(TAG_PARAMETERS)) continue;
                    NodeList nodeList4 = node4.getChildNodes();
                    for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                        Node node5 = nodeList4.item(i2);
                        if (!node5.getNodeName().equals(TAG_PARAMETER)) continue;
                        NamedNodeMap namedNodeMap2 = node5.getAttributes();
                        String string3 = this.getAttributeValue(namedNodeMap2, ATTRIBUTE_KEY);
                        String string4 = this.getAttributeValue(namedNodeMap2, ATTRIBUTE_VALUE);
                        if (string3 == null || string4 == null || string3.trim().length() <= 0 || string4.trim().length() <= 0) continue;
                        tGBrowserElementImpl.addProperty(string3, string4);
                    }
                }
                list.add(tGBrowserElementImpl);
            }
        }
    }

    private String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        try {
            Node node;
            if (namedNodeMap != null && string != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return URLDecoder.decode(node.getNodeValue(), "UTF-8");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

