/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.browser;

import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.browser.TGBrowserElementImpl;
import org.herac.tuxguitar.community.browser.TGBrowserResponse;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;

public class TGBrowserRequest {
    private static final String REMOTE_URL = TGCommunityWeb.HOME_URL + "/rd.php/sharing/tuxguitar/browser.do";
    private String request;

    public TGBrowserRequest(TGCommunityAuth tGCommunityAuth, TGBrowserElementImpl tGBrowserElementImpl) throws Throwable {
        this.initialize(tGCommunityAuth, tGBrowserElementImpl);
    }

    public TGBrowserRequest(TGCommunityAuth tGCommunityAuth) throws Throwable {
        this(tGCommunityAuth, null);
    }

    private void initialize(TGCommunityAuth tGCommunityAuth, TGBrowserElementImpl tGBrowserElementImpl) throws Throwable {
        this.request = new String();
        this.request = this.request + URLEncoder.encode("auth", "UTF-8");
        this.request = this.request + "=";
        this.request = this.request + URLEncoder.encode(tGCommunityAuth.getAuthCode(), "UTF-8");
        if (tGBrowserElementImpl != null) {
            Iterator iterator = tGBrowserElementImpl.getProperties();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.request = this.request + "&";
                this.request = this.request + URLEncoder.encode((String)entry.getKey(), "UTF-8");
                this.request = this.request + "=";
                this.request = this.request + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
        }
    }

    public TGBrowserResponse getResponse() throws Throwable {
        URL uRL = new URL(REMOTE_URL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(this.request);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        return new TGBrowserResponse(uRLConnection.getInputStream());
    }
}

