/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.browser;

import java.util.List;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.browser.TGBrowserElementImpl;
import org.herac.tuxguitar.community.browser.TGBrowserRequest;
import org.herac.tuxguitar.community.browser.TGBrowserResponse;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserException;

public class TGBrowserConnection {
    private static final String HTTP_STATUS_OK = "200";
    private static final String HTTP_STATUS_UNAUTHORIZED = "401";
    private TGCommunityAuth auth = TGCommunitySingleton.getInstance().getAuth();

    public TGBrowserConnection() {
        this.auth.update();
    }

    public void getElements(List list, TGBrowserElementImpl tGBrowserElementImpl) throws TGBrowserException {
        try {
            TGBrowserRequest tGBrowserRequest = new TGBrowserRequest(this.auth, tGBrowserElementImpl);
            TGBrowserResponse tGBrowserResponse = tGBrowserRequest.getResponse();
            String string = tGBrowserResponse.getStatus();
            if (string != null && string.equals(HTTP_STATUS_OK)) {
                tGBrowserResponse.loadElements(list);
            } else if (string != null && string.equals(HTTP_STATUS_UNAUTHORIZED)) {
                TGCommunityAuthDialog tGCommunityAuthDialog = new TGCommunityAuthDialog();
                if (!TuxGuitar.instance().getBrowser().isDisposed()) {
                    tGCommunityAuthDialog.open(TuxGuitar.instance().getBrowser().getShell());
                    if (tGCommunityAuthDialog.isAccepted()) {
                        this.auth.update();
                        this.getElements(list, tGBrowserElementImpl);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }
}

