/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;
import org.herac.tuxguitar.io.gervill.MidiToAudioSynth;

public class MidiToAudioWriter {
    public static void write(OutputStream outputStream, List list, MidiToAudioSettings midiToAudioSettings) throws Throwable {
        Object object;
        MidiToAudioSynth.instance().openSynth();
        int n = 500000;
        long l = 0L;
        long l2 = 0L;
        MidiToAudioWriter.sort(list);
        Receiver receiver = MidiToAudioSynth.instance().getReceiver();
        AudioInputStream audioInputStream = MidiToAudioSynth.instance().getStream();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MidiEvent midiEvent = (MidiEvent)iterator.next();
            MidiMessage midiMessage = midiEvent.getMessage();
            l2 += (midiEvent.getTick() - l) * (long)n / 960L;
            if (midiMessage instanceof MetaMessage) {
                if (((MetaMessage)midiMessage).getType() == 81) {
                    object = ((MetaMessage)midiMessage).getData();
                    n = (object[0] & 0xFF) << 16 | (object[1] & 0xFF) << 8 | object[2] & 0xFF;
                }
            } else {
                receiver.send(midiMessage, l2);
            }
            l = midiEvent.getTick();
        }
        long l3 = (long)((double)audioInputStream.getFormat().getFrameRate() * ((double)l2 / 1000000.0));
        object = new AudioInputStream(audioInputStream, audioInputStream.getFormat(), l3);
        AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(midiToAudioSettings.getFormat(), (AudioInputStream)object);
        AudioSystem.write(new AudioInputStream(audioInputStream2, audioInputStream2.getFormat(), l3), midiToAudioSettings.getType(), outputStream);
        audioInputStream2.close();
        ((AudioInputStream)object).close();
        MidiToAudioSynth.instance().closeSynth();
    }

    private static void sort(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof MidiEvent && object2 instanceof MidiEvent) {
                    MidiEvent midiEvent = (MidiEvent)object;
                    MidiEvent midiEvent2 = (MidiEvent)object2;
                    if (midiEvent.getTick() > midiEvent2.getTick()) {
                        return 1;
                    }
                    if (midiEvent.getTick() < midiEvent2.getTick()) {
                        return -1;
                    }
                }
                return 0;
            }
        });
    }
}

