/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;

public class MidiToAudioSettingsDialog {
    protected boolean success;

    public boolean open(final MidiToAudioSettings midiToAudioSettings) {
        MidiToAudioFormat midiToAudioFormat;
        this.success = false;
        final List list = this.getAvailableFormats();
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("Options");
        Group group = new Group((Composite)shell, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)this.getGroupData());
        group.setText("Audio Format");
        Label label = new Label((Composite)group, 0);
        label.setText("File Encoding:");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("File Type:");
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo combo2 = new Combo((Composite)group, 12);
        combo2.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            midiToAudioFormat = (MidiToAudioFormat)list.get(i);
            combo.add(midiToAudioFormat.getFormat().getEncoding().toString());
            if (!this.isSameEncoding(midiToAudioSettings.getFormat(), midiToAudioFormat.getFormat())) continue;
            n = i;
        }
        if (!list.isEmpty()) {
            combo.select(n);
            this.updateTypesCombo(midiToAudioSettings, list, combo, combo2);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiToAudioSettingsDialog.this.updateTypesCombo(midiToAudioSettings, list, combo, combo2);
            }
        });
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        midiToAudioFormat = new GridData(4, 4, true, true);
        ((GridData)midiToAudioFormat).minimumWidth = 80;
        ((GridData)midiToAudioFormat).minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)midiToAudioFormat);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo2.getSelectionIndex();
                int n2 = combo.getSelectionIndex();
                if (n2 >= 0 && n2 < list.size()) {
                    MidiToAudioFormat midiToAudioFormat = (MidiToAudioFormat)list.get(n2);
                    if (n >= 0 && n < midiToAudioFormat.getTypes().length) {
                        midiToAudioSettings.setType(midiToAudioFormat.getTypes()[n]);
                        midiToAudioSettings.setFormat(midiToAudioFormat.getFormat());
                        MidiToAudioSettingsDialog.this.success = true;
                    }
                }
                shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)midiToAudioFormat);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }
        });
        shell.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell, (int)11);
        return this.success;
    }

    private GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }

    private void updateTypesCombo(MidiToAudioSettings midiToAudioSettings, List list, Combo combo, Combo combo2) {
        combo2.removeAll();
        int n = combo.getSelectionIndex();
        if (n >= 0 && n < list.size()) {
            MidiToAudioFormat midiToAudioFormat = (MidiToAudioFormat)list.get(n);
            AudioFileFormat.Type[] typeArray = midiToAudioFormat.getTypes();
            int n2 = 0;
            for (int i = 0; i < typeArray.length; ++i) {
                combo2.add(typeArray[i] + " (*." + typeArray[i].getExtension() + ")");
                if (midiToAudioSettings.getType() == null || !midiToAudioSettings.getType().equals(typeArray[i])) continue;
                n2 = i;
            }
            combo2.select(n2);
        }
    }

    public List getAvailableFormats() {
        ArrayList<MidiToAudioFormat> arrayList = new ArrayList<MidiToAudioFormat>();
        AudioFormat audioFormat = MidiToAudioSettings.DEFAULT_FORMAT;
        AudioFormat.Encoding[] encodingArray = AudioSystem.getTargetEncodings(audioFormat);
        for (int i = 0; i < encodingArray.length; ++i) {
            AudioFormat audioFormat2 = new AudioFormat(encodingArray[i], audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
            AudioInputStream audioInputStream = new AudioInputStream(null, audioFormat2, 0L);
            AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes(audioInputStream);
            if (typeArray.length <= 0) continue;
            arrayList.add(new MidiToAudioFormat(audioFormat2, typeArray));
        }
        return arrayList;
    }

    public boolean isSameEncoding(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (audioFormat == null || audioFormat2 == null || audioFormat.getEncoding() == null || audioFormat2.getEncoding() == null) {
            return false;
        }
        return audioFormat.getEncoding().toString().equals(audioFormat2.getEncoding().toString());
    }

    private class MidiToAudioFormat {
        private AudioFormat format;
        private AudioFileFormat.Type[] types;

        public MidiToAudioFormat(AudioFormat audioFormat, AudioFileFormat.Type[] typeArray) {
            this.format = audioFormat;
            this.types = typeArray;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public AudioFileFormat.Type[] getTypes() {
            return this.types;
        }
    }
}

