/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.gervill.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettingsDialog;
import org.herac.tuxguitar.io.gervill.MidiToAudioWriter;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class MidiToAudioExporter
implements TGLocalFileExporter {
    private MidiToAudioSettings settings = new MidiToAudioSettings();
    private OutputStream stream;

    public MidiToAudioExporter() {
        this.settings.setDefaults();
    }

    public String getExportName() {
        return "Audio File";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat(this.settings.getType().toString(), "*." + this.settings.getType().getExtension());
    }

    public boolean configure(boolean bl) {
        if (!bl) {
            return new MidiToAudioSettingsDialog().open(this.settings);
        }
        this.settings.setDefaults();
        return true;
    }

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void exportSong(TGSong tGSong) throws TGFileFormatException {
        try {
            if (this.stream != null) {
                TGSongManager tGSongManager = new TGSongManager();
                tGSongManager.setSong(tGSong);
                MidiSequenceParser midiSequenceParser = new MidiSequenceParser(tGSongManager, 11, 100, 0);
                MidiSequenceHandlerImpl midiSequenceHandlerImpl = new MidiSequenceHandlerImpl(tGSong.countTracks() + 1);
                midiSequenceParser.parse((MidiSequenceHandler)midiSequenceHandlerImpl);
                MidiToAudioWriter.write(this.stream, midiSequenceHandlerImpl.getEvents(), this.settings);
            }
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable.getMessage(), throwable);
        }
    }
}

