/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiEvent;
import org.herac.tuxguitar.io.gervill.MidiMessageUtils;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiSequenceHandlerImpl
extends MidiSequenceHandler {
    private List events = new ArrayList();

    public MidiSequenceHandlerImpl(int n) {
        super(n);
    }

    public void addControlChange(long l, int n, int n2, int n3, int n4) {
        this.events.add(new MidiEvent(MidiMessageUtils.controlChange(n2, n3, n4), l));
    }

    public void addNoteOff(long l, int n, int n2, int n3, int n4) {
        this.events.add(new MidiEvent(MidiMessageUtils.noteOff(n2, n3, n4), l));
    }

    public void addNoteOn(long l, int n, int n2, int n3, int n4) {
        this.events.add(new MidiEvent(MidiMessageUtils.noteOn(n2, n3, n4), l));
    }

    public void addPitchBend(long l, int n, int n2, int n3) {
        this.events.add(new MidiEvent(MidiMessageUtils.pitchBend(n2, n3), l));
    }

    public void addProgramChange(long l, int n, int n2, int n3) {
        this.events.add(new MidiEvent(MidiMessageUtils.programChange(n2, n3), l));
    }

    public void addTempoInUSQ(long l, int n, int n2) {
        this.events.add(new MidiEvent(MidiMessageUtils.tempoInUSQ(n2), l));
    }

    public void addTimeSignature(long l, int n, TGTimeSignature tGTimeSignature) {
        this.events.add(new MidiEvent(MidiMessageUtils.timeSignature(tGTimeSignature), l));
    }

    public void notifyFinish() {
    }

    public List getEvents() {
        return this.events;
    }
}

