/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiMessageUtils {
    public static final byte TICK_MOVE = 1;

    private static int fixValue(int n) {
        int n2 = n;
        n2 = Math.min(n2, 127);
        n2 = Math.max(n2, 0);
        return n2;
    }

    private static int fixChannel(int n) {
        int n2 = n;
        n2 = Math.min(n2, 15);
        n2 = Math.max(n2, 0);
        return n2;
    }

    public static MidiMessage noteOn(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage noteOff(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage controlChange(int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(176, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage programChange(int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), 0);
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage pitchBend(int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(224, MidiMessageUtils.fixChannel(n), 0, MidiMessageUtils.fixValue(n2));
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage systemReset() {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(255);
            return shortMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage tempoInUSQ(int n) {
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(81, new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)}, 3);
            return metaMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }

    public static MidiMessage timeSignature(TGTimeSignature tGTimeSignature) {
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(88, new byte[]{(byte)tGTimeSignature.getNumerator(), (byte)tGTimeSignature.getDenominator().getIndex(), (byte)(96 / tGTimeSignature.getDenominator().getValue()), 8}, 4);
            return metaMessage;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return null;
        }
    }
}

