/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.midiport;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.Receiver;
import org.herac.tuxguitar.player.base.MidiReceiver;
import org.herac.tuxguitar.player.impl.jsa.utils.MidiMessageUtils;
import org.herac.tuxguitar.util.TGSynchronizer;

class MidiReceiverImpl
implements MidiReceiver {
    private MidiDevice device;
    private Receiver receiver;

    public MidiReceiverImpl(MidiDevice midiDevice) {
        this.device = midiDevice;
    }

    protected synchronized void open() throws Throwable {
        MidiDevice midiDevice;
        if (!this.device.isOpen()) {
            midiDevice = this.device;
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    midiDevice.open();
                }
            });
        }
        if (this.receiver == null) {
            midiDevice = this.device;
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    MidiReceiverImpl.this.setReceiver(midiDevice.getReceiver());
                }
            });
        }
    }

    protected synchronized void close() throws Throwable {
        AutoCloseable autoCloseable;
        if (this.receiver != null) {
            autoCloseable = this.receiver;
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable((Receiver)autoCloseable){
                private final /* synthetic */ Receiver val$receiver;
                {
                    this.val$receiver = receiver;
                }

                public void run() throws Throwable {
                    this.val$receiver.close();
                    MidiReceiverImpl.this.setReceiver(null);
                }
            });
        }
        if (this.device.isOpen()) {
            autoCloseable = this.device;
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable((MidiDevice)autoCloseable){
                private final /* synthetic */ MidiDevice val$device;
                {
                    this.val$device = midiDevice;
                }

                public void run() throws Throwable {
                    this.val$device.close();
                }
            });
        }
    }

    protected void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    protected Receiver getReceiver() {
        return this.receiver;
    }

    public void sendSystemReset() {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.systemReset(), -1L);
        }
    }

    public void sendAllNotesOff() {
        if (this.getReceiver() != null) {
            for (int i = 0; i < 16; ++i) {
                this.getReceiver().send(MidiMessageUtils.controlChange(i, 123, 0), -1L);
            }
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.noteOn(n, n2, n3), -1L);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.noteOff(n, n2, n3), -1L);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.controlChange(n, n2, n3), -1L);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.programChange(n, n2), -1L);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageUtils.pitchBend(n, n2), -1L);
        }
    }
}

