/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class TGBrowserFTPClient {
    public static final int DEFAULT_PORT = 21;
    public static final String DEFAULT_USER_NAME = "anonymous";
    public static final String DEFAULT_USER_PASSWORD = "anonymous";
    private static final String REQUEST_USER_NAME = "USER";
    private static final String REQUEST_USER_PASSWORD = "PASS";
    private static final String REQUEST_EXIT = "QUIT";
    private static final String REQUEST_TYPE_ASCII = "TYPE A";
    private static final String REQUEST_TYPE_BINARY = "TYPE I";
    private static final String REQUEST_PWD = "PWD";
    private static final String REQUEST_CD = "CWD";
    private static final String REQUEST_CDUP = "CDUP";
    private static final String REQUEST_PASSIVE = "PASV";
    private static final String REQUEST_GET = "RETR";
    private static final String REQUEST_LIST_FILES = "LIST";
    private static final String REQUEST_LIST_NAMES = "NLST";
    private static final int RESPONSE_CODE_CONNECT = 220;
    private static final int RESPONSE_CODE_USER_NAME = 331;
    private static final int RESPONSE_CODE_USER_PASSWORD = 230;
    private static final int RESPONSE_CODE_PWD = 257;
    private static final int RESPONSE_CODE_CD = 250;
    private static final int RESPONSE_CODE_TYPE = 200;
    private static final int RESPONSE_CODE_PASV = 227;
    private static final int RESPONSE_CODE_PASV_CONNECTION = 150;
    private boolean open;
    private Socket socket = null;
    private BufferedWriter request = null;
    private BufferedReader response = null;

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public synchronized void open(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
        this.response = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.request = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String string2 = this.getResponse(220);
        if (!this.isExpectedResponse(string2, 220)) {
            throw new IOException(string2);
        }
        this.setOpen(true);
    }

    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            this.setRequest(REQUEST_EXIT);
            this.socket.close();
            this.socket = null;
        }
        this.setOpen(false);
    }

    public synchronized void login(String string, String string2) throws IOException {
        String string3 = null;
        this.setRequest("USER " + string);
        string3 = this.getResponseError(331);
        if (string3 != null) {
            throw new IOException(string3);
        }
        this.setRequest("PASS " + string2);
        string3 = this.getResponseError(230);
        if (string3 != null) {
            throw new IOException(string3);
        }
    }

    public synchronized String pwd() throws IOException {
        int n;
        int n2;
        this.setRequest(REQUEST_PWD);
        String string = this.getResponse(257);
        if (this.isExpectedResponse(string, 257) && (n2 = string.indexOf(34, (n = string.indexOf(34)) + 1)) > n) {
            return string.substring(n + 1, n2);
        }
        return null;
    }

    public synchronized boolean cd(String string) throws IOException {
        this.setRequest("CWD " + string);
        return this.getResponseError(250) == null;
    }

    public synchronized boolean cdUp() throws IOException {
        this.setRequest(REQUEST_CDUP);
        return this.getResponseError(250) == null;
    }

    public synchronized boolean binary() throws IOException {
        this.setRequest(REQUEST_TYPE_BINARY);
        return this.getResponseError(200) == null;
    }

    public synchronized boolean ascii() throws IOException {
        this.setRequest(REQUEST_TYPE_ASCII);
        return this.getResponseError(200) == null;
    }

    public synchronized byte[] get(String string) throws IOException {
        return this.sendPasvCMD("RETR " + string);
    }

    public synchronized String[] listDetails() throws IOException {
        return new String(this.sendPasvCMD(REQUEST_LIST_FILES)).split("\r\n");
    }

    public synchronized String[] listNames() throws IOException {
        return new String(this.sendPasvCMD(REQUEST_LIST_NAMES)).split("\r\n");
    }

    private synchronized byte[] sendPasvCMD(String string) throws IOException {
        byte[] byArray = new byte[]{};
        this.setRequest(REQUEST_PASSIVE);
        String string2 = this.getResponse(227);
        if (this.isExpectedResponse(string2, 227)) {
            String[] stringArray;
            this.setRequest(string);
            int n = string2.indexOf("(") + 1;
            int n2 = string2.indexOf(")");
            if (n > 0 && n2 > n && (stringArray = string2.substring(n, n2).split(",")).length == 6) {
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                int n6 = Integer.parseInt(stringArray[3]);
                int n7 = Integer.parseInt(stringArray[4]);
                int n8 = Integer.parseInt(stringArray[5]);
                Socket socket = new Socket(n3 + "." + n4 + "." + n5 + "." + n6, n7 * 256 + n8);
                string2 = this.getResponse(150);
                if (this.isExpectedResponse(string2, 150)) {
                    byArray = TGBrowserFTPClient.getByteBuffer(socket.getInputStream());
                }
                socket.close();
            }
            if (this.isExpectedResponse(string2, 150)) {
                string2 = this.getResponse();
            }
        }
        return byArray;
    }

    private boolean isExpectedResponse(String string, int n) {
        return string != null && string.indexOf(n + " ") == 0;
    }

    private String getResponseError(int n) throws IOException {
        String string = this.getResponse(n);
        return this.isExpectedResponse(string, n) ? null : string;
    }

    private String getResponse(int n) throws IOException {
        String string = this.getResponse();
        while (string != null && string.indexOf(n + "-") == 0) {
            string = this.getResponse();
        }
        return string;
    }

    private String getResponse() throws IOException {
        return this.response.readLine();
    }

    private void setRequest(String string) throws IOException {
        this.request.write(string + "\r\n");
        this.request.flush();
    }

    private static byte[] getByteBuffer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        byteArrayOutputStream.flush();
        return byArray;
    }
}

