/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        Object object;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        int n4 = OS.gtk_entry_get_layout(this.handle);
        int n5 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n5);
        int n6 = OS.gtk_spin_button_get_digits(this.handle);
        int n7 = 0;
        while (n7 < n6) {
            gtkAdjustment.upper *= 10.0;
            ++n7;
        }
        String string = String.valueOf((int)gtkAdjustment.upper);
        if (n6 > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(this.getDecimalSeparator());
            n3 = n6 - string.length();
            while (n3 >= 0) {
                ((StringBuffer)object).append("0");
                --n3;
            }
            string = ((StringBuffer)object).toString();
        }
        object = Converter.wcsToMbcs(null, string, false);
        n3 = OS.pango_layout_get_text(n4);
        int n8 = OS.strlen(n3);
        byte[] byArray = new byte[n8];
        OS.memmove(byArray, n3, n8);
        OS.pango_layout_set_text(n4, (byte[])object, ((Object)object).length);
        OS.pango_layout_get_size(n4, nArray, nArray2);
        OS.pango_layout_set_text(n4, byArray, byArray.length);
        int n9 = OS.PANGO_PIXELS(nArray[0]);
        int n10 = OS.PANGO_PIXELS(nArray2[0]);
        n9 = n == -1 ? n9 : n;
        n10 = n2 == -1 ? n10 : n2;
        Rectangle rectangle = this.computeTrim(0, 0, n9, n10);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        int n7 = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            n5 += OS.gtk_style_get_xthickness(n7);
            n6 += OS.gtk_style_get_ythickness(n7);
        }
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, nArray, 0);
        if (nArray[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
            n5 += nArray[0];
            n6 += nArray[0];
        }
        int n8 = OS.gtk_style_get_font_desc(n7);
        int n9 = OS.pango_font_description_get_size(n8);
        int n10 = Math.max(OS.PANGO_PIXELS(n9), 6);
        n10 -= n10 % 2;
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        rectangle.width += n10 + 2 * OS.gtk_style_get_xthickness(n7);
        GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
        rectangle.x -= gtkBorder.left;
        rectangle.y -= gtkBorder.top;
        rectangle.width += gtkBorder.left + gtkBorder.right;
        rectangle.height += gtkBorder.top + gtkBorder.bottom;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard(this.handle);
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        int n2 = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (n2 == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_spin_button_new(n2, 1.0, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
        OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
        OS.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard(this.handle);
    }

    void deregister() {
        super.deregister();
        int n = this.imContext();
        if (n != 0) {
            this.display.removeWidget(n);
        }
    }

    int eventWindow() {
        return this.paintWindow();
    }

    int enterExitHandle() {
        return this.fixedHandle;
    }

    boolean filterKey(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n2);
        if (n3 != this.lastEventTime) {
            this.lastEventTime = n3;
            int n4 = this.imContext();
            if (n4 != 0) {
                return OS.gtk_im_context_filter_keypress(n4, n2);
            }
        }
        this.gdkEventKey = n2;
        return false;
    }

    void fixIM() {
        int n;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (n = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(n, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness(n);
        }
        return 0;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getIncrement() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.step_increment;
        int n3 = 0;
        while (n3 < n2) {
            d *= 10.0;
            ++n3;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.upper;
        int n3 = 0;
        while (n3 < n2) {
            d *= 10.0;
            ++n3;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.lower;
        int n3 = 0;
        while (n3 < n2) {
            d *= 10.0;
            ++n3;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.page_increment;
        int n3 = 0;
        while (n3 < n2) {
            d *= 10.0;
            ++n3;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        int n = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n);
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.value;
        int n3 = 0;
        while (n3 < n2) {
            d *= 10.0;
            ++n3;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.gtk_entry_get_text(this.handle);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : n;
    }

    public int getDigits() {
        this.checkWidget();
        return OS.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        int n = OS.localeconv_decimal_point();
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    int gtk_activate(int n) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int n) {
        int n2 = OS.gtk_entry_get_text(this.handle);
        int n3 = OS.strlen(n2);
        if (n3 > 0) {
            int[] nArray = new int[1];
            double d = OS.g_strtod(n2, nArray);
            if (nArray[0] == n2 + n3) {
                int n4 = OS.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment gtkAdjustment = new GtkAdjustment();
                OS.memmove(gtkAdjustment, n4);
                if (d != gtkAdjustment.value && gtkAdjustment.lower <= d && d <= gtkAdjustment.upper) {
                    OS.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean bl = false;
        int n5 = OS.gtk_get_current_event();
        if (n5 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n5, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(n5);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 9);
        int n4 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n5 = 17;
        OS.g_signal_handlers_unblock_matched(n, n5, n4, 0, 0, 0, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(n, OS.commit, n2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(n, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(n, n5, n4, 0, 0, 0, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_text(int n, int n2, int n3) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String string = this.verifyText("", n2, n3);
        if (string == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{n3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(n, n2);
    }

    int gtk_focus_out_event(int n, int n2) {
        this.fixIM();
        return super.gtk_focus_out_event(n, n2);
    }

    int gtk_insert_text(int n, int n2, int n3, int n4) {
        String string;
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        if (nArray[0] == -1) {
            int n5 = OS.gtk_entry_get_text(this.handle);
            nArray[0] = OS.g_utf8_strlen(n5, -1);
        }
        if ((string = this.verifyText(string2, nArray[0], nArray[0])) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(n4, nArray, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            n3 = 1;
        }
        this.gdkEventKey = 0;
        return n3;
    }

    int gtk_populate_popup(int n, int n2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(n2, 2);
            OS.gtk_container_forall(n2, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    int gtk_value_changed(int n) {
        this.postEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.closures[26], false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.closures[13], false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.closures[37], false);
        int n = this.imContext();
        if (n != 0) {
            OS.g_signal_connect_closure(n, OS.commit, this.display.closures[9], false);
            int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n3 = 17;
            OS.g_signal_handlers_block_matched(n, n3, n2, 0, 0, 0, this.handle);
        }
    }

    int imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
    }

    int paintWindow() {
        int n = super.paintWindow();
        int n2 = OS.gdk_window_get_children(n);
        if (n2 != 0) {
            n = OS.g_list_data(n2);
        }
        OS.g_list_free(n2);
        return n;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard(this.handle);
    }

    void register() {
        super.register();
        int n = this.imContext();
        if (n != 0) {
            this.display.addWidget(n, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setCursor(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = OS.gdk_cursor_new(152);
        }
        super.setCursor(n != 0 ? n : n2);
        if (n == 0) {
            OS.gdk_cursor_destroy(n2);
        }
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n2);
        double d = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        int n4 = 0;
        while (n4 < n3) {
            d /= 10.0;
            ++n4;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, d, gtkAdjustment.page_increment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n2);
        double d = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        int n4 = 0;
        while (n4 < n3) {
            d /= 10.0;
            ++n4;
        }
        if (d < gtkAdjustment.lower) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, gtkAdjustment.lower, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n2);
        double d = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        int n4 = 0;
        while (n4 < n3) {
            d /= 10.0;
            ++n4;
        }
        if (d > gtkAdjustment.upper) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, d, gtkAdjustment.upper);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n2);
        double d = n;
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        int n4 = 0;
        while (n4 < n3) {
            d /= 10.0;
            ++n4;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, gtkAdjustment.step_increment, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setSelection(int n) {
        this.checkWidget();
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_value(this.handle, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length(this.handle, n);
    }

    public void setDigits(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == (n2 = OS.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        int n3 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n3);
        int n4 = Math.abs(n - n2);
        int n5 = 1;
        int n6 = 0;
        while (n6 < n4) {
            n5 *= 10;
            ++n6;
        }
        if (n2 > n) {
            gtkAdjustment.value *= (double)n5;
            gtkAdjustment.upper *= (double)n5;
            gtkAdjustment.lower *= (double)n5;
            gtkAdjustment.step_increment *= (double)n5;
            gtkAdjustment.page_increment *= (double)n5;
        } else {
            gtkAdjustment.value /= (double)n5;
            gtkAdjustment.upper /= (double)n5;
            gtkAdjustment.lower /= (double)n5;
            gtkAdjustment.step_increment /= (double)n5;
            gtkAdjustment.page_increment /= (double)n5;
        }
        OS.memmove(n3, gtkAdjustment);
        OS.gtk_spin_button_set_digits(this.handle, n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 < n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        double d = 1.0;
        int n7 = 0;
        while (n7 < n4) {
            d *= 10.0;
            ++n7;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, (double)n2 / d, (double)n3 / d);
        OS.gtk_spin_button_set_increments(this.handle, (double)n5 / d, (double)n6 / d);
        OS.gtk_spin_button_set_value(this.handle, (double)n / d);
        OS.gtk_spin_button_set_digits(this.handle, n4);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                int n2 = this.imContext();
                if (n2 == 0) break;
                int[] nArray = new int[1];
                OS.gtk_im_context_get_preedit_string(n2, nArray, null, null);
                if (nArray[0] == 0) break;
                int n3 = OS.strlen(nArray[0]);
                OS.g_free(nArray[0]);
                if (n3 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        int n3 = OS.gtk_get_current_event();
        if (n3 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n3, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(n3);
        }
        int n4 = 0;
        if (OS.gtk_spin_button_get_digits(this.handle) > 0) {
            String string2 = this.getDecimalSeparator();
            n4 = string.indexOf(string2);
            if (n4 != -1) {
                string = String.valueOf(string.substring(0, n4)) + string.substring(n4 + 1);
            }
            n4 = 0;
        }
        if (string.length() > 0) {
            int n5 = OS.gtk_spin_button_get_adjustment(this.handle);
            GtkAdjustment gtkAdjustment = new GtkAdjustment();
            OS.memmove(gtkAdjustment, n5);
            if (gtkAdjustment.lower < 0.0 && string.charAt(0) == '-') {
                ++n4;
            }
        }
        while (n4 < string.length()) {
            if (!Character.isDigit(string.charAt(n4))) break;
            ++n4;
        }
        event.doit = n4 == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

