/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.synthesizer;

import org.herac.tuxguitar.jack.JackClient;
import org.herac.tuxguitar.jack.synthesizer.JackOutputPort;
import org.herac.tuxguitar.player.base.MidiReceiver;

public class JackReceiver
implements MidiReceiver {
    private JackClient jackClient;
    private JackOutputPort jackOutputPort;

    public JackReceiver(JackClient jackClient, JackOutputPort jackOutputPort) {
        this.jackClient = jackClient;
        this.jackOutputPort = jackOutputPort;
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(0x90 | this.jackOutputPort.getRouter().getChannelRoute(n)), (byte)n2, (byte)n3};
        this.jackClient.addEventToQueue(this.jackOutputPort.getRouter().getPortRoute(n), byArray);
    }

    public void sendNoteOff(int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(0x80 | this.jackOutputPort.getRouter().getChannelRoute(n)), (byte)n2, (byte)n3};
        this.jackClient.addEventToQueue(this.jackOutputPort.getRouter().getPortRoute(n), byArray);
    }

    public void sendPitchBend(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(0xE0 | this.jackOutputPort.getRouter().getChannelRoute(n)), 0, (byte)n2};
        this.jackClient.addEventToQueue(this.jackOutputPort.getRouter().getPortRoute(n), byArray);
    }

    public void sendControlChange(int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(0xB0 | this.jackOutputPort.getRouter().getChannelRoute(n)), (byte)n2, (byte)n3};
        this.jackClient.addEventToQueue(this.jackOutputPort.getRouter().getPortRoute(n), byArray);
    }

    public void sendProgramChange(int n, int n2) {
        this.jackOutputPort.getRouter().setProgram(n, n2);
        byte[] byArray = new byte[]{(byte)(0xC0 | this.jackOutputPort.getRouter().getChannelRoute(n)), (byte)this.jackOutputPort.getRouter().getProgramRoute(n, n2)};
        this.jackClient.addEventToQueue(this.jackOutputPort.getRouter().getPortRoute(n), byArray);
    }

    public void sendSystemReset() {
    }
}

