/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.jack.settings.JackSettingsListener;

public class JackSettings {
    private List listeners = new ArrayList();
    private TGConfigManager config = new TGPluginConfigManager("tuxguitar-jack");

    public JackSettings() {
        this.config.init();
    }

    public TGConfigManager getConfig() {
        return this.config;
    }

    public void notifyChanges() {
        this.getConfig().save();
        this.getConfig().load();
        this.fireListeners();
    }

    public void addListener(JackSettingsListener jackSettingsListener) {
        if (!this.listeners.contains(jackSettingsListener)) {
            this.listeners.add(jackSettingsListener);
        }
    }

    public void removeListener(JackSettingsListener jackSettingsListener) {
        if (this.listeners.contains(jackSettingsListener)) {
            this.listeners.remove(jackSettingsListener);
        }
    }

    public void fireListeners() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            JackSettingsListener jackSettingsListener = (JackSettingsListener)iterator.next();
            jackSettingsListener.loadSettings(this.getConfig());
        }
    }
}

