/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.jack.JackClient;
import org.herac.tuxguitar.jack.sequencer.JackEvent;
import org.herac.tuxguitar.jack.sequencer.JackEventController;
import org.herac.tuxguitar.jack.sequencer.JackEventDispacher;
import org.herac.tuxguitar.jack.sequencer.JackSequenceHandler;
import org.herac.tuxguitar.jack.sequencer.JackTickController;
import org.herac.tuxguitar.jack.sequencer.JackTrackController;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiTransmitter;

public class JackSequencer
implements MidiSequencer {
    private long transportUID = -1L;
    private long transportTryCount = 10L;
    private long transportTryNumber = 0L;
    private boolean reset;
    private boolean running = false;
    private boolean stopped = true;
    private boolean transportRunning = false;
    private boolean transportLockTick;
    private MidiTransmitter transmitter;
    private JackTickController jackTickController;
    private JackEventController jackEventController;
    private JackEventDispacher jackEventDispacher;
    private JackTrackController jackTrackController;
    private JackTimer jackTimer;
    private JackClient jackClient;

    public JackSequencer(JackClient jackClient) {
        this.jackClient = jackClient;
        this.jackTickController = new JackTickController(this);
        this.jackEventController = new JackEventController(this);
        this.jackEventDispacher = new JackEventDispacher(this);
        this.jackTrackController = new JackTrackController(this);
        this.jackTimer = new JackTimer(this);
    }

    public JackClient getJackClient() {
        return this.jackClient;
    }

    public JackTickController getJackTickController() {
        return this.jackTickController;
    }

    public JackEventController getJackEventController() {
        return this.jackEventController;
    }

    public JackTrackController getJackTrackController() {
        return this.jackTrackController;
    }

    public void setTempo(int n) {
        this.jackTickController.setTempo(n);
    }

    public long getTickPosition() {
        return Math.round(this.jackTickController.getTick());
    }

    public void setTickPosition(long l) {
        this.setTickPosition(l, !this.transportLockTick);
        this.transportLockTick = false;
    }

    public void setTickPosition(long l, boolean bl) {
        this.reset = true;
        this.jackTickController.setTick(l, bl);
    }

    public long getTickLength() {
        return this.jackTickController.getTickLength();
    }

    public void sendEvent(JackEvent jackEvent) throws MidiPlayerException {
        if (!this.reset) {
            this.jackEventDispacher.dispatch(jackEvent);
        }
    }

    public void addEvent(JackEvent jackEvent) {
        this.jackEventController.addEvent(jackEvent);
        this.jackTickController.notifyTick(jackEvent.getTick());
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() throws MidiPlayerException {
        this.start(true);
    }

    public void start(boolean bl) throws MidiPlayerException {
        if (!this.running) {
            this.setTempo(120);
            this.running = true;
            if (bl) {
                this.jackClient.setTransportStart();
            }
        }
    }

    public void stop() throws MidiPlayerException {
        this.stop(true);
    }

    public void stop(boolean bl) throws MidiPlayerException {
        if (this.running) {
            this.running = false;
            if (bl) {
                this.jackClient.setTransportStop();
            }
        }
    }

    public void reset(boolean bl) throws MidiPlayerException {
        this.getTransmitter().sendAllNotesOff();
        for (int i = 0; i < 16; ++i) {
            this.getTransmitter().sendPitchBend(i, 64);
        }
        if (bl) {
            this.getTransmitter().sendSystemReset();
        }
    }

    protected void startPlayer() {
        if (this.transmitter != null) {
            this.transportLockTick = true;
            TuxGuitar.instance().getTransport().play();
        }
    }

    public MidiTransmitter getTransmitter() {
        return this.transmitter;
    }

    public void setTransmitter(MidiTransmitter midiTransmitter) {
        this.transmitter = midiTransmitter;
    }

    public void open() {
        if (!this.jackClient.isTransportOpen()) {
            this.jackClient.openTransport();
        }
        this.jackTimer.setRunning(true);
    }

    public void close() throws MidiPlayerException {
        this.jackTimer.setRunning(false);
        if (this.isRunning()) {
            this.stop();
        }
        if (this.jackClient.isTransportOpen()) {
            this.jackClient.closeTransport();
        }
    }

    public void check() throws MidiPlayerException {
        if (!this.jackClient.isServerRunning() || !this.jackClient.isTransportOpen()) {
            this.open();
            if (!this.jackClient.isServerRunning() || !this.jackClient.isTransportOpen()) {
                throw new MidiPlayerException("Jack server not running?");
            }
        }
    }

    public MidiSequenceHandler createSequence(int n) throws MidiPlayerException {
        return new JackSequenceHandler(this, n);
    }

    public void setSolo(int n, boolean bl) throws MidiPlayerException {
        this.getJackTrackController().setSolo(n, bl);
    }

    public void setMute(int n, boolean bl) throws MidiPlayerException {
        this.getJackTrackController().setMute(n, bl);
    }

    public String getKey() {
        return "tuxguitar-jack";
    }

    public String getName() {
        return "Jack Sequencer";
    }

    protected void process() throws MidiPlayerException {
        boolean bl = this.jackClient.isTransportRunning();
        if (this.transportRunning != bl) {
            if (bl && !this.running) {
                this.startPlayer();
            } else if (!bl) {
                this.running = false;
            }
        } else if (this.running && bl) {
            long l = this.jackClient.getTransportUID();
            if (this.transportUID != l) {
                this.setTickPosition(0L, false);
            }
            if (this.reset) {
                this.reset(false);
                this.reset = false;
                this.jackEventController.reset();
            }
            this.stopped = false;
            this.jackTickController.process();
            this.jackEventController.process();
            if (this.getTickPosition() > this.getTickLength()) {
                this.stop(true);
            }
            this.transportUID = l;
        } else if (!this.stopped) {
            this.stopped = true;
            this.jackEventController.clearEvents();
            this.jackTickController.clearTick();
            this.reset(true);
        } else if (this.running && this.transportTryNumber++ > this.transportTryCount) {
            this.running = false;
            this.transportTryNumber = 0L;
        }
        this.transportRunning = bl;
    }

    private class JackTimer
    implements Runnable {
        private static final int TIMER_DELAY = 10;
        private Object sequencerSync = new Object();
        private JackSequencer sequencer;
        private boolean running;

        public JackTimer(JackSequencer jackSequencer2) {
            this.sequencer = jackSequencer2;
            this.running = false;
        }

        public void setRunning(boolean bl) {
            this.running = bl;
            if (this.running) {
                new Thread(this).start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.sequencerSync;
                synchronized (object) {
                    while (this.running) {
                        this.sequencer.process();
                        this.sequencerSync.wait(10L);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

