/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.jack.sequencer.JackEvent;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;
import org.herac.tuxguitar.player.base.MidiPlayerException;

public class JackEventController {
    private JackSequencer sequencer;
    private List events;
    private double tick;
    private double lastTick;
    private boolean reset;

    public JackEventController(JackSequencer jackSequencer) {
        this.sequencer = jackSequencer;
        this.events = new ArrayList();
        this.reset();
    }

    public void process() throws MidiPlayerException {
        this.lastTick = this.tick;
        this.tick = this.sequencer.getJackTickController().getTick();
        for (int i = 0; i < this.events.size(); ++i) {
            JackEvent jackEvent = (JackEvent)this.events.get(i);
            if (!this.shouldSend(jackEvent, this.tick, this.lastTick)) continue;
            this.sequencer.sendEvent(jackEvent);
        }
        this.reset = false;
    }

    private boolean shouldSend(JackEvent jackEvent, double d, double d2) {
        if ((double)jackEvent.getTick() > d) {
            return false;
        }
        if (jackEvent.getTrack() != -1) {
            if (this.sequencer.getJackTrackController().isMute(jackEvent.getTrack())) {
                return false;
            }
            if (this.sequencer.getJackTrackController().isAnySolo() && !this.sequencer.getJackTrackController().isSolo(jackEvent.getTrack())) {
                return false;
            }
        }
        if (this.reset) {
            if (jackEvent.getType() == 1) {
                return true;
            }
            if (jackEvent.getType() == 5) {
                return true;
            }
            if (jackEvent.getType() == 4) {
                return true;
            }
        }
        return (double)jackEvent.getTick() > d2;
    }

    public List getEvents() {
        return this.events;
    }

    public void addEvent(JackEvent jackEvent) {
        this.events.add(jackEvent);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void reset() {
        this.tick = this.sequencer.getTickPosition() - 120L;
        this.reset = true;
    }

    public List getTempoChanges() {
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        for (int i = 0; i < this.events.size(); ++i) {
            JackEvent jackEvent = (JackEvent)this.events.get(i);
            if (jackEvent.getType() != 1 || jackEvent.getData()[0] != 81) continue;
            int n = jackEvent.getData()[1] & 0xFF | (jackEvent.getData()[2] & 0xFF) << 8 | (jackEvent.getData()[3] & 0xFF) << 16;
            long[] lArray = new long[]{jackEvent.getTick(), (long)(60000.0 / ((double)n / 1000.0))};
            arrayList.add(lArray);
        }
        return arrayList;
    }
}

